import React, {useState, useEffect} from "react"
import axios from "axios"
import {CarTable} from "./CarTable"


export const DisplayAllCars = props =>
{
    const [cars, setCars] = useState([])


    useEffect(() =>
    {
        axios.get("json/cars.json")
        .then(res =>
        {
            if(res.data)
            {
                setCars(res.data)
            }
            else
            {
                console.log("Records not found")
            }
        })
    }, [])


    return (
    <div className="form-container">
        <div className="table-container">
            <CarTable cars={cars}/> 
        </div>
    </div>
    )
}