import React, {useState} from "react"
import {Redirect} from "react-router-dom"
import axios from "axios"
import {Button} from "../components/Button"
import {SERVER_HOST} from "../config/global_constants"


export const Logout = props =>
{
    const [isLoggedIn, setIsLoggedIn] = useState(true)


    const handleSubmit = (e) =>
    {
        e.preventDefault()

        axios.post(`${SERVER_HOST}/users/logout`)
        .then(res =>
        {
            localStorage.clear()

            setIsLoggedIn(false)
        })
        .catch(err => console.log(`${err.response.data}\n${err}`))
    }


    return (
    <div>   
    
        {!isLoggedIn ? <Redirect to="/DisplayAllCars"/> : null} 
    
        <Button value="Log out" className="red-button" onClick={handleSubmit}/> 
    </div>
    )
}