import firebase from '@firebase/app';
import '@firebase/logger';
import '@firebase/util';
import '@firebase/webchannel-wrapper';
import { U as Uu, n as na, z, L, j as ju, W as Wu, G as Gu, Y as Yu, Z as Zu, X as Xu, e as eh, a as nh, i as ih, r as rh, K as Ku, b as Xa, c as Za, B as Bu } from './prebuilt-db9afa01.js';
import { Component } from '@firebase/component';

const name = "@firebase/firestore";
const version = "2.1.2";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const firestoreNamespace = {
    Firestore: Uu,
    GeoPoint: na,
    Timestamp: z,
    Blob: L,
    Transaction: ju,
    WriteBatch: Wu,
    DocumentReference: Gu,
    DocumentSnapshot: Yu,
    Query: Zu,
    QueryDocumentSnapshot: Xu,
    QuerySnapshot: eh,
    CollectionReference: nh,
    FieldPath: ih,
    FieldValue: rh,
    setLogLevel: Ku,
    CACHE_SIZE_UNLIMITED: Xa
};
/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase - The FirebaseNamespace to register Firestore with
 * @param firestoreFactory - A factory function that returns a new Firestore
 *    instance.
 */
function configureForFirebase(firebase, firestoreFactory) {
    firebase.INTERNAL.registerComponent(new Component('firestore', container => {
        const app = container.getProvider('app').getImmediate();
        return firestoreFactory(app, container.getProvider('auth-internal'));
    }, "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, firestoreNamespace)));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the memory-only Firestore build with the components framework.
 */
function registerFirestore(instance) {
    configureForFirebase(instance, (app, auth) => new Uu(app, new Za(app, auth), new Bu()));
    instance.registerVersion(name, version);
}
registerFirestore(firebase);

export { registerFirestore };
//# sourceMappingURL=index.js.map
