// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_datastore_protos || ($protobuf.roots._google_cloud_datastore_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.datastore = (function() {
    
            /**
             * Namespace datastore.
             * @memberof google
             * @namespace
             */
            var datastore = {};
    
            datastore.admin = (function() {
    
                /**
                 * Namespace admin.
                 * @memberof google.datastore
                 * @namespace
                 */
                var admin = {};
    
                admin.v1 = (function() {
    
                    /**
                     * Namespace v1.
                     * @memberof google.datastore.admin
                     * @namespace
                     */
                    var v1 = {};
    
                    v1.DatastoreAdmin = (function() {
    
                        /**
                         * Constructs a new DatastoreAdmin service.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents a DatastoreAdmin
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function DatastoreAdmin(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (DatastoreAdmin.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = DatastoreAdmin;
    
                        /**
                         * Creates new DatastoreAdmin service using the specified rpc implementation.
                         * @function create
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {DatastoreAdmin} RPC service. Useful where requests and/or responses are streamed.
                         */
                        DatastoreAdmin.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.datastore.admin.v1.DatastoreAdmin#exportEntities}.
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @typedef ExportEntitiesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ExportEntities.
                         * @function exportEntities
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IExportEntitiesRequest} request ExportEntitiesRequest message or plain object
                         * @param {google.datastore.admin.v1.DatastoreAdmin.ExportEntitiesCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(DatastoreAdmin.prototype.exportEntities = function exportEntities(request, callback) {
                            return this.rpcCall(exportEntities, $root.google.datastore.admin.v1.ExportEntitiesRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ExportEntities" });
    
                        /**
                         * Calls ExportEntities.
                         * @function exportEntities
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IExportEntitiesRequest} request ExportEntitiesRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.datastore.admin.v1.DatastoreAdmin#importEntities}.
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @typedef ImportEntitiesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ImportEntities.
                         * @function importEntities
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IImportEntitiesRequest} request ImportEntitiesRequest message or plain object
                         * @param {google.datastore.admin.v1.DatastoreAdmin.ImportEntitiesCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(DatastoreAdmin.prototype.importEntities = function importEntities(request, callback) {
                            return this.rpcCall(importEntities, $root.google.datastore.admin.v1.ImportEntitiesRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ImportEntities" });
    
                        /**
                         * Calls ImportEntities.
                         * @function importEntities
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IImportEntitiesRequest} request ImportEntitiesRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.datastore.admin.v1.DatastoreAdmin#getIndex}.
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @typedef GetIndexCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.datastore.admin.v1.Index} [response] Index
                         */
    
                        /**
                         * Calls GetIndex.
                         * @function getIndex
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IGetIndexRequest} request GetIndexRequest message or plain object
                         * @param {google.datastore.admin.v1.DatastoreAdmin.GetIndexCallback} callback Node-style callback called with the error, if any, and Index
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(DatastoreAdmin.prototype.getIndex = function getIndex(request, callback) {
                            return this.rpcCall(getIndex, $root.google.datastore.admin.v1.GetIndexRequest, $root.google.datastore.admin.v1.Index, request, callback);
                        }, "name", { value: "GetIndex" });
    
                        /**
                         * Calls GetIndex.
                         * @function getIndex
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IGetIndexRequest} request GetIndexRequest message or plain object
                         * @returns {Promise<google.datastore.admin.v1.Index>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.datastore.admin.v1.DatastoreAdmin#listIndexes}.
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @typedef ListIndexesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.datastore.admin.v1.ListIndexesResponse} [response] ListIndexesResponse
                         */
    
                        /**
                         * Calls ListIndexes.
                         * @function listIndexes
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IListIndexesRequest} request ListIndexesRequest message or plain object
                         * @param {google.datastore.admin.v1.DatastoreAdmin.ListIndexesCallback} callback Node-style callback called with the error, if any, and ListIndexesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(DatastoreAdmin.prototype.listIndexes = function listIndexes(request, callback) {
                            return this.rpcCall(listIndexes, $root.google.datastore.admin.v1.ListIndexesRequest, $root.google.datastore.admin.v1.ListIndexesResponse, request, callback);
                        }, "name", { value: "ListIndexes" });
    
                        /**
                         * Calls ListIndexes.
                         * @function listIndexes
                         * @memberof google.datastore.admin.v1.DatastoreAdmin
                         * @instance
                         * @param {google.datastore.admin.v1.IListIndexesRequest} request ListIndexesRequest message or plain object
                         * @returns {Promise<google.datastore.admin.v1.ListIndexesResponse>} Promise
                         * @variation 2
                         */
    
                        return DatastoreAdmin;
                    })();
    
                    v1.CommonMetadata = (function() {
    
                        /**
                         * Properties of a CommonMetadata.
                         * @memberof google.datastore.admin.v1
                         * @interface ICommonMetadata
                         * @property {google.protobuf.ITimestamp|null} [startTime] CommonMetadata startTime
                         * @property {google.protobuf.ITimestamp|null} [endTime] CommonMetadata endTime
                         * @property {google.datastore.admin.v1.OperationType|null} [operationType] CommonMetadata operationType
                         * @property {Object.<string,string>|null} [labels] CommonMetadata labels
                         * @property {google.datastore.admin.v1.CommonMetadata.State|null} [state] CommonMetadata state
                         */
    
                        /**
                         * Constructs a new CommonMetadata.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents a CommonMetadata.
                         * @implements ICommonMetadata
                         * @constructor
                         * @param {google.datastore.admin.v1.ICommonMetadata=} [properties] Properties to set
                         */
                        function CommonMetadata(properties) {
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CommonMetadata startTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} startTime
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @instance
                         */
                        CommonMetadata.prototype.startTime = null;
    
                        /**
                         * CommonMetadata endTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} endTime
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @instance
                         */
                        CommonMetadata.prototype.endTime = null;
    
                        /**
                         * CommonMetadata operationType.
                         * @member {google.datastore.admin.v1.OperationType} operationType
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @instance
                         */
                        CommonMetadata.prototype.operationType = 0;
    
                        /**
                         * CommonMetadata labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @instance
                         */
                        CommonMetadata.prototype.labels = $util.emptyObject;
    
                        /**
                         * CommonMetadata state.
                         * @member {google.datastore.admin.v1.CommonMetadata.State} state
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @instance
                         */
                        CommonMetadata.prototype.state = 0;
    
                        /**
                         * Creates a new CommonMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {google.datastore.admin.v1.ICommonMetadata=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.CommonMetadata} CommonMetadata instance
                         */
                        CommonMetadata.create = function create(properties) {
                            return new CommonMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified CommonMetadata message. Does not implicitly {@link google.datastore.admin.v1.CommonMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {google.datastore.admin.v1.ICommonMetadata} message CommonMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CommonMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.startTime != null && Object.hasOwnProperty.call(message, "startTime"))
                                $root.google.protobuf.Timestamp.encode(message.startTime, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.endTime != null && Object.hasOwnProperty.call(message, "endTime"))
                                $root.google.protobuf.Timestamp.encode(message.endTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.operationType != null && Object.hasOwnProperty.call(message, "operationType"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.operationType);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 4, wireType 2 =*/34).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.state);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CommonMetadata message, length delimited. Does not implicitly {@link google.datastore.admin.v1.CommonMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {google.datastore.admin.v1.ICommonMetadata} message CommonMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CommonMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CommonMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.CommonMetadata} CommonMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CommonMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.CommonMetadata(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.startTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.endTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.operationType = reader.int32();
                                    break;
                                case 4:
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                case 5:
                                    message.state = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CommonMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.CommonMetadata} CommonMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CommonMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CommonMetadata message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CommonMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.startTime != null && message.hasOwnProperty("startTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.startTime);
                                if (error)
                                    return "startTime." + error;
                            }
                            if (message.endTime != null && message.hasOwnProperty("endTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.endTime);
                                if (error)
                                    return "endTime." + error;
                            }
                            if (message.operationType != null && message.hasOwnProperty("operationType"))
                                switch (message.operationType) {
                                default:
                                    return "operationType: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                    break;
                                }
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a CommonMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.CommonMetadata} CommonMetadata
                         */
                        CommonMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.CommonMetadata)
                                return object;
                            var message = new $root.google.datastore.admin.v1.CommonMetadata();
                            if (object.startTime != null) {
                                if (typeof object.startTime !== "object")
                                    throw TypeError(".google.datastore.admin.v1.CommonMetadata.startTime: object expected");
                                message.startTime = $root.google.protobuf.Timestamp.fromObject(object.startTime);
                            }
                            if (object.endTime != null) {
                                if (typeof object.endTime !== "object")
                                    throw TypeError(".google.datastore.admin.v1.CommonMetadata.endTime: object expected");
                                message.endTime = $root.google.protobuf.Timestamp.fromObject(object.endTime);
                            }
                            switch (object.operationType) {
                            case "OPERATION_TYPE_UNSPECIFIED":
                            case 0:
                                message.operationType = 0;
                                break;
                            case "EXPORT_ENTITIES":
                            case 1:
                                message.operationType = 1;
                                break;
                            case "IMPORT_ENTITIES":
                            case 2:
                                message.operationType = 2;
                                break;
                            case "CREATE_INDEX":
                            case 3:
                                message.operationType = 3;
                                break;
                            case "DELETE_INDEX":
                            case 4:
                                message.operationType = 4;
                                break;
                            }
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.datastore.admin.v1.CommonMetadata.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            switch (object.state) {
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "INITIALIZING":
                            case 1:
                                message.state = 1;
                                break;
                            case "PROCESSING":
                            case 2:
                                message.state = 2;
                                break;
                            case "CANCELLING":
                            case 3:
                                message.state = 3;
                                break;
                            case "FINALIZING":
                            case 4:
                                message.state = 4;
                                break;
                            case "SUCCESSFUL":
                            case 5:
                                message.state = 5;
                                break;
                            case "FAILED":
                            case 6:
                                message.state = 6;
                                break;
                            case "CANCELLED":
                            case 7:
                                message.state = 7;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CommonMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @static
                         * @param {google.datastore.admin.v1.CommonMetadata} message CommonMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CommonMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults) {
                                object.startTime = null;
                                object.endTime = null;
                                object.operationType = options.enums === String ? "OPERATION_TYPE_UNSPECIFIED" : 0;
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                            }
                            if (message.startTime != null && message.hasOwnProperty("startTime"))
                                object.startTime = $root.google.protobuf.Timestamp.toObject(message.startTime, options);
                            if (message.endTime != null && message.hasOwnProperty("endTime"))
                                object.endTime = $root.google.protobuf.Timestamp.toObject(message.endTime, options);
                            if (message.operationType != null && message.hasOwnProperty("operationType"))
                                object.operationType = options.enums === String ? $root.google.datastore.admin.v1.OperationType[message.operationType] : message.operationType;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.datastore.admin.v1.CommonMetadata.State[message.state] : message.state;
                            return object;
                        };
    
                        /**
                         * Converts this CommonMetadata to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.CommonMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CommonMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * State enum.
                         * @name google.datastore.admin.v1.CommonMetadata.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} INITIALIZING=1 INITIALIZING value
                         * @property {number} PROCESSING=2 PROCESSING value
                         * @property {number} CANCELLING=3 CANCELLING value
                         * @property {number} FINALIZING=4 FINALIZING value
                         * @property {number} SUCCESSFUL=5 SUCCESSFUL value
                         * @property {number} FAILED=6 FAILED value
                         * @property {number} CANCELLED=7 CANCELLED value
                         */
                        CommonMetadata.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "INITIALIZING"] = 1;
                            values[valuesById[2] = "PROCESSING"] = 2;
                            values[valuesById[3] = "CANCELLING"] = 3;
                            values[valuesById[4] = "FINALIZING"] = 4;
                            values[valuesById[5] = "SUCCESSFUL"] = 5;
                            values[valuesById[6] = "FAILED"] = 6;
                            values[valuesById[7] = "CANCELLED"] = 7;
                            return values;
                        })();
    
                        return CommonMetadata;
                    })();
    
                    /**
                     * OperationType enum.
                     * @name google.datastore.admin.v1.OperationType
                     * @enum {number}
                     * @property {number} OPERATION_TYPE_UNSPECIFIED=0 OPERATION_TYPE_UNSPECIFIED value
                     * @property {number} EXPORT_ENTITIES=1 EXPORT_ENTITIES value
                     * @property {number} IMPORT_ENTITIES=2 IMPORT_ENTITIES value
                     * @property {number} CREATE_INDEX=3 CREATE_INDEX value
                     * @property {number} DELETE_INDEX=4 DELETE_INDEX value
                     */
                    v1.OperationType = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "OPERATION_TYPE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "EXPORT_ENTITIES"] = 1;
                        values[valuesById[2] = "IMPORT_ENTITIES"] = 2;
                        values[valuesById[3] = "CREATE_INDEX"] = 3;
                        values[valuesById[4] = "DELETE_INDEX"] = 4;
                        return values;
                    })();
    
                    v1.Progress = (function() {
    
                        /**
                         * Properties of a Progress.
                         * @memberof google.datastore.admin.v1
                         * @interface IProgress
                         * @property {number|Long|null} [workCompleted] Progress workCompleted
                         * @property {number|Long|null} [workEstimated] Progress workEstimated
                         */
    
                        /**
                         * Constructs a new Progress.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents a Progress.
                         * @implements IProgress
                         * @constructor
                         * @param {google.datastore.admin.v1.IProgress=} [properties] Properties to set
                         */
                        function Progress(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Progress workCompleted.
                         * @member {number|Long} workCompleted
                         * @memberof google.datastore.admin.v1.Progress
                         * @instance
                         */
                        Progress.prototype.workCompleted = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * Progress workEstimated.
                         * @member {number|Long} workEstimated
                         * @memberof google.datastore.admin.v1.Progress
                         * @instance
                         */
                        Progress.prototype.workEstimated = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * Creates a new Progress instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {google.datastore.admin.v1.IProgress=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.Progress} Progress instance
                         */
                        Progress.create = function create(properties) {
                            return new Progress(properties);
                        };
    
                        /**
                         * Encodes the specified Progress message. Does not implicitly {@link google.datastore.admin.v1.Progress.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {google.datastore.admin.v1.IProgress} message Progress message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Progress.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.workCompleted != null && Object.hasOwnProperty.call(message, "workCompleted"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.workCompleted);
                            if (message.workEstimated != null && Object.hasOwnProperty.call(message, "workEstimated"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.workEstimated);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Progress message, length delimited. Does not implicitly {@link google.datastore.admin.v1.Progress.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {google.datastore.admin.v1.IProgress} message Progress message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Progress.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Progress message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.Progress} Progress
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Progress.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.Progress();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.workCompleted = reader.int64();
                                    break;
                                case 2:
                                    message.workEstimated = reader.int64();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Progress message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.Progress} Progress
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Progress.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Progress message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Progress.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.workCompleted != null && message.hasOwnProperty("workCompleted"))
                                if (!$util.isInteger(message.workCompleted) && !(message.workCompleted && $util.isInteger(message.workCompleted.low) && $util.isInteger(message.workCompleted.high)))
                                    return "workCompleted: integer|Long expected";
                            if (message.workEstimated != null && message.hasOwnProperty("workEstimated"))
                                if (!$util.isInteger(message.workEstimated) && !(message.workEstimated && $util.isInteger(message.workEstimated.low) && $util.isInteger(message.workEstimated.high)))
                                    return "workEstimated: integer|Long expected";
                            return null;
                        };
    
                        /**
                         * Creates a Progress message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.Progress} Progress
                         */
                        Progress.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.Progress)
                                return object;
                            var message = new $root.google.datastore.admin.v1.Progress();
                            if (object.workCompleted != null)
                                if ($util.Long)
                                    (message.workCompleted = $util.Long.fromValue(object.workCompleted)).unsigned = false;
                                else if (typeof object.workCompleted === "string")
                                    message.workCompleted = parseInt(object.workCompleted, 10);
                                else if (typeof object.workCompleted === "number")
                                    message.workCompleted = object.workCompleted;
                                else if (typeof object.workCompleted === "object")
                                    message.workCompleted = new $util.LongBits(object.workCompleted.low >>> 0, object.workCompleted.high >>> 0).toNumber();
                            if (object.workEstimated != null)
                                if ($util.Long)
                                    (message.workEstimated = $util.Long.fromValue(object.workEstimated)).unsigned = false;
                                else if (typeof object.workEstimated === "string")
                                    message.workEstimated = parseInt(object.workEstimated, 10);
                                else if (typeof object.workEstimated === "number")
                                    message.workEstimated = object.workEstimated;
                                else if (typeof object.workEstimated === "object")
                                    message.workEstimated = new $util.LongBits(object.workEstimated.low >>> 0, object.workEstimated.high >>> 0).toNumber();
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Progress message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.Progress
                         * @static
                         * @param {google.datastore.admin.v1.Progress} message Progress
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Progress.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.workCompleted = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.workCompleted = options.longs === String ? "0" : 0;
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.workEstimated = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.workEstimated = options.longs === String ? "0" : 0;
                            }
                            if (message.workCompleted != null && message.hasOwnProperty("workCompleted"))
                                if (typeof message.workCompleted === "number")
                                    object.workCompleted = options.longs === String ? String(message.workCompleted) : message.workCompleted;
                                else
                                    object.workCompleted = options.longs === String ? $util.Long.prototype.toString.call(message.workCompleted) : options.longs === Number ? new $util.LongBits(message.workCompleted.low >>> 0, message.workCompleted.high >>> 0).toNumber() : message.workCompleted;
                            if (message.workEstimated != null && message.hasOwnProperty("workEstimated"))
                                if (typeof message.workEstimated === "number")
                                    object.workEstimated = options.longs === String ? String(message.workEstimated) : message.workEstimated;
                                else
                                    object.workEstimated = options.longs === String ? $util.Long.prototype.toString.call(message.workEstimated) : options.longs === Number ? new $util.LongBits(message.workEstimated.low >>> 0, message.workEstimated.high >>> 0).toNumber() : message.workEstimated;
                            return object;
                        };
    
                        /**
                         * Converts this Progress to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.Progress
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Progress.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return Progress;
                    })();
    
                    v1.ExportEntitiesRequest = (function() {
    
                        /**
                         * Properties of an ExportEntitiesRequest.
                         * @memberof google.datastore.admin.v1
                         * @interface IExportEntitiesRequest
                         * @property {string|null} [projectId] ExportEntitiesRequest projectId
                         * @property {Object.<string,string>|null} [labels] ExportEntitiesRequest labels
                         * @property {google.datastore.admin.v1.IEntityFilter|null} [entityFilter] ExportEntitiesRequest entityFilter
                         * @property {string|null} [outputUrlPrefix] ExportEntitiesRequest outputUrlPrefix
                         */
    
                        /**
                         * Constructs a new ExportEntitiesRequest.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an ExportEntitiesRequest.
                         * @implements IExportEntitiesRequest
                         * @constructor
                         * @param {google.datastore.admin.v1.IExportEntitiesRequest=} [properties] Properties to set
                         */
                        function ExportEntitiesRequest(properties) {
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExportEntitiesRequest projectId.
                         * @member {string} projectId
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @instance
                         */
                        ExportEntitiesRequest.prototype.projectId = "";
    
                        /**
                         * ExportEntitiesRequest labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @instance
                         */
                        ExportEntitiesRequest.prototype.labels = $util.emptyObject;
    
                        /**
                         * ExportEntitiesRequest entityFilter.
                         * @member {google.datastore.admin.v1.IEntityFilter|null|undefined} entityFilter
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @instance
                         */
                        ExportEntitiesRequest.prototype.entityFilter = null;
    
                        /**
                         * ExportEntitiesRequest outputUrlPrefix.
                         * @member {string} outputUrlPrefix
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @instance
                         */
                        ExportEntitiesRequest.prototype.outputUrlPrefix = "";
    
                        /**
                         * Creates a new ExportEntitiesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesRequest=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.ExportEntitiesRequest} ExportEntitiesRequest instance
                         */
                        ExportEntitiesRequest.create = function create(properties) {
                            return new ExportEntitiesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ExportEntitiesRequest message. Does not implicitly {@link google.datastore.admin.v1.ExportEntitiesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesRequest} message ExportEntitiesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportEntitiesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.projectId);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            if (message.entityFilter != null && Object.hasOwnProperty.call(message, "entityFilter"))
                                $root.google.datastore.admin.v1.EntityFilter.encode(message.entityFilter, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.outputUrlPrefix != null && Object.hasOwnProperty.call(message, "outputUrlPrefix"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.outputUrlPrefix);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExportEntitiesRequest message, length delimited. Does not implicitly {@link google.datastore.admin.v1.ExportEntitiesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesRequest} message ExportEntitiesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportEntitiesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExportEntitiesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.ExportEntitiesRequest} ExportEntitiesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportEntitiesRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.ExportEntitiesRequest(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.projectId = reader.string();
                                    break;
                                case 2:
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                case 3:
                                    message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.outputUrlPrefix = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExportEntitiesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.ExportEntitiesRequest} ExportEntitiesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportEntitiesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExportEntitiesRequest message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExportEntitiesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                if (!$util.isString(message.projectId))
                                    return "projectId: string expected";
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter")) {
                                var error = $root.google.datastore.admin.v1.EntityFilter.verify(message.entityFilter);
                                if (error)
                                    return "entityFilter." + error;
                            }
                            if (message.outputUrlPrefix != null && message.hasOwnProperty("outputUrlPrefix"))
                                if (!$util.isString(message.outputUrlPrefix))
                                    return "outputUrlPrefix: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ExportEntitiesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.ExportEntitiesRequest} ExportEntitiesRequest
                         */
                        ExportEntitiesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.ExportEntitiesRequest)
                                return object;
                            var message = new $root.google.datastore.admin.v1.ExportEntitiesRequest();
                            if (object.projectId != null)
                                message.projectId = String(object.projectId);
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ExportEntitiesRequest.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            if (object.entityFilter != null) {
                                if (typeof object.entityFilter !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ExportEntitiesRequest.entityFilter: object expected");
                                message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.fromObject(object.entityFilter);
                            }
                            if (object.outputUrlPrefix != null)
                                message.outputUrlPrefix = String(object.outputUrlPrefix);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExportEntitiesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.ExportEntitiesRequest} message ExportEntitiesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExportEntitiesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults) {
                                object.projectId = "";
                                object.entityFilter = null;
                                object.outputUrlPrefix = "";
                            }
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                object.projectId = message.projectId;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter"))
                                object.entityFilter = $root.google.datastore.admin.v1.EntityFilter.toObject(message.entityFilter, options);
                            if (message.outputUrlPrefix != null && message.hasOwnProperty("outputUrlPrefix"))
                                object.outputUrlPrefix = message.outputUrlPrefix;
                            return object;
                        };
    
                        /**
                         * Converts this ExportEntitiesRequest to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.ExportEntitiesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExportEntitiesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ExportEntitiesRequest;
                    })();
    
                    v1.ImportEntitiesRequest = (function() {
    
                        /**
                         * Properties of an ImportEntitiesRequest.
                         * @memberof google.datastore.admin.v1
                         * @interface IImportEntitiesRequest
                         * @property {string|null} [projectId] ImportEntitiesRequest projectId
                         * @property {Object.<string,string>|null} [labels] ImportEntitiesRequest labels
                         * @property {string|null} [inputUrl] ImportEntitiesRequest inputUrl
                         * @property {google.datastore.admin.v1.IEntityFilter|null} [entityFilter] ImportEntitiesRequest entityFilter
                         */
    
                        /**
                         * Constructs a new ImportEntitiesRequest.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an ImportEntitiesRequest.
                         * @implements IImportEntitiesRequest
                         * @constructor
                         * @param {google.datastore.admin.v1.IImportEntitiesRequest=} [properties] Properties to set
                         */
                        function ImportEntitiesRequest(properties) {
                            this.labels = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImportEntitiesRequest projectId.
                         * @member {string} projectId
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @instance
                         */
                        ImportEntitiesRequest.prototype.projectId = "";
    
                        /**
                         * ImportEntitiesRequest labels.
                         * @member {Object.<string,string>} labels
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @instance
                         */
                        ImportEntitiesRequest.prototype.labels = $util.emptyObject;
    
                        /**
                         * ImportEntitiesRequest inputUrl.
                         * @member {string} inputUrl
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @instance
                         */
                        ImportEntitiesRequest.prototype.inputUrl = "";
    
                        /**
                         * ImportEntitiesRequest entityFilter.
                         * @member {google.datastore.admin.v1.IEntityFilter|null|undefined} entityFilter
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @instance
                         */
                        ImportEntitiesRequest.prototype.entityFilter = null;
    
                        /**
                         * Creates a new ImportEntitiesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IImportEntitiesRequest=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.ImportEntitiesRequest} ImportEntitiesRequest instance
                         */
                        ImportEntitiesRequest.create = function create(properties) {
                            return new ImportEntitiesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ImportEntitiesRequest message. Does not implicitly {@link google.datastore.admin.v1.ImportEntitiesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IImportEntitiesRequest} message ImportEntitiesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportEntitiesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.projectId);
                            if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                                for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                            if (message.inputUrl != null && Object.hasOwnProperty.call(message, "inputUrl"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.inputUrl);
                            if (message.entityFilter != null && Object.hasOwnProperty.call(message, "entityFilter"))
                                $root.google.datastore.admin.v1.EntityFilter.encode(message.entityFilter, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImportEntitiesRequest message, length delimited. Does not implicitly {@link google.datastore.admin.v1.ImportEntitiesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IImportEntitiesRequest} message ImportEntitiesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportEntitiesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImportEntitiesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.ImportEntitiesRequest} ImportEntitiesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportEntitiesRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.ImportEntitiesRequest(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.projectId = reader.string();
                                    break;
                                case 2:
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                case 3:
                                    message.inputUrl = reader.string();
                                    break;
                                case 4:
                                    message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImportEntitiesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.ImportEntitiesRequest} ImportEntitiesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportEntitiesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImportEntitiesRequest message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImportEntitiesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                if (!$util.isString(message.projectId))
                                    return "projectId: string expected";
                            if (message.labels != null && message.hasOwnProperty("labels")) {
                                if (!$util.isObject(message.labels))
                                    return "labels: object expected";
                                var key = Object.keys(message.labels);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.labels[key[i]]))
                                        return "labels: string{k:string} expected";
                            }
                            if (message.inputUrl != null && message.hasOwnProperty("inputUrl"))
                                if (!$util.isString(message.inputUrl))
                                    return "inputUrl: string expected";
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter")) {
                                var error = $root.google.datastore.admin.v1.EntityFilter.verify(message.entityFilter);
                                if (error)
                                    return "entityFilter." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ImportEntitiesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.ImportEntitiesRequest} ImportEntitiesRequest
                         */
                        ImportEntitiesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.ImportEntitiesRequest)
                                return object;
                            var message = new $root.google.datastore.admin.v1.ImportEntitiesRequest();
                            if (object.projectId != null)
                                message.projectId = String(object.projectId);
                            if (object.labels) {
                                if (typeof object.labels !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ImportEntitiesRequest.labels: object expected");
                                message.labels = {};
                                for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                    message.labels[keys[i]] = String(object.labels[keys[i]]);
                            }
                            if (object.inputUrl != null)
                                message.inputUrl = String(object.inputUrl);
                            if (object.entityFilter != null) {
                                if (typeof object.entityFilter !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ImportEntitiesRequest.entityFilter: object expected");
                                message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.fromObject(object.entityFilter);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImportEntitiesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @static
                         * @param {google.datastore.admin.v1.ImportEntitiesRequest} message ImportEntitiesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImportEntitiesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.labels = {};
                            if (options.defaults) {
                                object.projectId = "";
                                object.inputUrl = "";
                                object.entityFilter = null;
                            }
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                object.projectId = message.projectId;
                            var keys2;
                            if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                                object.labels = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.labels[keys2[j]] = message.labels[keys2[j]];
                            }
                            if (message.inputUrl != null && message.hasOwnProperty("inputUrl"))
                                object.inputUrl = message.inputUrl;
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter"))
                                object.entityFilter = $root.google.datastore.admin.v1.EntityFilter.toObject(message.entityFilter, options);
                            return object;
                        };
    
                        /**
                         * Converts this ImportEntitiesRequest to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.ImportEntitiesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImportEntitiesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ImportEntitiesRequest;
                    })();
    
                    v1.ExportEntitiesResponse = (function() {
    
                        /**
                         * Properties of an ExportEntitiesResponse.
                         * @memberof google.datastore.admin.v1
                         * @interface IExportEntitiesResponse
                         * @property {string|null} [outputUrl] ExportEntitiesResponse outputUrl
                         */
    
                        /**
                         * Constructs a new ExportEntitiesResponse.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an ExportEntitiesResponse.
                         * @implements IExportEntitiesResponse
                         * @constructor
                         * @param {google.datastore.admin.v1.IExportEntitiesResponse=} [properties] Properties to set
                         */
                        function ExportEntitiesResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExportEntitiesResponse outputUrl.
                         * @member {string} outputUrl
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @instance
                         */
                        ExportEntitiesResponse.prototype.outputUrl = "";
    
                        /**
                         * Creates a new ExportEntitiesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesResponse=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.ExportEntitiesResponse} ExportEntitiesResponse instance
                         */
                        ExportEntitiesResponse.create = function create(properties) {
                            return new ExportEntitiesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ExportEntitiesResponse message. Does not implicitly {@link google.datastore.admin.v1.ExportEntitiesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesResponse} message ExportEntitiesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportEntitiesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.outputUrl != null && Object.hasOwnProperty.call(message, "outputUrl"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.outputUrl);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExportEntitiesResponse message, length delimited. Does not implicitly {@link google.datastore.admin.v1.ExportEntitiesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesResponse} message ExportEntitiesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportEntitiesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExportEntitiesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.ExportEntitiesResponse} ExportEntitiesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportEntitiesResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.ExportEntitiesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.outputUrl = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExportEntitiesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.ExportEntitiesResponse} ExportEntitiesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportEntitiesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExportEntitiesResponse message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExportEntitiesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.outputUrl != null && message.hasOwnProperty("outputUrl"))
                                if (!$util.isString(message.outputUrl))
                                    return "outputUrl: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ExportEntitiesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.ExportEntitiesResponse} ExportEntitiesResponse
                         */
                        ExportEntitiesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.ExportEntitiesResponse)
                                return object;
                            var message = new $root.google.datastore.admin.v1.ExportEntitiesResponse();
                            if (object.outputUrl != null)
                                message.outputUrl = String(object.outputUrl);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExportEntitiesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @static
                         * @param {google.datastore.admin.v1.ExportEntitiesResponse} message ExportEntitiesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExportEntitiesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.outputUrl = "";
                            if (message.outputUrl != null && message.hasOwnProperty("outputUrl"))
                                object.outputUrl = message.outputUrl;
                            return object;
                        };
    
                        /**
                         * Converts this ExportEntitiesResponse to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.ExportEntitiesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExportEntitiesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ExportEntitiesResponse;
                    })();
    
                    v1.ExportEntitiesMetadata = (function() {
    
                        /**
                         * Properties of an ExportEntitiesMetadata.
                         * @memberof google.datastore.admin.v1
                         * @interface IExportEntitiesMetadata
                         * @property {google.datastore.admin.v1.ICommonMetadata|null} [common] ExportEntitiesMetadata common
                         * @property {google.datastore.admin.v1.IProgress|null} [progressEntities] ExportEntitiesMetadata progressEntities
                         * @property {google.datastore.admin.v1.IProgress|null} [progressBytes] ExportEntitiesMetadata progressBytes
                         * @property {google.datastore.admin.v1.IEntityFilter|null} [entityFilter] ExportEntitiesMetadata entityFilter
                         * @property {string|null} [outputUrlPrefix] ExportEntitiesMetadata outputUrlPrefix
                         */
    
                        /**
                         * Constructs a new ExportEntitiesMetadata.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an ExportEntitiesMetadata.
                         * @implements IExportEntitiesMetadata
                         * @constructor
                         * @param {google.datastore.admin.v1.IExportEntitiesMetadata=} [properties] Properties to set
                         */
                        function ExportEntitiesMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExportEntitiesMetadata common.
                         * @member {google.datastore.admin.v1.ICommonMetadata|null|undefined} common
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @instance
                         */
                        ExportEntitiesMetadata.prototype.common = null;
    
                        /**
                         * ExportEntitiesMetadata progressEntities.
                         * @member {google.datastore.admin.v1.IProgress|null|undefined} progressEntities
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @instance
                         */
                        ExportEntitiesMetadata.prototype.progressEntities = null;
    
                        /**
                         * ExportEntitiesMetadata progressBytes.
                         * @member {google.datastore.admin.v1.IProgress|null|undefined} progressBytes
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @instance
                         */
                        ExportEntitiesMetadata.prototype.progressBytes = null;
    
                        /**
                         * ExportEntitiesMetadata entityFilter.
                         * @member {google.datastore.admin.v1.IEntityFilter|null|undefined} entityFilter
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @instance
                         */
                        ExportEntitiesMetadata.prototype.entityFilter = null;
    
                        /**
                         * ExportEntitiesMetadata outputUrlPrefix.
                         * @member {string} outputUrlPrefix
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @instance
                         */
                        ExportEntitiesMetadata.prototype.outputUrlPrefix = "";
    
                        /**
                         * Creates a new ExportEntitiesMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesMetadata=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.ExportEntitiesMetadata} ExportEntitiesMetadata instance
                         */
                        ExportEntitiesMetadata.create = function create(properties) {
                            return new ExportEntitiesMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified ExportEntitiesMetadata message. Does not implicitly {@link google.datastore.admin.v1.ExportEntitiesMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesMetadata} message ExportEntitiesMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportEntitiesMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.common != null && Object.hasOwnProperty.call(message, "common"))
                                $root.google.datastore.admin.v1.CommonMetadata.encode(message.common, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.progressEntities != null && Object.hasOwnProperty.call(message, "progressEntities"))
                                $root.google.datastore.admin.v1.Progress.encode(message.progressEntities, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.progressBytes != null && Object.hasOwnProperty.call(message, "progressBytes"))
                                $root.google.datastore.admin.v1.Progress.encode(message.progressBytes, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.entityFilter != null && Object.hasOwnProperty.call(message, "entityFilter"))
                                $root.google.datastore.admin.v1.EntityFilter.encode(message.entityFilter, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.outputUrlPrefix != null && Object.hasOwnProperty.call(message, "outputUrlPrefix"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.outputUrlPrefix);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExportEntitiesMetadata message, length delimited. Does not implicitly {@link google.datastore.admin.v1.ExportEntitiesMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IExportEntitiesMetadata} message ExportEntitiesMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportEntitiesMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExportEntitiesMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.ExportEntitiesMetadata} ExportEntitiesMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportEntitiesMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.ExportEntitiesMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.common = $root.google.datastore.admin.v1.CommonMetadata.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.progressEntities = $root.google.datastore.admin.v1.Progress.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.progressBytes = $root.google.datastore.admin.v1.Progress.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.decode(reader, reader.uint32());
                                    break;
                                case 5:
                                    message.outputUrlPrefix = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExportEntitiesMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.ExportEntitiesMetadata} ExportEntitiesMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportEntitiesMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExportEntitiesMetadata message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExportEntitiesMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.common != null && message.hasOwnProperty("common")) {
                                var error = $root.google.datastore.admin.v1.CommonMetadata.verify(message.common);
                                if (error)
                                    return "common." + error;
                            }
                            if (message.progressEntities != null && message.hasOwnProperty("progressEntities")) {
                                var error = $root.google.datastore.admin.v1.Progress.verify(message.progressEntities);
                                if (error)
                                    return "progressEntities." + error;
                            }
                            if (message.progressBytes != null && message.hasOwnProperty("progressBytes")) {
                                var error = $root.google.datastore.admin.v1.Progress.verify(message.progressBytes);
                                if (error)
                                    return "progressBytes." + error;
                            }
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter")) {
                                var error = $root.google.datastore.admin.v1.EntityFilter.verify(message.entityFilter);
                                if (error)
                                    return "entityFilter." + error;
                            }
                            if (message.outputUrlPrefix != null && message.hasOwnProperty("outputUrlPrefix"))
                                if (!$util.isString(message.outputUrlPrefix))
                                    return "outputUrlPrefix: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ExportEntitiesMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.ExportEntitiesMetadata} ExportEntitiesMetadata
                         */
                        ExportEntitiesMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.ExportEntitiesMetadata)
                                return object;
                            var message = new $root.google.datastore.admin.v1.ExportEntitiesMetadata();
                            if (object.common != null) {
                                if (typeof object.common !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ExportEntitiesMetadata.common: object expected");
                                message.common = $root.google.datastore.admin.v1.CommonMetadata.fromObject(object.common);
                            }
                            if (object.progressEntities != null) {
                                if (typeof object.progressEntities !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ExportEntitiesMetadata.progressEntities: object expected");
                                message.progressEntities = $root.google.datastore.admin.v1.Progress.fromObject(object.progressEntities);
                            }
                            if (object.progressBytes != null) {
                                if (typeof object.progressBytes !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ExportEntitiesMetadata.progressBytes: object expected");
                                message.progressBytes = $root.google.datastore.admin.v1.Progress.fromObject(object.progressBytes);
                            }
                            if (object.entityFilter != null) {
                                if (typeof object.entityFilter !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ExportEntitiesMetadata.entityFilter: object expected");
                                message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.fromObject(object.entityFilter);
                            }
                            if (object.outputUrlPrefix != null)
                                message.outputUrlPrefix = String(object.outputUrlPrefix);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExportEntitiesMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.ExportEntitiesMetadata} message ExportEntitiesMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExportEntitiesMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.common = null;
                                object.progressEntities = null;
                                object.progressBytes = null;
                                object.entityFilter = null;
                                object.outputUrlPrefix = "";
                            }
                            if (message.common != null && message.hasOwnProperty("common"))
                                object.common = $root.google.datastore.admin.v1.CommonMetadata.toObject(message.common, options);
                            if (message.progressEntities != null && message.hasOwnProperty("progressEntities"))
                                object.progressEntities = $root.google.datastore.admin.v1.Progress.toObject(message.progressEntities, options);
                            if (message.progressBytes != null && message.hasOwnProperty("progressBytes"))
                                object.progressBytes = $root.google.datastore.admin.v1.Progress.toObject(message.progressBytes, options);
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter"))
                                object.entityFilter = $root.google.datastore.admin.v1.EntityFilter.toObject(message.entityFilter, options);
                            if (message.outputUrlPrefix != null && message.hasOwnProperty("outputUrlPrefix"))
                                object.outputUrlPrefix = message.outputUrlPrefix;
                            return object;
                        };
    
                        /**
                         * Converts this ExportEntitiesMetadata to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.ExportEntitiesMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExportEntitiesMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ExportEntitiesMetadata;
                    })();
    
                    v1.ImportEntitiesMetadata = (function() {
    
                        /**
                         * Properties of an ImportEntitiesMetadata.
                         * @memberof google.datastore.admin.v1
                         * @interface IImportEntitiesMetadata
                         * @property {google.datastore.admin.v1.ICommonMetadata|null} [common] ImportEntitiesMetadata common
                         * @property {google.datastore.admin.v1.IProgress|null} [progressEntities] ImportEntitiesMetadata progressEntities
                         * @property {google.datastore.admin.v1.IProgress|null} [progressBytes] ImportEntitiesMetadata progressBytes
                         * @property {google.datastore.admin.v1.IEntityFilter|null} [entityFilter] ImportEntitiesMetadata entityFilter
                         * @property {string|null} [inputUrl] ImportEntitiesMetadata inputUrl
                         */
    
                        /**
                         * Constructs a new ImportEntitiesMetadata.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an ImportEntitiesMetadata.
                         * @implements IImportEntitiesMetadata
                         * @constructor
                         * @param {google.datastore.admin.v1.IImportEntitiesMetadata=} [properties] Properties to set
                         */
                        function ImportEntitiesMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImportEntitiesMetadata common.
                         * @member {google.datastore.admin.v1.ICommonMetadata|null|undefined} common
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @instance
                         */
                        ImportEntitiesMetadata.prototype.common = null;
    
                        /**
                         * ImportEntitiesMetadata progressEntities.
                         * @member {google.datastore.admin.v1.IProgress|null|undefined} progressEntities
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @instance
                         */
                        ImportEntitiesMetadata.prototype.progressEntities = null;
    
                        /**
                         * ImportEntitiesMetadata progressBytes.
                         * @member {google.datastore.admin.v1.IProgress|null|undefined} progressBytes
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @instance
                         */
                        ImportEntitiesMetadata.prototype.progressBytes = null;
    
                        /**
                         * ImportEntitiesMetadata entityFilter.
                         * @member {google.datastore.admin.v1.IEntityFilter|null|undefined} entityFilter
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @instance
                         */
                        ImportEntitiesMetadata.prototype.entityFilter = null;
    
                        /**
                         * ImportEntitiesMetadata inputUrl.
                         * @member {string} inputUrl
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @instance
                         */
                        ImportEntitiesMetadata.prototype.inputUrl = "";
    
                        /**
                         * Creates a new ImportEntitiesMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IImportEntitiesMetadata=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.ImportEntitiesMetadata} ImportEntitiesMetadata instance
                         */
                        ImportEntitiesMetadata.create = function create(properties) {
                            return new ImportEntitiesMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified ImportEntitiesMetadata message. Does not implicitly {@link google.datastore.admin.v1.ImportEntitiesMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IImportEntitiesMetadata} message ImportEntitiesMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportEntitiesMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.common != null && Object.hasOwnProperty.call(message, "common"))
                                $root.google.datastore.admin.v1.CommonMetadata.encode(message.common, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.progressEntities != null && Object.hasOwnProperty.call(message, "progressEntities"))
                                $root.google.datastore.admin.v1.Progress.encode(message.progressEntities, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.progressBytes != null && Object.hasOwnProperty.call(message, "progressBytes"))
                                $root.google.datastore.admin.v1.Progress.encode(message.progressBytes, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.entityFilter != null && Object.hasOwnProperty.call(message, "entityFilter"))
                                $root.google.datastore.admin.v1.EntityFilter.encode(message.entityFilter, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.inputUrl != null && Object.hasOwnProperty.call(message, "inputUrl"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.inputUrl);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImportEntitiesMetadata message, length delimited. Does not implicitly {@link google.datastore.admin.v1.ImportEntitiesMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IImportEntitiesMetadata} message ImportEntitiesMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportEntitiesMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImportEntitiesMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.ImportEntitiesMetadata} ImportEntitiesMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportEntitiesMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.ImportEntitiesMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.common = $root.google.datastore.admin.v1.CommonMetadata.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.progressEntities = $root.google.datastore.admin.v1.Progress.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.progressBytes = $root.google.datastore.admin.v1.Progress.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.decode(reader, reader.uint32());
                                    break;
                                case 5:
                                    message.inputUrl = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImportEntitiesMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.ImportEntitiesMetadata} ImportEntitiesMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportEntitiesMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImportEntitiesMetadata message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImportEntitiesMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.common != null && message.hasOwnProperty("common")) {
                                var error = $root.google.datastore.admin.v1.CommonMetadata.verify(message.common);
                                if (error)
                                    return "common." + error;
                            }
                            if (message.progressEntities != null && message.hasOwnProperty("progressEntities")) {
                                var error = $root.google.datastore.admin.v1.Progress.verify(message.progressEntities);
                                if (error)
                                    return "progressEntities." + error;
                            }
                            if (message.progressBytes != null && message.hasOwnProperty("progressBytes")) {
                                var error = $root.google.datastore.admin.v1.Progress.verify(message.progressBytes);
                                if (error)
                                    return "progressBytes." + error;
                            }
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter")) {
                                var error = $root.google.datastore.admin.v1.EntityFilter.verify(message.entityFilter);
                                if (error)
                                    return "entityFilter." + error;
                            }
                            if (message.inputUrl != null && message.hasOwnProperty("inputUrl"))
                                if (!$util.isString(message.inputUrl))
                                    return "inputUrl: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ImportEntitiesMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.ImportEntitiesMetadata} ImportEntitiesMetadata
                         */
                        ImportEntitiesMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.ImportEntitiesMetadata)
                                return object;
                            var message = new $root.google.datastore.admin.v1.ImportEntitiesMetadata();
                            if (object.common != null) {
                                if (typeof object.common !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ImportEntitiesMetadata.common: object expected");
                                message.common = $root.google.datastore.admin.v1.CommonMetadata.fromObject(object.common);
                            }
                            if (object.progressEntities != null) {
                                if (typeof object.progressEntities !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ImportEntitiesMetadata.progressEntities: object expected");
                                message.progressEntities = $root.google.datastore.admin.v1.Progress.fromObject(object.progressEntities);
                            }
                            if (object.progressBytes != null) {
                                if (typeof object.progressBytes !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ImportEntitiesMetadata.progressBytes: object expected");
                                message.progressBytes = $root.google.datastore.admin.v1.Progress.fromObject(object.progressBytes);
                            }
                            if (object.entityFilter != null) {
                                if (typeof object.entityFilter !== "object")
                                    throw TypeError(".google.datastore.admin.v1.ImportEntitiesMetadata.entityFilter: object expected");
                                message.entityFilter = $root.google.datastore.admin.v1.EntityFilter.fromObject(object.entityFilter);
                            }
                            if (object.inputUrl != null)
                                message.inputUrl = String(object.inputUrl);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImportEntitiesMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @static
                         * @param {google.datastore.admin.v1.ImportEntitiesMetadata} message ImportEntitiesMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImportEntitiesMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.common = null;
                                object.progressEntities = null;
                                object.progressBytes = null;
                                object.entityFilter = null;
                                object.inputUrl = "";
                            }
                            if (message.common != null && message.hasOwnProperty("common"))
                                object.common = $root.google.datastore.admin.v1.CommonMetadata.toObject(message.common, options);
                            if (message.progressEntities != null && message.hasOwnProperty("progressEntities"))
                                object.progressEntities = $root.google.datastore.admin.v1.Progress.toObject(message.progressEntities, options);
                            if (message.progressBytes != null && message.hasOwnProperty("progressBytes"))
                                object.progressBytes = $root.google.datastore.admin.v1.Progress.toObject(message.progressBytes, options);
                            if (message.entityFilter != null && message.hasOwnProperty("entityFilter"))
                                object.entityFilter = $root.google.datastore.admin.v1.EntityFilter.toObject(message.entityFilter, options);
                            if (message.inputUrl != null && message.hasOwnProperty("inputUrl"))
                                object.inputUrl = message.inputUrl;
                            return object;
                        };
    
                        /**
                         * Converts this ImportEntitiesMetadata to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.ImportEntitiesMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImportEntitiesMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ImportEntitiesMetadata;
                    })();
    
                    v1.EntityFilter = (function() {
    
                        /**
                         * Properties of an EntityFilter.
                         * @memberof google.datastore.admin.v1
                         * @interface IEntityFilter
                         * @property {Array.<string>|null} [kinds] EntityFilter kinds
                         * @property {Array.<string>|null} [namespaceIds] EntityFilter namespaceIds
                         */
    
                        /**
                         * Constructs a new EntityFilter.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an EntityFilter.
                         * @implements IEntityFilter
                         * @constructor
                         * @param {google.datastore.admin.v1.IEntityFilter=} [properties] Properties to set
                         */
                        function EntityFilter(properties) {
                            this.kinds = [];
                            this.namespaceIds = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * EntityFilter kinds.
                         * @member {Array.<string>} kinds
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @instance
                         */
                        EntityFilter.prototype.kinds = $util.emptyArray;
    
                        /**
                         * EntityFilter namespaceIds.
                         * @member {Array.<string>} namespaceIds
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @instance
                         */
                        EntityFilter.prototype.namespaceIds = $util.emptyArray;
    
                        /**
                         * Creates a new EntityFilter instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {google.datastore.admin.v1.IEntityFilter=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.EntityFilter} EntityFilter instance
                         */
                        EntityFilter.create = function create(properties) {
                            return new EntityFilter(properties);
                        };
    
                        /**
                         * Encodes the specified EntityFilter message. Does not implicitly {@link google.datastore.admin.v1.EntityFilter.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {google.datastore.admin.v1.IEntityFilter} message EntityFilter message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EntityFilter.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.kinds != null && message.kinds.length)
                                for (var i = 0; i < message.kinds.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.kinds[i]);
                            if (message.namespaceIds != null && message.namespaceIds.length)
                                for (var i = 0; i < message.namespaceIds.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.namespaceIds[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified EntityFilter message, length delimited. Does not implicitly {@link google.datastore.admin.v1.EntityFilter.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {google.datastore.admin.v1.IEntityFilter} message EntityFilter message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EntityFilter.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an EntityFilter message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.EntityFilter} EntityFilter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EntityFilter.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.EntityFilter();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.kinds && message.kinds.length))
                                        message.kinds = [];
                                    message.kinds.push(reader.string());
                                    break;
                                case 2:
                                    if (!(message.namespaceIds && message.namespaceIds.length))
                                        message.namespaceIds = [];
                                    message.namespaceIds.push(reader.string());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an EntityFilter message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.EntityFilter} EntityFilter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EntityFilter.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an EntityFilter message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EntityFilter.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.kinds != null && message.hasOwnProperty("kinds")) {
                                if (!Array.isArray(message.kinds))
                                    return "kinds: array expected";
                                for (var i = 0; i < message.kinds.length; ++i)
                                    if (!$util.isString(message.kinds[i]))
                                        return "kinds: string[] expected";
                            }
                            if (message.namespaceIds != null && message.hasOwnProperty("namespaceIds")) {
                                if (!Array.isArray(message.namespaceIds))
                                    return "namespaceIds: array expected";
                                for (var i = 0; i < message.namespaceIds.length; ++i)
                                    if (!$util.isString(message.namespaceIds[i]))
                                        return "namespaceIds: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an EntityFilter message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.EntityFilter} EntityFilter
                         */
                        EntityFilter.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.EntityFilter)
                                return object;
                            var message = new $root.google.datastore.admin.v1.EntityFilter();
                            if (object.kinds) {
                                if (!Array.isArray(object.kinds))
                                    throw TypeError(".google.datastore.admin.v1.EntityFilter.kinds: array expected");
                                message.kinds = [];
                                for (var i = 0; i < object.kinds.length; ++i)
                                    message.kinds[i] = String(object.kinds[i]);
                            }
                            if (object.namespaceIds) {
                                if (!Array.isArray(object.namespaceIds))
                                    throw TypeError(".google.datastore.admin.v1.EntityFilter.namespaceIds: array expected");
                                message.namespaceIds = [];
                                for (var i = 0; i < object.namespaceIds.length; ++i)
                                    message.namespaceIds[i] = String(object.namespaceIds[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an EntityFilter message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @static
                         * @param {google.datastore.admin.v1.EntityFilter} message EntityFilter
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EntityFilter.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.kinds = [];
                                object.namespaceIds = [];
                            }
                            if (message.kinds && message.kinds.length) {
                                object.kinds = [];
                                for (var j = 0; j < message.kinds.length; ++j)
                                    object.kinds[j] = message.kinds[j];
                            }
                            if (message.namespaceIds && message.namespaceIds.length) {
                                object.namespaceIds = [];
                                for (var j = 0; j < message.namespaceIds.length; ++j)
                                    object.namespaceIds[j] = message.namespaceIds[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this EntityFilter to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.EntityFilter
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EntityFilter.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return EntityFilter;
                    })();
    
                    v1.GetIndexRequest = (function() {
    
                        /**
                         * Properties of a GetIndexRequest.
                         * @memberof google.datastore.admin.v1
                         * @interface IGetIndexRequest
                         * @property {string|null} [projectId] GetIndexRequest projectId
                         * @property {string|null} [indexId] GetIndexRequest indexId
                         */
    
                        /**
                         * Constructs a new GetIndexRequest.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents a GetIndexRequest.
                         * @implements IGetIndexRequest
                         * @constructor
                         * @param {google.datastore.admin.v1.IGetIndexRequest=} [properties] Properties to set
                         */
                        function GetIndexRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetIndexRequest projectId.
                         * @member {string} projectId
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @instance
                         */
                        GetIndexRequest.prototype.projectId = "";
    
                        /**
                         * GetIndexRequest indexId.
                         * @member {string} indexId
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @instance
                         */
                        GetIndexRequest.prototype.indexId = "";
    
                        /**
                         * Creates a new GetIndexRequest instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {google.datastore.admin.v1.IGetIndexRequest=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.GetIndexRequest} GetIndexRequest instance
                         */
                        GetIndexRequest.create = function create(properties) {
                            return new GetIndexRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetIndexRequest message. Does not implicitly {@link google.datastore.admin.v1.GetIndexRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {google.datastore.admin.v1.IGetIndexRequest} message GetIndexRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetIndexRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.projectId);
                            if (message.indexId != null && Object.hasOwnProperty.call(message, "indexId"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.indexId);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetIndexRequest message, length delimited. Does not implicitly {@link google.datastore.admin.v1.GetIndexRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {google.datastore.admin.v1.IGetIndexRequest} message GetIndexRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetIndexRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetIndexRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.GetIndexRequest} GetIndexRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetIndexRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.GetIndexRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.projectId = reader.string();
                                    break;
                                case 3:
                                    message.indexId = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetIndexRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.GetIndexRequest} GetIndexRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetIndexRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetIndexRequest message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetIndexRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                if (!$util.isString(message.projectId))
                                    return "projectId: string expected";
                            if (message.indexId != null && message.hasOwnProperty("indexId"))
                                if (!$util.isString(message.indexId))
                                    return "indexId: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetIndexRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.GetIndexRequest} GetIndexRequest
                         */
                        GetIndexRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.GetIndexRequest)
                                return object;
                            var message = new $root.google.datastore.admin.v1.GetIndexRequest();
                            if (object.projectId != null)
                                message.projectId = String(object.projectId);
                            if (object.indexId != null)
                                message.indexId = String(object.indexId);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetIndexRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @static
                         * @param {google.datastore.admin.v1.GetIndexRequest} message GetIndexRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetIndexRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.projectId = "";
                                object.indexId = "";
                            }
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                object.projectId = message.projectId;
                            if (message.indexId != null && message.hasOwnProperty("indexId"))
                                object.indexId = message.indexId;
                            return object;
                        };
    
                        /**
                         * Converts this GetIndexRequest to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.GetIndexRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetIndexRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return GetIndexRequest;
                    })();
    
                    v1.ListIndexesRequest = (function() {
    
                        /**
                         * Properties of a ListIndexesRequest.
                         * @memberof google.datastore.admin.v1
                         * @interface IListIndexesRequest
                         * @property {string|null} [projectId] ListIndexesRequest projectId
                         * @property {string|null} [filter] ListIndexesRequest filter
                         * @property {number|null} [pageSize] ListIndexesRequest pageSize
                         * @property {string|null} [pageToken] ListIndexesRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListIndexesRequest.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents a ListIndexesRequest.
                         * @implements IListIndexesRequest
                         * @constructor
                         * @param {google.datastore.admin.v1.IListIndexesRequest=} [properties] Properties to set
                         */
                        function ListIndexesRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListIndexesRequest projectId.
                         * @member {string} projectId
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @instance
                         */
                        ListIndexesRequest.prototype.projectId = "";
    
                        /**
                         * ListIndexesRequest filter.
                         * @member {string} filter
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @instance
                         */
                        ListIndexesRequest.prototype.filter = "";
    
                        /**
                         * ListIndexesRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @instance
                         */
                        ListIndexesRequest.prototype.pageSize = 0;
    
                        /**
                         * ListIndexesRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @instance
                         */
                        ListIndexesRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListIndexesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IListIndexesRequest=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.ListIndexesRequest} ListIndexesRequest instance
                         */
                        ListIndexesRequest.create = function create(properties) {
                            return new ListIndexesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListIndexesRequest message. Does not implicitly {@link google.datastore.admin.v1.ListIndexesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IListIndexesRequest} message ListIndexesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListIndexesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.projectId);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.filter);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListIndexesRequest message, length delimited. Does not implicitly {@link google.datastore.admin.v1.ListIndexesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {google.datastore.admin.v1.IListIndexesRequest} message ListIndexesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListIndexesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListIndexesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.ListIndexesRequest} ListIndexesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListIndexesRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.ListIndexesRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.projectId = reader.string();
                                    break;
                                case 3:
                                    message.filter = reader.string();
                                    break;
                                case 4:
                                    message.pageSize = reader.int32();
                                    break;
                                case 5:
                                    message.pageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListIndexesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.ListIndexesRequest} ListIndexesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListIndexesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListIndexesRequest message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListIndexesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                if (!$util.isString(message.projectId))
                                    return "projectId: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListIndexesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.ListIndexesRequest} ListIndexesRequest
                         */
                        ListIndexesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.ListIndexesRequest)
                                return object;
                            var message = new $root.google.datastore.admin.v1.ListIndexesRequest();
                            if (object.projectId != null)
                                message.projectId = String(object.projectId);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListIndexesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @static
                         * @param {google.datastore.admin.v1.ListIndexesRequest} message ListIndexesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListIndexesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.projectId = "";
                                object.filter = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                object.projectId = message.projectId;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListIndexesRequest to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.ListIndexesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListIndexesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ListIndexesRequest;
                    })();
    
                    v1.ListIndexesResponse = (function() {
    
                        /**
                         * Properties of a ListIndexesResponse.
                         * @memberof google.datastore.admin.v1
                         * @interface IListIndexesResponse
                         * @property {Array.<google.datastore.admin.v1.IIndex>|null} [indexes] ListIndexesResponse indexes
                         * @property {string|null} [nextPageToken] ListIndexesResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListIndexesResponse.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents a ListIndexesResponse.
                         * @implements IListIndexesResponse
                         * @constructor
                         * @param {google.datastore.admin.v1.IListIndexesResponse=} [properties] Properties to set
                         */
                        function ListIndexesResponse(properties) {
                            this.indexes = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListIndexesResponse indexes.
                         * @member {Array.<google.datastore.admin.v1.IIndex>} indexes
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @instance
                         */
                        ListIndexesResponse.prototype.indexes = $util.emptyArray;
    
                        /**
                         * ListIndexesResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @instance
                         */
                        ListIndexesResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListIndexesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {google.datastore.admin.v1.IListIndexesResponse=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.ListIndexesResponse} ListIndexesResponse instance
                         */
                        ListIndexesResponse.create = function create(properties) {
                            return new ListIndexesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListIndexesResponse message. Does not implicitly {@link google.datastore.admin.v1.ListIndexesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {google.datastore.admin.v1.IListIndexesResponse} message ListIndexesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListIndexesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.indexes != null && message.indexes.length)
                                for (var i = 0; i < message.indexes.length; ++i)
                                    $root.google.datastore.admin.v1.Index.encode(message.indexes[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListIndexesResponse message, length delimited. Does not implicitly {@link google.datastore.admin.v1.ListIndexesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {google.datastore.admin.v1.IListIndexesResponse} message ListIndexesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListIndexesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListIndexesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.ListIndexesResponse} ListIndexesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListIndexesResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.ListIndexesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.indexes && message.indexes.length))
                                        message.indexes = [];
                                    message.indexes.push($root.google.datastore.admin.v1.Index.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.nextPageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListIndexesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.ListIndexesResponse} ListIndexesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListIndexesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListIndexesResponse message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListIndexesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.indexes != null && message.hasOwnProperty("indexes")) {
                                if (!Array.isArray(message.indexes))
                                    return "indexes: array expected";
                                for (var i = 0; i < message.indexes.length; ++i) {
                                    var error = $root.google.datastore.admin.v1.Index.verify(message.indexes[i]);
                                    if (error)
                                        return "indexes." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListIndexesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.ListIndexesResponse} ListIndexesResponse
                         */
                        ListIndexesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.ListIndexesResponse)
                                return object;
                            var message = new $root.google.datastore.admin.v1.ListIndexesResponse();
                            if (object.indexes) {
                                if (!Array.isArray(object.indexes))
                                    throw TypeError(".google.datastore.admin.v1.ListIndexesResponse.indexes: array expected");
                                message.indexes = [];
                                for (var i = 0; i < object.indexes.length; ++i) {
                                    if (typeof object.indexes[i] !== "object")
                                        throw TypeError(".google.datastore.admin.v1.ListIndexesResponse.indexes: object expected");
                                    message.indexes[i] = $root.google.datastore.admin.v1.Index.fromObject(object.indexes[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListIndexesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @static
                         * @param {google.datastore.admin.v1.ListIndexesResponse} message ListIndexesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListIndexesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.indexes = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.indexes && message.indexes.length) {
                                object.indexes = [];
                                for (var j = 0; j < message.indexes.length; ++j)
                                    object.indexes[j] = $root.google.datastore.admin.v1.Index.toObject(message.indexes[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListIndexesResponse to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.ListIndexesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListIndexesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ListIndexesResponse;
                    })();
    
                    v1.IndexOperationMetadata = (function() {
    
                        /**
                         * Properties of an IndexOperationMetadata.
                         * @memberof google.datastore.admin.v1
                         * @interface IIndexOperationMetadata
                         * @property {google.datastore.admin.v1.ICommonMetadata|null} [common] IndexOperationMetadata common
                         * @property {google.datastore.admin.v1.IProgress|null} [progressEntities] IndexOperationMetadata progressEntities
                         * @property {string|null} [indexId] IndexOperationMetadata indexId
                         */
    
                        /**
                         * Constructs a new IndexOperationMetadata.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an IndexOperationMetadata.
                         * @implements IIndexOperationMetadata
                         * @constructor
                         * @param {google.datastore.admin.v1.IIndexOperationMetadata=} [properties] Properties to set
                         */
                        function IndexOperationMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * IndexOperationMetadata common.
                         * @member {google.datastore.admin.v1.ICommonMetadata|null|undefined} common
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @instance
                         */
                        IndexOperationMetadata.prototype.common = null;
    
                        /**
                         * IndexOperationMetadata progressEntities.
                         * @member {google.datastore.admin.v1.IProgress|null|undefined} progressEntities
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @instance
                         */
                        IndexOperationMetadata.prototype.progressEntities = null;
    
                        /**
                         * IndexOperationMetadata indexId.
                         * @member {string} indexId
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @instance
                         */
                        IndexOperationMetadata.prototype.indexId = "";
    
                        /**
                         * Creates a new IndexOperationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IIndexOperationMetadata=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.IndexOperationMetadata} IndexOperationMetadata instance
                         */
                        IndexOperationMetadata.create = function create(properties) {
                            return new IndexOperationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified IndexOperationMetadata message. Does not implicitly {@link google.datastore.admin.v1.IndexOperationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IIndexOperationMetadata} message IndexOperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IndexOperationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.common != null && Object.hasOwnProperty.call(message, "common"))
                                $root.google.datastore.admin.v1.CommonMetadata.encode(message.common, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.progressEntities != null && Object.hasOwnProperty.call(message, "progressEntities"))
                                $root.google.datastore.admin.v1.Progress.encode(message.progressEntities, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.indexId != null && Object.hasOwnProperty.call(message, "indexId"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.indexId);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified IndexOperationMetadata message, length delimited. Does not implicitly {@link google.datastore.admin.v1.IndexOperationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IIndexOperationMetadata} message IndexOperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IndexOperationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an IndexOperationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.IndexOperationMetadata} IndexOperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IndexOperationMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.IndexOperationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.common = $root.google.datastore.admin.v1.CommonMetadata.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.progressEntities = $root.google.datastore.admin.v1.Progress.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.indexId = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an IndexOperationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.IndexOperationMetadata} IndexOperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IndexOperationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an IndexOperationMetadata message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        IndexOperationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.common != null && message.hasOwnProperty("common")) {
                                var error = $root.google.datastore.admin.v1.CommonMetadata.verify(message.common);
                                if (error)
                                    return "common." + error;
                            }
                            if (message.progressEntities != null && message.hasOwnProperty("progressEntities")) {
                                var error = $root.google.datastore.admin.v1.Progress.verify(message.progressEntities);
                                if (error)
                                    return "progressEntities." + error;
                            }
                            if (message.indexId != null && message.hasOwnProperty("indexId"))
                                if (!$util.isString(message.indexId))
                                    return "indexId: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an IndexOperationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.IndexOperationMetadata} IndexOperationMetadata
                         */
                        IndexOperationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.IndexOperationMetadata)
                                return object;
                            var message = new $root.google.datastore.admin.v1.IndexOperationMetadata();
                            if (object.common != null) {
                                if (typeof object.common !== "object")
                                    throw TypeError(".google.datastore.admin.v1.IndexOperationMetadata.common: object expected");
                                message.common = $root.google.datastore.admin.v1.CommonMetadata.fromObject(object.common);
                            }
                            if (object.progressEntities != null) {
                                if (typeof object.progressEntities !== "object")
                                    throw TypeError(".google.datastore.admin.v1.IndexOperationMetadata.progressEntities: object expected");
                                message.progressEntities = $root.google.datastore.admin.v1.Progress.fromObject(object.progressEntities);
                            }
                            if (object.indexId != null)
                                message.indexId = String(object.indexId);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an IndexOperationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @static
                         * @param {google.datastore.admin.v1.IndexOperationMetadata} message IndexOperationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        IndexOperationMetadata.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.common = null;
                                object.progressEntities = null;
                                object.indexId = "";
                            }
                            if (message.common != null && message.hasOwnProperty("common"))
                                object.common = $root.google.datastore.admin.v1.CommonMetadata.toObject(message.common, options);
                            if (message.progressEntities != null && message.hasOwnProperty("progressEntities"))
                                object.progressEntities = $root.google.datastore.admin.v1.Progress.toObject(message.progressEntities, options);
                            if (message.indexId != null && message.hasOwnProperty("indexId"))
                                object.indexId = message.indexId;
                            return object;
                        };
    
                        /**
                         * Converts this IndexOperationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.IndexOperationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        IndexOperationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return IndexOperationMetadata;
                    })();
    
                    v1.Index = (function() {
    
                        /**
                         * Properties of an Index.
                         * @memberof google.datastore.admin.v1
                         * @interface IIndex
                         * @property {string|null} [projectId] Index projectId
                         * @property {string|null} [indexId] Index indexId
                         * @property {string|null} [kind] Index kind
                         * @property {google.datastore.admin.v1.Index.AncestorMode|null} [ancestor] Index ancestor
                         * @property {Array.<google.datastore.admin.v1.Index.IIndexedProperty>|null} [properties] Index properties
                         * @property {google.datastore.admin.v1.Index.State|null} [state] Index state
                         */
    
                        /**
                         * Constructs a new Index.
                         * @memberof google.datastore.admin.v1
                         * @classdesc Represents an Index.
                         * @implements IIndex
                         * @constructor
                         * @param {google.datastore.admin.v1.IIndex=} [properties] Properties to set
                         */
                        function Index(properties) {
                            this.properties = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Index projectId.
                         * @member {string} projectId
                         * @memberof google.datastore.admin.v1.Index
                         * @instance
                         */
                        Index.prototype.projectId = "";
    
                        /**
                         * Index indexId.
                         * @member {string} indexId
                         * @memberof google.datastore.admin.v1.Index
                         * @instance
                         */
                        Index.prototype.indexId = "";
    
                        /**
                         * Index kind.
                         * @member {string} kind
                         * @memberof google.datastore.admin.v1.Index
                         * @instance
                         */
                        Index.prototype.kind = "";
    
                        /**
                         * Index ancestor.
                         * @member {google.datastore.admin.v1.Index.AncestorMode} ancestor
                         * @memberof google.datastore.admin.v1.Index
                         * @instance
                         */
                        Index.prototype.ancestor = 0;
    
                        /**
                         * Index properties.
                         * @member {Array.<google.datastore.admin.v1.Index.IIndexedProperty>} properties
                         * @memberof google.datastore.admin.v1.Index
                         * @instance
                         */
                        Index.prototype.properties = $util.emptyArray;
    
                        /**
                         * Index state.
                         * @member {google.datastore.admin.v1.Index.State} state
                         * @memberof google.datastore.admin.v1.Index
                         * @instance
                         */
                        Index.prototype.state = 0;
    
                        /**
                         * Creates a new Index instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {google.datastore.admin.v1.IIndex=} [properties] Properties to set
                         * @returns {google.datastore.admin.v1.Index} Index instance
                         */
                        Index.create = function create(properties) {
                            return new Index(properties);
                        };
    
                        /**
                         * Encodes the specified Index message. Does not implicitly {@link google.datastore.admin.v1.Index.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {google.datastore.admin.v1.IIndex} message Index message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Index.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.projectId);
                            if (message.indexId != null && Object.hasOwnProperty.call(message, "indexId"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.indexId);
                            if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.kind);
                            if (message.ancestor != null && Object.hasOwnProperty.call(message, "ancestor"))
                                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.ancestor);
                            if (message.properties != null && message.properties.length)
                                for (var i = 0; i < message.properties.length; ++i)
                                    $root.google.datastore.admin.v1.Index.IndexedProperty.encode(message.properties[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.state);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Index message, length delimited. Does not implicitly {@link google.datastore.admin.v1.Index.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {google.datastore.admin.v1.IIndex} message Index message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Index.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an Index message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.admin.v1.Index} Index
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Index.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.Index();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.projectId = reader.string();
                                    break;
                                case 3:
                                    message.indexId = reader.string();
                                    break;
                                case 4:
                                    message.kind = reader.string();
                                    break;
                                case 5:
                                    message.ancestor = reader.int32();
                                    break;
                                case 6:
                                    if (!(message.properties && message.properties.length))
                                        message.properties = [];
                                    message.properties.push($root.google.datastore.admin.v1.Index.IndexedProperty.decode(reader, reader.uint32()));
                                    break;
                                case 7:
                                    message.state = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an Index message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.admin.v1.Index} Index
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Index.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an Index message.
                         * @function verify
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Index.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                if (!$util.isString(message.projectId))
                                    return "projectId: string expected";
                            if (message.indexId != null && message.hasOwnProperty("indexId"))
                                if (!$util.isString(message.indexId))
                                    return "indexId: string expected";
                            if (message.kind != null && message.hasOwnProperty("kind"))
                                if (!$util.isString(message.kind))
                                    return "kind: string expected";
                            if (message.ancestor != null && message.hasOwnProperty("ancestor"))
                                switch (message.ancestor) {
                                default:
                                    return "ancestor: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.properties != null && message.hasOwnProperty("properties")) {
                                if (!Array.isArray(message.properties))
                                    return "properties: array expected";
                                for (var i = 0; i < message.properties.length; ++i) {
                                    var error = $root.google.datastore.admin.v1.Index.IndexedProperty.verify(message.properties[i]);
                                    if (error)
                                        return "properties." + error;
                                }
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates an Index message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.admin.v1.Index} Index
                         */
                        Index.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.admin.v1.Index)
                                return object;
                            var message = new $root.google.datastore.admin.v1.Index();
                            if (object.projectId != null)
                                message.projectId = String(object.projectId);
                            if (object.indexId != null)
                                message.indexId = String(object.indexId);
                            if (object.kind != null)
                                message.kind = String(object.kind);
                            switch (object.ancestor) {
                            case "ANCESTOR_MODE_UNSPECIFIED":
                            case 0:
                                message.ancestor = 0;
                                break;
                            case "NONE":
                            case 1:
                                message.ancestor = 1;
                                break;
                            case "ALL_ANCESTORS":
                            case 2:
                                message.ancestor = 2;
                                break;
                            }
                            if (object.properties) {
                                if (!Array.isArray(object.properties))
                                    throw TypeError(".google.datastore.admin.v1.Index.properties: array expected");
                                message.properties = [];
                                for (var i = 0; i < object.properties.length; ++i) {
                                    if (typeof object.properties[i] !== "object")
                                        throw TypeError(".google.datastore.admin.v1.Index.properties: object expected");
                                    message.properties[i] = $root.google.datastore.admin.v1.Index.IndexedProperty.fromObject(object.properties[i]);
                                }
                            }
                            switch (object.state) {
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "CREATING":
                            case 1:
                                message.state = 1;
                                break;
                            case "READY":
                            case 2:
                                message.state = 2;
                                break;
                            case "DELETING":
                            case 3:
                                message.state = 3;
                                break;
                            case "ERROR":
                            case 4:
                                message.state = 4;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an Index message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.admin.v1.Index
                         * @static
                         * @param {google.datastore.admin.v1.Index} message Index
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Index.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.properties = [];
                            if (options.defaults) {
                                object.projectId = "";
                                object.indexId = "";
                                object.kind = "";
                                object.ancestor = options.enums === String ? "ANCESTOR_MODE_UNSPECIFIED" : 0;
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                            }
                            if (message.projectId != null && message.hasOwnProperty("projectId"))
                                object.projectId = message.projectId;
                            if (message.indexId != null && message.hasOwnProperty("indexId"))
                                object.indexId = message.indexId;
                            if (message.kind != null && message.hasOwnProperty("kind"))
                                object.kind = message.kind;
                            if (message.ancestor != null && message.hasOwnProperty("ancestor"))
                                object.ancestor = options.enums === String ? $root.google.datastore.admin.v1.Index.AncestorMode[message.ancestor] : message.ancestor;
                            if (message.properties && message.properties.length) {
                                object.properties = [];
                                for (var j = 0; j < message.properties.length; ++j)
                                    object.properties[j] = $root.google.datastore.admin.v1.Index.IndexedProperty.toObject(message.properties[j], options);
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.datastore.admin.v1.Index.State[message.state] : message.state;
                            return object;
                        };
    
                        /**
                         * Converts this Index to JSON.
                         * @function toJSON
                         * @memberof google.datastore.admin.v1.Index
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Index.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        Index.IndexedProperty = (function() {
    
                            /**
                             * Properties of an IndexedProperty.
                             * @memberof google.datastore.admin.v1.Index
                             * @interface IIndexedProperty
                             * @property {string|null} [name] IndexedProperty name
                             * @property {google.datastore.admin.v1.Index.Direction|null} [direction] IndexedProperty direction
                             */
    
                            /**
                             * Constructs a new IndexedProperty.
                             * @memberof google.datastore.admin.v1.Index
                             * @classdesc Represents an IndexedProperty.
                             * @implements IIndexedProperty
                             * @constructor
                             * @param {google.datastore.admin.v1.Index.IIndexedProperty=} [properties] Properties to set
                             */
                            function IndexedProperty(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * IndexedProperty name.
                             * @member {string} name
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @instance
                             */
                            IndexedProperty.prototype.name = "";
    
                            /**
                             * IndexedProperty direction.
                             * @member {google.datastore.admin.v1.Index.Direction} direction
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @instance
                             */
                            IndexedProperty.prototype.direction = 0;
    
                            /**
                             * Creates a new IndexedProperty instance using the specified properties.
                             * @function create
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {google.datastore.admin.v1.Index.IIndexedProperty=} [properties] Properties to set
                             * @returns {google.datastore.admin.v1.Index.IndexedProperty} IndexedProperty instance
                             */
                            IndexedProperty.create = function create(properties) {
                                return new IndexedProperty(properties);
                            };
    
                            /**
                             * Encodes the specified IndexedProperty message. Does not implicitly {@link google.datastore.admin.v1.Index.IndexedProperty.verify|verify} messages.
                             * @function encode
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {google.datastore.admin.v1.Index.IIndexedProperty} message IndexedProperty message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IndexedProperty.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                                if (message.direction != null && Object.hasOwnProperty.call(message, "direction"))
                                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.direction);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified IndexedProperty message, length delimited. Does not implicitly {@link google.datastore.admin.v1.Index.IndexedProperty.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {google.datastore.admin.v1.Index.IIndexedProperty} message IndexedProperty message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IndexedProperty.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an IndexedProperty message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.datastore.admin.v1.Index.IndexedProperty} IndexedProperty
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IndexedProperty.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.admin.v1.Index.IndexedProperty();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1:
                                        message.name = reader.string();
                                        break;
                                    case 2:
                                        message.direction = reader.int32();
                                        break;
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an IndexedProperty message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.datastore.admin.v1.Index.IndexedProperty} IndexedProperty
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IndexedProperty.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an IndexedProperty message.
                             * @function verify
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            IndexedProperty.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.name != null && message.hasOwnProperty("name"))
                                    if (!$util.isString(message.name))
                                        return "name: string expected";
                                if (message.direction != null && message.hasOwnProperty("direction"))
                                    switch (message.direction) {
                                    default:
                                        return "direction: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                        break;
                                    }
                                return null;
                            };
    
                            /**
                             * Creates an IndexedProperty message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.datastore.admin.v1.Index.IndexedProperty} IndexedProperty
                             */
                            IndexedProperty.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.datastore.admin.v1.Index.IndexedProperty)
                                    return object;
                                var message = new $root.google.datastore.admin.v1.Index.IndexedProperty();
                                if (object.name != null)
                                    message.name = String(object.name);
                                switch (object.direction) {
                                case "DIRECTION_UNSPECIFIED":
                                case 0:
                                    message.direction = 0;
                                    break;
                                case "ASCENDING":
                                case 1:
                                    message.direction = 1;
                                    break;
                                case "DESCENDING":
                                case 2:
                                    message.direction = 2;
                                    break;
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an IndexedProperty message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @static
                             * @param {google.datastore.admin.v1.Index.IndexedProperty} message IndexedProperty
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            IndexedProperty.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.name = "";
                                    object.direction = options.enums === String ? "DIRECTION_UNSPECIFIED" : 0;
                                }
                                if (message.name != null && message.hasOwnProperty("name"))
                                    object.name = message.name;
                                if (message.direction != null && message.hasOwnProperty("direction"))
                                    object.direction = options.enums === String ? $root.google.datastore.admin.v1.Index.Direction[message.direction] : message.direction;
                                return object;
                            };
    
                            /**
                             * Converts this IndexedProperty to JSON.
                             * @function toJSON
                             * @memberof google.datastore.admin.v1.Index.IndexedProperty
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            IndexedProperty.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            return IndexedProperty;
                        })();
    
                        /**
                         * AncestorMode enum.
                         * @name google.datastore.admin.v1.Index.AncestorMode
                         * @enum {number}
                         * @property {number} ANCESTOR_MODE_UNSPECIFIED=0 ANCESTOR_MODE_UNSPECIFIED value
                         * @property {number} NONE=1 NONE value
                         * @property {number} ALL_ANCESTORS=2 ALL_ANCESTORS value
                         */
                        Index.AncestorMode = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "ANCESTOR_MODE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "NONE"] = 1;
                            values[valuesById[2] = "ALL_ANCESTORS"] = 2;
                            return values;
                        })();
    
                        /**
                         * Direction enum.
                         * @name google.datastore.admin.v1.Index.Direction
                         * @enum {number}
                         * @property {number} DIRECTION_UNSPECIFIED=0 DIRECTION_UNSPECIFIED value
                         * @property {number} ASCENDING=1 ASCENDING value
                         * @property {number} DESCENDING=2 DESCENDING value
                         */
                        Index.Direction = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "DIRECTION_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ASCENDING"] = 1;
                            values[valuesById[2] = "DESCENDING"] = 2;
                            return values;
                        })();
    
                        /**
                         * State enum.
                         * @name google.datastore.admin.v1.Index.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} CREATING=1 CREATING value
                         * @property {number} READY=2 READY value
                         * @property {number} DELETING=3 DELETING value
                         * @property {number} ERROR=4 ERROR value
                         */
                        Index.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "CREATING"] = 1;
                            values[valuesById[2] = "READY"] = 2;
                            values[valuesById[3] = "DELETING"] = 3;
                            values[valuesById[4] = "ERROR"] = 4;
                            return values;
                        })();
    
                        return Index;
                    })();
    
                    return v1;
                })();
    
                return admin;
            })();
    
            datastore.v1 = (function() {
    
                /**
                 * Namespace v1.
                 * @memberof google.datastore
                 * @namespace
                 */
                var v1 = {};
    
                v1.Datastore = (function() {
    
                    /**
                     * Constructs a new Datastore service.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a Datastore
                     * @extends $protobuf.rpc.Service
                     * @constructor
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     */
                    function Datastore(rpcImpl, requestDelimited, responseDelimited) {
                        $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                    }
    
                    (Datastore.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Datastore;
    
                    /**
                     * Creates new Datastore service using the specified rpc implementation.
                     * @function create
                     * @memberof google.datastore.v1.Datastore
                     * @static
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     * @returns {Datastore} RPC service. Useful where requests and/or responses are streamed.
                     */
                    Datastore.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                        return new this(rpcImpl, requestDelimited, responseDelimited);
                    };
    
                    /**
                     * Callback as used by {@link google.datastore.v1.Datastore#lookup}.
                     * @memberof google.datastore.v1.Datastore
                     * @typedef LookupCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.datastore.v1.LookupResponse} [response] LookupResponse
                     */
    
                    /**
                     * Calls Lookup.
                     * @function lookup
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.ILookupRequest} request LookupRequest message or plain object
                     * @param {google.datastore.v1.Datastore.LookupCallback} callback Node-style callback called with the error, if any, and LookupResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Datastore.prototype.lookup = function lookup(request, callback) {
                        return this.rpcCall(lookup, $root.google.datastore.v1.LookupRequest, $root.google.datastore.v1.LookupResponse, request, callback);
                    }, "name", { value: "Lookup" });
    
                    /**
                     * Calls Lookup.
                     * @function lookup
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.ILookupRequest} request LookupRequest message or plain object
                     * @returns {Promise<google.datastore.v1.LookupResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.datastore.v1.Datastore#runQuery}.
                     * @memberof google.datastore.v1.Datastore
                     * @typedef RunQueryCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.datastore.v1.RunQueryResponse} [response] RunQueryResponse
                     */
    
                    /**
                     * Calls RunQuery.
                     * @function runQuery
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IRunQueryRequest} request RunQueryRequest message or plain object
                     * @param {google.datastore.v1.Datastore.RunQueryCallback} callback Node-style callback called with the error, if any, and RunQueryResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Datastore.prototype.runQuery = function runQuery(request, callback) {
                        return this.rpcCall(runQuery, $root.google.datastore.v1.RunQueryRequest, $root.google.datastore.v1.RunQueryResponse, request, callback);
                    }, "name", { value: "RunQuery" });
    
                    /**
                     * Calls RunQuery.
                     * @function runQuery
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IRunQueryRequest} request RunQueryRequest message or plain object
                     * @returns {Promise<google.datastore.v1.RunQueryResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.datastore.v1.Datastore#beginTransaction}.
                     * @memberof google.datastore.v1.Datastore
                     * @typedef BeginTransactionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.datastore.v1.BeginTransactionResponse} [response] BeginTransactionResponse
                     */
    
                    /**
                     * Calls BeginTransaction.
                     * @function beginTransaction
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IBeginTransactionRequest} request BeginTransactionRequest message or plain object
                     * @param {google.datastore.v1.Datastore.BeginTransactionCallback} callback Node-style callback called with the error, if any, and BeginTransactionResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Datastore.prototype.beginTransaction = function beginTransaction(request, callback) {
                        return this.rpcCall(beginTransaction, $root.google.datastore.v1.BeginTransactionRequest, $root.google.datastore.v1.BeginTransactionResponse, request, callback);
                    }, "name", { value: "BeginTransaction" });
    
                    /**
                     * Calls BeginTransaction.
                     * @function beginTransaction
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IBeginTransactionRequest} request BeginTransactionRequest message or plain object
                     * @returns {Promise<google.datastore.v1.BeginTransactionResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.datastore.v1.Datastore#commit}.
                     * @memberof google.datastore.v1.Datastore
                     * @typedef CommitCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.datastore.v1.CommitResponse} [response] CommitResponse
                     */
    
                    /**
                     * Calls Commit.
                     * @function commit
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.ICommitRequest} request CommitRequest message or plain object
                     * @param {google.datastore.v1.Datastore.CommitCallback} callback Node-style callback called with the error, if any, and CommitResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Datastore.prototype.commit = function commit(request, callback) {
                        return this.rpcCall(commit, $root.google.datastore.v1.CommitRequest, $root.google.datastore.v1.CommitResponse, request, callback);
                    }, "name", { value: "Commit" });
    
                    /**
                     * Calls Commit.
                     * @function commit
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.ICommitRequest} request CommitRequest message or plain object
                     * @returns {Promise<google.datastore.v1.CommitResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.datastore.v1.Datastore#rollback}.
                     * @memberof google.datastore.v1.Datastore
                     * @typedef RollbackCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.datastore.v1.RollbackResponse} [response] RollbackResponse
                     */
    
                    /**
                     * Calls Rollback.
                     * @function rollback
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IRollbackRequest} request RollbackRequest message or plain object
                     * @param {google.datastore.v1.Datastore.RollbackCallback} callback Node-style callback called with the error, if any, and RollbackResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Datastore.prototype.rollback = function rollback(request, callback) {
                        return this.rpcCall(rollback, $root.google.datastore.v1.RollbackRequest, $root.google.datastore.v1.RollbackResponse, request, callback);
                    }, "name", { value: "Rollback" });
    
                    /**
                     * Calls Rollback.
                     * @function rollback
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IRollbackRequest} request RollbackRequest message or plain object
                     * @returns {Promise<google.datastore.v1.RollbackResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.datastore.v1.Datastore#allocateIds}.
                     * @memberof google.datastore.v1.Datastore
                     * @typedef AllocateIdsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.datastore.v1.AllocateIdsResponse} [response] AllocateIdsResponse
                     */
    
                    /**
                     * Calls AllocateIds.
                     * @function allocateIds
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IAllocateIdsRequest} request AllocateIdsRequest message or plain object
                     * @param {google.datastore.v1.Datastore.AllocateIdsCallback} callback Node-style callback called with the error, if any, and AllocateIdsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Datastore.prototype.allocateIds = function allocateIds(request, callback) {
                        return this.rpcCall(allocateIds, $root.google.datastore.v1.AllocateIdsRequest, $root.google.datastore.v1.AllocateIdsResponse, request, callback);
                    }, "name", { value: "AllocateIds" });
    
                    /**
                     * Calls AllocateIds.
                     * @function allocateIds
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IAllocateIdsRequest} request AllocateIdsRequest message or plain object
                     * @returns {Promise<google.datastore.v1.AllocateIdsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.datastore.v1.Datastore#reserveIds}.
                     * @memberof google.datastore.v1.Datastore
                     * @typedef ReserveIdsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.datastore.v1.ReserveIdsResponse} [response] ReserveIdsResponse
                     */
    
                    /**
                     * Calls ReserveIds.
                     * @function reserveIds
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IReserveIdsRequest} request ReserveIdsRequest message or plain object
                     * @param {google.datastore.v1.Datastore.ReserveIdsCallback} callback Node-style callback called with the error, if any, and ReserveIdsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Datastore.prototype.reserveIds = function reserveIds(request, callback) {
                        return this.rpcCall(reserveIds, $root.google.datastore.v1.ReserveIdsRequest, $root.google.datastore.v1.ReserveIdsResponse, request, callback);
                    }, "name", { value: "ReserveIds" });
    
                    /**
                     * Calls ReserveIds.
                     * @function reserveIds
                     * @memberof google.datastore.v1.Datastore
                     * @instance
                     * @param {google.datastore.v1.IReserveIdsRequest} request ReserveIdsRequest message or plain object
                     * @returns {Promise<google.datastore.v1.ReserveIdsResponse>} Promise
                     * @variation 2
                     */
    
                    return Datastore;
                })();
    
                v1.LookupRequest = (function() {
    
                    /**
                     * Properties of a LookupRequest.
                     * @memberof google.datastore.v1
                     * @interface ILookupRequest
                     * @property {string|null} [projectId] LookupRequest projectId
                     * @property {google.datastore.v1.IReadOptions|null} [readOptions] LookupRequest readOptions
                     * @property {Array.<google.datastore.v1.IKey>|null} [keys] LookupRequest keys
                     */
    
                    /**
                     * Constructs a new LookupRequest.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a LookupRequest.
                     * @implements ILookupRequest
                     * @constructor
                     * @param {google.datastore.v1.ILookupRequest=} [properties] Properties to set
                     */
                    function LookupRequest(properties) {
                        this.keys = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * LookupRequest projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.LookupRequest
                     * @instance
                     */
                    LookupRequest.prototype.projectId = "";
    
                    /**
                     * LookupRequest readOptions.
                     * @member {google.datastore.v1.IReadOptions|null|undefined} readOptions
                     * @memberof google.datastore.v1.LookupRequest
                     * @instance
                     */
                    LookupRequest.prototype.readOptions = null;
    
                    /**
                     * LookupRequest keys.
                     * @member {Array.<google.datastore.v1.IKey>} keys
                     * @memberof google.datastore.v1.LookupRequest
                     * @instance
                     */
                    LookupRequest.prototype.keys = $util.emptyArray;
    
                    /**
                     * Creates a new LookupRequest instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {google.datastore.v1.ILookupRequest=} [properties] Properties to set
                     * @returns {google.datastore.v1.LookupRequest} LookupRequest instance
                     */
                    LookupRequest.create = function create(properties) {
                        return new LookupRequest(properties);
                    };
    
                    /**
                     * Encodes the specified LookupRequest message. Does not implicitly {@link google.datastore.v1.LookupRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {google.datastore.v1.ILookupRequest} message LookupRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    LookupRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.readOptions != null && Object.hasOwnProperty.call(message, "readOptions"))
                            $root.google.datastore.v1.ReadOptions.encode(message.readOptions, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.keys != null && message.keys.length)
                            for (var i = 0; i < message.keys.length; ++i)
                                $root.google.datastore.v1.Key.encode(message.keys[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 8, wireType 2 =*/66).string(message.projectId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified LookupRequest message, length delimited. Does not implicitly {@link google.datastore.v1.LookupRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {google.datastore.v1.ILookupRequest} message LookupRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    LookupRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a LookupRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.LookupRequest} LookupRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    LookupRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.LookupRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 8:
                                message.projectId = reader.string();
                                break;
                            case 1:
                                message.readOptions = $root.google.datastore.v1.ReadOptions.decode(reader, reader.uint32());
                                break;
                            case 3:
                                if (!(message.keys && message.keys.length))
                                    message.keys = [];
                                message.keys.push($root.google.datastore.v1.Key.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a LookupRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.LookupRequest} LookupRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    LookupRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a LookupRequest message.
                     * @function verify
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    LookupRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.readOptions != null && message.hasOwnProperty("readOptions")) {
                            var error = $root.google.datastore.v1.ReadOptions.verify(message.readOptions);
                            if (error)
                                return "readOptions." + error;
                        }
                        if (message.keys != null && message.hasOwnProperty("keys")) {
                            if (!Array.isArray(message.keys))
                                return "keys: array expected";
                            for (var i = 0; i < message.keys.length; ++i) {
                                var error = $root.google.datastore.v1.Key.verify(message.keys[i]);
                                if (error)
                                    return "keys." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a LookupRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.LookupRequest} LookupRequest
                     */
                    LookupRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.LookupRequest)
                            return object;
                        var message = new $root.google.datastore.v1.LookupRequest();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        if (object.readOptions != null) {
                            if (typeof object.readOptions !== "object")
                                throw TypeError(".google.datastore.v1.LookupRequest.readOptions: object expected");
                            message.readOptions = $root.google.datastore.v1.ReadOptions.fromObject(object.readOptions);
                        }
                        if (object.keys) {
                            if (!Array.isArray(object.keys))
                                throw TypeError(".google.datastore.v1.LookupRequest.keys: array expected");
                            message.keys = [];
                            for (var i = 0; i < object.keys.length; ++i) {
                                if (typeof object.keys[i] !== "object")
                                    throw TypeError(".google.datastore.v1.LookupRequest.keys: object expected");
                                message.keys[i] = $root.google.datastore.v1.Key.fromObject(object.keys[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a LookupRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.LookupRequest
                     * @static
                     * @param {google.datastore.v1.LookupRequest} message LookupRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    LookupRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.keys = [];
                        if (options.defaults) {
                            object.readOptions = null;
                            object.projectId = "";
                        }
                        if (message.readOptions != null && message.hasOwnProperty("readOptions"))
                            object.readOptions = $root.google.datastore.v1.ReadOptions.toObject(message.readOptions, options);
                        if (message.keys && message.keys.length) {
                            object.keys = [];
                            for (var j = 0; j < message.keys.length; ++j)
                                object.keys[j] = $root.google.datastore.v1.Key.toObject(message.keys[j], options);
                        }
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        return object;
                    };
    
                    /**
                     * Converts this LookupRequest to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.LookupRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    LookupRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return LookupRequest;
                })();
    
                v1.LookupResponse = (function() {
    
                    /**
                     * Properties of a LookupResponse.
                     * @memberof google.datastore.v1
                     * @interface ILookupResponse
                     * @property {Array.<google.datastore.v1.IEntityResult>|null} [found] LookupResponse found
                     * @property {Array.<google.datastore.v1.IEntityResult>|null} [missing] LookupResponse missing
                     * @property {Array.<google.datastore.v1.IKey>|null} [deferred] LookupResponse deferred
                     */
    
                    /**
                     * Constructs a new LookupResponse.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a LookupResponse.
                     * @implements ILookupResponse
                     * @constructor
                     * @param {google.datastore.v1.ILookupResponse=} [properties] Properties to set
                     */
                    function LookupResponse(properties) {
                        this.found = [];
                        this.missing = [];
                        this.deferred = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * LookupResponse found.
                     * @member {Array.<google.datastore.v1.IEntityResult>} found
                     * @memberof google.datastore.v1.LookupResponse
                     * @instance
                     */
                    LookupResponse.prototype.found = $util.emptyArray;
    
                    /**
                     * LookupResponse missing.
                     * @member {Array.<google.datastore.v1.IEntityResult>} missing
                     * @memberof google.datastore.v1.LookupResponse
                     * @instance
                     */
                    LookupResponse.prototype.missing = $util.emptyArray;
    
                    /**
                     * LookupResponse deferred.
                     * @member {Array.<google.datastore.v1.IKey>} deferred
                     * @memberof google.datastore.v1.LookupResponse
                     * @instance
                     */
                    LookupResponse.prototype.deferred = $util.emptyArray;
    
                    /**
                     * Creates a new LookupResponse instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {google.datastore.v1.ILookupResponse=} [properties] Properties to set
                     * @returns {google.datastore.v1.LookupResponse} LookupResponse instance
                     */
                    LookupResponse.create = function create(properties) {
                        return new LookupResponse(properties);
                    };
    
                    /**
                     * Encodes the specified LookupResponse message. Does not implicitly {@link google.datastore.v1.LookupResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {google.datastore.v1.ILookupResponse} message LookupResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    LookupResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.found != null && message.found.length)
                            for (var i = 0; i < message.found.length; ++i)
                                $root.google.datastore.v1.EntityResult.encode(message.found[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.missing != null && message.missing.length)
                            for (var i = 0; i < message.missing.length; ++i)
                                $root.google.datastore.v1.EntityResult.encode(message.missing[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.deferred != null && message.deferred.length)
                            for (var i = 0; i < message.deferred.length; ++i)
                                $root.google.datastore.v1.Key.encode(message.deferred[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified LookupResponse message, length delimited. Does not implicitly {@link google.datastore.v1.LookupResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {google.datastore.v1.ILookupResponse} message LookupResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    LookupResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a LookupResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.LookupResponse} LookupResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    LookupResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.LookupResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                if (!(message.found && message.found.length))
                                    message.found = [];
                                message.found.push($root.google.datastore.v1.EntityResult.decode(reader, reader.uint32()));
                                break;
                            case 2:
                                if (!(message.missing && message.missing.length))
                                    message.missing = [];
                                message.missing.push($root.google.datastore.v1.EntityResult.decode(reader, reader.uint32()));
                                break;
                            case 3:
                                if (!(message.deferred && message.deferred.length))
                                    message.deferred = [];
                                message.deferred.push($root.google.datastore.v1.Key.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a LookupResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.LookupResponse} LookupResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    LookupResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a LookupResponse message.
                     * @function verify
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    LookupResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.found != null && message.hasOwnProperty("found")) {
                            if (!Array.isArray(message.found))
                                return "found: array expected";
                            for (var i = 0; i < message.found.length; ++i) {
                                var error = $root.google.datastore.v1.EntityResult.verify(message.found[i]);
                                if (error)
                                    return "found." + error;
                            }
                        }
                        if (message.missing != null && message.hasOwnProperty("missing")) {
                            if (!Array.isArray(message.missing))
                                return "missing: array expected";
                            for (var i = 0; i < message.missing.length; ++i) {
                                var error = $root.google.datastore.v1.EntityResult.verify(message.missing[i]);
                                if (error)
                                    return "missing." + error;
                            }
                        }
                        if (message.deferred != null && message.hasOwnProperty("deferred")) {
                            if (!Array.isArray(message.deferred))
                                return "deferred: array expected";
                            for (var i = 0; i < message.deferred.length; ++i) {
                                var error = $root.google.datastore.v1.Key.verify(message.deferred[i]);
                                if (error)
                                    return "deferred." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a LookupResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.LookupResponse} LookupResponse
                     */
                    LookupResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.LookupResponse)
                            return object;
                        var message = new $root.google.datastore.v1.LookupResponse();
                        if (object.found) {
                            if (!Array.isArray(object.found))
                                throw TypeError(".google.datastore.v1.LookupResponse.found: array expected");
                            message.found = [];
                            for (var i = 0; i < object.found.length; ++i) {
                                if (typeof object.found[i] !== "object")
                                    throw TypeError(".google.datastore.v1.LookupResponse.found: object expected");
                                message.found[i] = $root.google.datastore.v1.EntityResult.fromObject(object.found[i]);
                            }
                        }
                        if (object.missing) {
                            if (!Array.isArray(object.missing))
                                throw TypeError(".google.datastore.v1.LookupResponse.missing: array expected");
                            message.missing = [];
                            for (var i = 0; i < object.missing.length; ++i) {
                                if (typeof object.missing[i] !== "object")
                                    throw TypeError(".google.datastore.v1.LookupResponse.missing: object expected");
                                message.missing[i] = $root.google.datastore.v1.EntityResult.fromObject(object.missing[i]);
                            }
                        }
                        if (object.deferred) {
                            if (!Array.isArray(object.deferred))
                                throw TypeError(".google.datastore.v1.LookupResponse.deferred: array expected");
                            message.deferred = [];
                            for (var i = 0; i < object.deferred.length; ++i) {
                                if (typeof object.deferred[i] !== "object")
                                    throw TypeError(".google.datastore.v1.LookupResponse.deferred: object expected");
                                message.deferred[i] = $root.google.datastore.v1.Key.fromObject(object.deferred[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a LookupResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.LookupResponse
                     * @static
                     * @param {google.datastore.v1.LookupResponse} message LookupResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    LookupResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults) {
                            object.found = [];
                            object.missing = [];
                            object.deferred = [];
                        }
                        if (message.found && message.found.length) {
                            object.found = [];
                            for (var j = 0; j < message.found.length; ++j)
                                object.found[j] = $root.google.datastore.v1.EntityResult.toObject(message.found[j], options);
                        }
                        if (message.missing && message.missing.length) {
                            object.missing = [];
                            for (var j = 0; j < message.missing.length; ++j)
                                object.missing[j] = $root.google.datastore.v1.EntityResult.toObject(message.missing[j], options);
                        }
                        if (message.deferred && message.deferred.length) {
                            object.deferred = [];
                            for (var j = 0; j < message.deferred.length; ++j)
                                object.deferred[j] = $root.google.datastore.v1.Key.toObject(message.deferred[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this LookupResponse to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.LookupResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    LookupResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return LookupResponse;
                })();
    
                v1.RunQueryRequest = (function() {
    
                    /**
                     * Properties of a RunQueryRequest.
                     * @memberof google.datastore.v1
                     * @interface IRunQueryRequest
                     * @property {string|null} [projectId] RunQueryRequest projectId
                     * @property {google.datastore.v1.IPartitionId|null} [partitionId] RunQueryRequest partitionId
                     * @property {google.datastore.v1.IReadOptions|null} [readOptions] RunQueryRequest readOptions
                     * @property {google.datastore.v1.IQuery|null} [query] RunQueryRequest query
                     * @property {google.datastore.v1.IGqlQuery|null} [gqlQuery] RunQueryRequest gqlQuery
                     */
    
                    /**
                     * Constructs a new RunQueryRequest.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a RunQueryRequest.
                     * @implements IRunQueryRequest
                     * @constructor
                     * @param {google.datastore.v1.IRunQueryRequest=} [properties] Properties to set
                     */
                    function RunQueryRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * RunQueryRequest projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @instance
                     */
                    RunQueryRequest.prototype.projectId = "";
    
                    /**
                     * RunQueryRequest partitionId.
                     * @member {google.datastore.v1.IPartitionId|null|undefined} partitionId
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @instance
                     */
                    RunQueryRequest.prototype.partitionId = null;
    
                    /**
                     * RunQueryRequest readOptions.
                     * @member {google.datastore.v1.IReadOptions|null|undefined} readOptions
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @instance
                     */
                    RunQueryRequest.prototype.readOptions = null;
    
                    /**
                     * RunQueryRequest query.
                     * @member {google.datastore.v1.IQuery|null|undefined} query
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @instance
                     */
                    RunQueryRequest.prototype.query = null;
    
                    /**
                     * RunQueryRequest gqlQuery.
                     * @member {google.datastore.v1.IGqlQuery|null|undefined} gqlQuery
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @instance
                     */
                    RunQueryRequest.prototype.gqlQuery = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * RunQueryRequest queryType.
                     * @member {"query"|"gqlQuery"|undefined} queryType
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @instance
                     */
                    Object.defineProperty(RunQueryRequest.prototype, "queryType", {
                        get: $util.oneOfGetter($oneOfFields = ["query", "gqlQuery"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new RunQueryRequest instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {google.datastore.v1.IRunQueryRequest=} [properties] Properties to set
                     * @returns {google.datastore.v1.RunQueryRequest} RunQueryRequest instance
                     */
                    RunQueryRequest.create = function create(properties) {
                        return new RunQueryRequest(properties);
                    };
    
                    /**
                     * Encodes the specified RunQueryRequest message. Does not implicitly {@link google.datastore.v1.RunQueryRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {google.datastore.v1.IRunQueryRequest} message RunQueryRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RunQueryRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.readOptions != null && Object.hasOwnProperty.call(message, "readOptions"))
                            $root.google.datastore.v1.ReadOptions.encode(message.readOptions, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.partitionId != null && Object.hasOwnProperty.call(message, "partitionId"))
                            $root.google.datastore.v1.PartitionId.encode(message.partitionId, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.query != null && Object.hasOwnProperty.call(message, "query"))
                            $root.google.datastore.v1.Query.encode(message.query, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.gqlQuery != null && Object.hasOwnProperty.call(message, "gqlQuery"))
                            $root.google.datastore.v1.GqlQuery.encode(message.gqlQuery, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 8, wireType 2 =*/66).string(message.projectId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified RunQueryRequest message, length delimited. Does not implicitly {@link google.datastore.v1.RunQueryRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {google.datastore.v1.IRunQueryRequest} message RunQueryRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RunQueryRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a RunQueryRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.RunQueryRequest} RunQueryRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RunQueryRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.RunQueryRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 8:
                                message.projectId = reader.string();
                                break;
                            case 2:
                                message.partitionId = $root.google.datastore.v1.PartitionId.decode(reader, reader.uint32());
                                break;
                            case 1:
                                message.readOptions = $root.google.datastore.v1.ReadOptions.decode(reader, reader.uint32());
                                break;
                            case 3:
                                message.query = $root.google.datastore.v1.Query.decode(reader, reader.uint32());
                                break;
                            case 7:
                                message.gqlQuery = $root.google.datastore.v1.GqlQuery.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a RunQueryRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.RunQueryRequest} RunQueryRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RunQueryRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a RunQueryRequest message.
                     * @function verify
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    RunQueryRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.partitionId != null && message.hasOwnProperty("partitionId")) {
                            var error = $root.google.datastore.v1.PartitionId.verify(message.partitionId);
                            if (error)
                                return "partitionId." + error;
                        }
                        if (message.readOptions != null && message.hasOwnProperty("readOptions")) {
                            var error = $root.google.datastore.v1.ReadOptions.verify(message.readOptions);
                            if (error)
                                return "readOptions." + error;
                        }
                        if (message.query != null && message.hasOwnProperty("query")) {
                            properties.queryType = 1;
                            {
                                var error = $root.google.datastore.v1.Query.verify(message.query);
                                if (error)
                                    return "query." + error;
                            }
                        }
                        if (message.gqlQuery != null && message.hasOwnProperty("gqlQuery")) {
                            if (properties.queryType === 1)
                                return "queryType: multiple values";
                            properties.queryType = 1;
                            {
                                var error = $root.google.datastore.v1.GqlQuery.verify(message.gqlQuery);
                                if (error)
                                    return "gqlQuery." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a RunQueryRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.RunQueryRequest} RunQueryRequest
                     */
                    RunQueryRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.RunQueryRequest)
                            return object;
                        var message = new $root.google.datastore.v1.RunQueryRequest();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        if (object.partitionId != null) {
                            if (typeof object.partitionId !== "object")
                                throw TypeError(".google.datastore.v1.RunQueryRequest.partitionId: object expected");
                            message.partitionId = $root.google.datastore.v1.PartitionId.fromObject(object.partitionId);
                        }
                        if (object.readOptions != null) {
                            if (typeof object.readOptions !== "object")
                                throw TypeError(".google.datastore.v1.RunQueryRequest.readOptions: object expected");
                            message.readOptions = $root.google.datastore.v1.ReadOptions.fromObject(object.readOptions);
                        }
                        if (object.query != null) {
                            if (typeof object.query !== "object")
                                throw TypeError(".google.datastore.v1.RunQueryRequest.query: object expected");
                            message.query = $root.google.datastore.v1.Query.fromObject(object.query);
                        }
                        if (object.gqlQuery != null) {
                            if (typeof object.gqlQuery !== "object")
                                throw TypeError(".google.datastore.v1.RunQueryRequest.gqlQuery: object expected");
                            message.gqlQuery = $root.google.datastore.v1.GqlQuery.fromObject(object.gqlQuery);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a RunQueryRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @static
                     * @param {google.datastore.v1.RunQueryRequest} message RunQueryRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    RunQueryRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.readOptions = null;
                            object.partitionId = null;
                            object.projectId = "";
                        }
                        if (message.readOptions != null && message.hasOwnProperty("readOptions"))
                            object.readOptions = $root.google.datastore.v1.ReadOptions.toObject(message.readOptions, options);
                        if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                            object.partitionId = $root.google.datastore.v1.PartitionId.toObject(message.partitionId, options);
                        if (message.query != null && message.hasOwnProperty("query")) {
                            object.query = $root.google.datastore.v1.Query.toObject(message.query, options);
                            if (options.oneofs)
                                object.queryType = "query";
                        }
                        if (message.gqlQuery != null && message.hasOwnProperty("gqlQuery")) {
                            object.gqlQuery = $root.google.datastore.v1.GqlQuery.toObject(message.gqlQuery, options);
                            if (options.oneofs)
                                object.queryType = "gqlQuery";
                        }
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        return object;
                    };
    
                    /**
                     * Converts this RunQueryRequest to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.RunQueryRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    RunQueryRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return RunQueryRequest;
                })();
    
                v1.RunQueryResponse = (function() {
    
                    /**
                     * Properties of a RunQueryResponse.
                     * @memberof google.datastore.v1
                     * @interface IRunQueryResponse
                     * @property {google.datastore.v1.IQueryResultBatch|null} [batch] RunQueryResponse batch
                     * @property {google.datastore.v1.IQuery|null} [query] RunQueryResponse query
                     */
    
                    /**
                     * Constructs a new RunQueryResponse.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a RunQueryResponse.
                     * @implements IRunQueryResponse
                     * @constructor
                     * @param {google.datastore.v1.IRunQueryResponse=} [properties] Properties to set
                     */
                    function RunQueryResponse(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * RunQueryResponse batch.
                     * @member {google.datastore.v1.IQueryResultBatch|null|undefined} batch
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @instance
                     */
                    RunQueryResponse.prototype.batch = null;
    
                    /**
                     * RunQueryResponse query.
                     * @member {google.datastore.v1.IQuery|null|undefined} query
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @instance
                     */
                    RunQueryResponse.prototype.query = null;
    
                    /**
                     * Creates a new RunQueryResponse instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {google.datastore.v1.IRunQueryResponse=} [properties] Properties to set
                     * @returns {google.datastore.v1.RunQueryResponse} RunQueryResponse instance
                     */
                    RunQueryResponse.create = function create(properties) {
                        return new RunQueryResponse(properties);
                    };
    
                    /**
                     * Encodes the specified RunQueryResponse message. Does not implicitly {@link google.datastore.v1.RunQueryResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {google.datastore.v1.IRunQueryResponse} message RunQueryResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RunQueryResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.batch != null && Object.hasOwnProperty.call(message, "batch"))
                            $root.google.datastore.v1.QueryResultBatch.encode(message.batch, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.query != null && Object.hasOwnProperty.call(message, "query"))
                            $root.google.datastore.v1.Query.encode(message.query, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified RunQueryResponse message, length delimited. Does not implicitly {@link google.datastore.v1.RunQueryResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {google.datastore.v1.IRunQueryResponse} message RunQueryResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RunQueryResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a RunQueryResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.RunQueryResponse} RunQueryResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RunQueryResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.RunQueryResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.batch = $root.google.datastore.v1.QueryResultBatch.decode(reader, reader.uint32());
                                break;
                            case 2:
                                message.query = $root.google.datastore.v1.Query.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a RunQueryResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.RunQueryResponse} RunQueryResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RunQueryResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a RunQueryResponse message.
                     * @function verify
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    RunQueryResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.batch != null && message.hasOwnProperty("batch")) {
                            var error = $root.google.datastore.v1.QueryResultBatch.verify(message.batch);
                            if (error)
                                return "batch." + error;
                        }
                        if (message.query != null && message.hasOwnProperty("query")) {
                            var error = $root.google.datastore.v1.Query.verify(message.query);
                            if (error)
                                return "query." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a RunQueryResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.RunQueryResponse} RunQueryResponse
                     */
                    RunQueryResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.RunQueryResponse)
                            return object;
                        var message = new $root.google.datastore.v1.RunQueryResponse();
                        if (object.batch != null) {
                            if (typeof object.batch !== "object")
                                throw TypeError(".google.datastore.v1.RunQueryResponse.batch: object expected");
                            message.batch = $root.google.datastore.v1.QueryResultBatch.fromObject(object.batch);
                        }
                        if (object.query != null) {
                            if (typeof object.query !== "object")
                                throw TypeError(".google.datastore.v1.RunQueryResponse.query: object expected");
                            message.query = $root.google.datastore.v1.Query.fromObject(object.query);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a RunQueryResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @static
                     * @param {google.datastore.v1.RunQueryResponse} message RunQueryResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    RunQueryResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.batch = null;
                            object.query = null;
                        }
                        if (message.batch != null && message.hasOwnProperty("batch"))
                            object.batch = $root.google.datastore.v1.QueryResultBatch.toObject(message.batch, options);
                        if (message.query != null && message.hasOwnProperty("query"))
                            object.query = $root.google.datastore.v1.Query.toObject(message.query, options);
                        return object;
                    };
    
                    /**
                     * Converts this RunQueryResponse to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.RunQueryResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    RunQueryResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return RunQueryResponse;
                })();
    
                v1.BeginTransactionRequest = (function() {
    
                    /**
                     * Properties of a BeginTransactionRequest.
                     * @memberof google.datastore.v1
                     * @interface IBeginTransactionRequest
                     * @property {string|null} [projectId] BeginTransactionRequest projectId
                     * @property {google.datastore.v1.ITransactionOptions|null} [transactionOptions] BeginTransactionRequest transactionOptions
                     */
    
                    /**
                     * Constructs a new BeginTransactionRequest.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a BeginTransactionRequest.
                     * @implements IBeginTransactionRequest
                     * @constructor
                     * @param {google.datastore.v1.IBeginTransactionRequest=} [properties] Properties to set
                     */
                    function BeginTransactionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * BeginTransactionRequest projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @instance
                     */
                    BeginTransactionRequest.prototype.projectId = "";
    
                    /**
                     * BeginTransactionRequest transactionOptions.
                     * @member {google.datastore.v1.ITransactionOptions|null|undefined} transactionOptions
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @instance
                     */
                    BeginTransactionRequest.prototype.transactionOptions = null;
    
                    /**
                     * Creates a new BeginTransactionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {google.datastore.v1.IBeginTransactionRequest=} [properties] Properties to set
                     * @returns {google.datastore.v1.BeginTransactionRequest} BeginTransactionRequest instance
                     */
                    BeginTransactionRequest.create = function create(properties) {
                        return new BeginTransactionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified BeginTransactionRequest message. Does not implicitly {@link google.datastore.v1.BeginTransactionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {google.datastore.v1.IBeginTransactionRequest} message BeginTransactionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BeginTransactionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 8, wireType 2 =*/66).string(message.projectId);
                        if (message.transactionOptions != null && Object.hasOwnProperty.call(message, "transactionOptions"))
                            $root.google.datastore.v1.TransactionOptions.encode(message.transactionOptions, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified BeginTransactionRequest message, length delimited. Does not implicitly {@link google.datastore.v1.BeginTransactionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {google.datastore.v1.IBeginTransactionRequest} message BeginTransactionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BeginTransactionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a BeginTransactionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.BeginTransactionRequest} BeginTransactionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BeginTransactionRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.BeginTransactionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 8:
                                message.projectId = reader.string();
                                break;
                            case 10:
                                message.transactionOptions = $root.google.datastore.v1.TransactionOptions.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a BeginTransactionRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.BeginTransactionRequest} BeginTransactionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BeginTransactionRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a BeginTransactionRequest message.
                     * @function verify
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    BeginTransactionRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.transactionOptions != null && message.hasOwnProperty("transactionOptions")) {
                            var error = $root.google.datastore.v1.TransactionOptions.verify(message.transactionOptions);
                            if (error)
                                return "transactionOptions." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a BeginTransactionRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.BeginTransactionRequest} BeginTransactionRequest
                     */
                    BeginTransactionRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.BeginTransactionRequest)
                            return object;
                        var message = new $root.google.datastore.v1.BeginTransactionRequest();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        if (object.transactionOptions != null) {
                            if (typeof object.transactionOptions !== "object")
                                throw TypeError(".google.datastore.v1.BeginTransactionRequest.transactionOptions: object expected");
                            message.transactionOptions = $root.google.datastore.v1.TransactionOptions.fromObject(object.transactionOptions);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a BeginTransactionRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @static
                     * @param {google.datastore.v1.BeginTransactionRequest} message BeginTransactionRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    BeginTransactionRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.projectId = "";
                            object.transactionOptions = null;
                        }
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        if (message.transactionOptions != null && message.hasOwnProperty("transactionOptions"))
                            object.transactionOptions = $root.google.datastore.v1.TransactionOptions.toObject(message.transactionOptions, options);
                        return object;
                    };
    
                    /**
                     * Converts this BeginTransactionRequest to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.BeginTransactionRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    BeginTransactionRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return BeginTransactionRequest;
                })();
    
                v1.BeginTransactionResponse = (function() {
    
                    /**
                     * Properties of a BeginTransactionResponse.
                     * @memberof google.datastore.v1
                     * @interface IBeginTransactionResponse
                     * @property {Uint8Array|null} [transaction] BeginTransactionResponse transaction
                     */
    
                    /**
                     * Constructs a new BeginTransactionResponse.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a BeginTransactionResponse.
                     * @implements IBeginTransactionResponse
                     * @constructor
                     * @param {google.datastore.v1.IBeginTransactionResponse=} [properties] Properties to set
                     */
                    function BeginTransactionResponse(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * BeginTransactionResponse transaction.
                     * @member {Uint8Array} transaction
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @instance
                     */
                    BeginTransactionResponse.prototype.transaction = $util.newBuffer([]);
    
                    /**
                     * Creates a new BeginTransactionResponse instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {google.datastore.v1.IBeginTransactionResponse=} [properties] Properties to set
                     * @returns {google.datastore.v1.BeginTransactionResponse} BeginTransactionResponse instance
                     */
                    BeginTransactionResponse.create = function create(properties) {
                        return new BeginTransactionResponse(properties);
                    };
    
                    /**
                     * Encodes the specified BeginTransactionResponse message. Does not implicitly {@link google.datastore.v1.BeginTransactionResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {google.datastore.v1.IBeginTransactionResponse} message BeginTransactionResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BeginTransactionResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.transaction != null && Object.hasOwnProperty.call(message, "transaction"))
                            writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.transaction);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified BeginTransactionResponse message, length delimited. Does not implicitly {@link google.datastore.v1.BeginTransactionResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {google.datastore.v1.IBeginTransactionResponse} message BeginTransactionResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BeginTransactionResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a BeginTransactionResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.BeginTransactionResponse} BeginTransactionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BeginTransactionResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.BeginTransactionResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.transaction = reader.bytes();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a BeginTransactionResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.BeginTransactionResponse} BeginTransactionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BeginTransactionResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a BeginTransactionResponse message.
                     * @function verify
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    BeginTransactionResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.transaction != null && message.hasOwnProperty("transaction"))
                            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
                                return "transaction: buffer expected";
                        return null;
                    };
    
                    /**
                     * Creates a BeginTransactionResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.BeginTransactionResponse} BeginTransactionResponse
                     */
                    BeginTransactionResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.BeginTransactionResponse)
                            return object;
                        var message = new $root.google.datastore.v1.BeginTransactionResponse();
                        if (object.transaction != null)
                            if (typeof object.transaction === "string")
                                $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
                            else if (object.transaction.length)
                                message.transaction = object.transaction;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a BeginTransactionResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @static
                     * @param {google.datastore.v1.BeginTransactionResponse} message BeginTransactionResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    BeginTransactionResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            if (options.bytes === String)
                                object.transaction = "";
                            else {
                                object.transaction = [];
                                if (options.bytes !== Array)
                                    object.transaction = $util.newBuffer(object.transaction);
                            }
                        if (message.transaction != null && message.hasOwnProperty("transaction"))
                            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
                        return object;
                    };
    
                    /**
                     * Converts this BeginTransactionResponse to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.BeginTransactionResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    BeginTransactionResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return BeginTransactionResponse;
                })();
    
                v1.RollbackRequest = (function() {
    
                    /**
                     * Properties of a RollbackRequest.
                     * @memberof google.datastore.v1
                     * @interface IRollbackRequest
                     * @property {string|null} [projectId] RollbackRequest projectId
                     * @property {Uint8Array|null} [transaction] RollbackRequest transaction
                     */
    
                    /**
                     * Constructs a new RollbackRequest.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a RollbackRequest.
                     * @implements IRollbackRequest
                     * @constructor
                     * @param {google.datastore.v1.IRollbackRequest=} [properties] Properties to set
                     */
                    function RollbackRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * RollbackRequest projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.RollbackRequest
                     * @instance
                     */
                    RollbackRequest.prototype.projectId = "";
    
                    /**
                     * RollbackRequest transaction.
                     * @member {Uint8Array} transaction
                     * @memberof google.datastore.v1.RollbackRequest
                     * @instance
                     */
                    RollbackRequest.prototype.transaction = $util.newBuffer([]);
    
                    /**
                     * Creates a new RollbackRequest instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {google.datastore.v1.IRollbackRequest=} [properties] Properties to set
                     * @returns {google.datastore.v1.RollbackRequest} RollbackRequest instance
                     */
                    RollbackRequest.create = function create(properties) {
                        return new RollbackRequest(properties);
                    };
    
                    /**
                     * Encodes the specified RollbackRequest message. Does not implicitly {@link google.datastore.v1.RollbackRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {google.datastore.v1.IRollbackRequest} message RollbackRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RollbackRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.transaction != null && Object.hasOwnProperty.call(message, "transaction"))
                            writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.transaction);
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 8, wireType 2 =*/66).string(message.projectId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified RollbackRequest message, length delimited. Does not implicitly {@link google.datastore.v1.RollbackRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {google.datastore.v1.IRollbackRequest} message RollbackRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RollbackRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a RollbackRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.RollbackRequest} RollbackRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RollbackRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.RollbackRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 8:
                                message.projectId = reader.string();
                                break;
                            case 1:
                                message.transaction = reader.bytes();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a RollbackRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.RollbackRequest} RollbackRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RollbackRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a RollbackRequest message.
                     * @function verify
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    RollbackRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.transaction != null && message.hasOwnProperty("transaction"))
                            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
                                return "transaction: buffer expected";
                        return null;
                    };
    
                    /**
                     * Creates a RollbackRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.RollbackRequest} RollbackRequest
                     */
                    RollbackRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.RollbackRequest)
                            return object;
                        var message = new $root.google.datastore.v1.RollbackRequest();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        if (object.transaction != null)
                            if (typeof object.transaction === "string")
                                $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
                            else if (object.transaction.length)
                                message.transaction = object.transaction;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a RollbackRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.RollbackRequest
                     * @static
                     * @param {google.datastore.v1.RollbackRequest} message RollbackRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    RollbackRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            if (options.bytes === String)
                                object.transaction = "";
                            else {
                                object.transaction = [];
                                if (options.bytes !== Array)
                                    object.transaction = $util.newBuffer(object.transaction);
                            }
                            object.projectId = "";
                        }
                        if (message.transaction != null && message.hasOwnProperty("transaction"))
                            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        return object;
                    };
    
                    /**
                     * Converts this RollbackRequest to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.RollbackRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    RollbackRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return RollbackRequest;
                })();
    
                v1.RollbackResponse = (function() {
    
                    /**
                     * Properties of a RollbackResponse.
                     * @memberof google.datastore.v1
                     * @interface IRollbackResponse
                     */
    
                    /**
                     * Constructs a new RollbackResponse.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a RollbackResponse.
                     * @implements IRollbackResponse
                     * @constructor
                     * @param {google.datastore.v1.IRollbackResponse=} [properties] Properties to set
                     */
                    function RollbackResponse(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Creates a new RollbackResponse instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {google.datastore.v1.IRollbackResponse=} [properties] Properties to set
                     * @returns {google.datastore.v1.RollbackResponse} RollbackResponse instance
                     */
                    RollbackResponse.create = function create(properties) {
                        return new RollbackResponse(properties);
                    };
    
                    /**
                     * Encodes the specified RollbackResponse message. Does not implicitly {@link google.datastore.v1.RollbackResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {google.datastore.v1.IRollbackResponse} message RollbackResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RollbackResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified RollbackResponse message, length delimited. Does not implicitly {@link google.datastore.v1.RollbackResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {google.datastore.v1.IRollbackResponse} message RollbackResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RollbackResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a RollbackResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.RollbackResponse} RollbackResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RollbackResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.RollbackResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a RollbackResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.RollbackResponse} RollbackResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RollbackResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a RollbackResponse message.
                     * @function verify
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    RollbackResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        return null;
                    };
    
                    /**
                     * Creates a RollbackResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.RollbackResponse} RollbackResponse
                     */
                    RollbackResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.RollbackResponse)
                            return object;
                        return new $root.google.datastore.v1.RollbackResponse();
                    };
    
                    /**
                     * Creates a plain object from a RollbackResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.RollbackResponse
                     * @static
                     * @param {google.datastore.v1.RollbackResponse} message RollbackResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    RollbackResponse.toObject = function toObject() {
                        return {};
                    };
    
                    /**
                     * Converts this RollbackResponse to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.RollbackResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    RollbackResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return RollbackResponse;
                })();
    
                v1.CommitRequest = (function() {
    
                    /**
                     * Properties of a CommitRequest.
                     * @memberof google.datastore.v1
                     * @interface ICommitRequest
                     * @property {string|null} [projectId] CommitRequest projectId
                     * @property {google.datastore.v1.CommitRequest.Mode|null} [mode] CommitRequest mode
                     * @property {Uint8Array|null} [transaction] CommitRequest transaction
                     * @property {Array.<google.datastore.v1.IMutation>|null} [mutations] CommitRequest mutations
                     */
    
                    /**
                     * Constructs a new CommitRequest.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a CommitRequest.
                     * @implements ICommitRequest
                     * @constructor
                     * @param {google.datastore.v1.ICommitRequest=} [properties] Properties to set
                     */
                    function CommitRequest(properties) {
                        this.mutations = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * CommitRequest projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.CommitRequest
                     * @instance
                     */
                    CommitRequest.prototype.projectId = "";
    
                    /**
                     * CommitRequest mode.
                     * @member {google.datastore.v1.CommitRequest.Mode} mode
                     * @memberof google.datastore.v1.CommitRequest
                     * @instance
                     */
                    CommitRequest.prototype.mode = 0;
    
                    /**
                     * CommitRequest transaction.
                     * @member {Uint8Array} transaction
                     * @memberof google.datastore.v1.CommitRequest
                     * @instance
                     */
                    CommitRequest.prototype.transaction = $util.newBuffer([]);
    
                    /**
                     * CommitRequest mutations.
                     * @member {Array.<google.datastore.v1.IMutation>} mutations
                     * @memberof google.datastore.v1.CommitRequest
                     * @instance
                     */
                    CommitRequest.prototype.mutations = $util.emptyArray;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * CommitRequest transactionSelector.
                     * @member {"transaction"|undefined} transactionSelector
                     * @memberof google.datastore.v1.CommitRequest
                     * @instance
                     */
                    Object.defineProperty(CommitRequest.prototype, "transactionSelector", {
                        get: $util.oneOfGetter($oneOfFields = ["transaction"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new CommitRequest instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {google.datastore.v1.ICommitRequest=} [properties] Properties to set
                     * @returns {google.datastore.v1.CommitRequest} CommitRequest instance
                     */
                    CommitRequest.create = function create(properties) {
                        return new CommitRequest(properties);
                    };
    
                    /**
                     * Encodes the specified CommitRequest message. Does not implicitly {@link google.datastore.v1.CommitRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {google.datastore.v1.ICommitRequest} message CommitRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CommitRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.transaction != null && Object.hasOwnProperty.call(message, "transaction"))
                            writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.transaction);
                        if (message.mode != null && Object.hasOwnProperty.call(message, "mode"))
                            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.mode);
                        if (message.mutations != null && message.mutations.length)
                            for (var i = 0; i < message.mutations.length; ++i)
                                $root.google.datastore.v1.Mutation.encode(message.mutations[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 8, wireType 2 =*/66).string(message.projectId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified CommitRequest message, length delimited. Does not implicitly {@link google.datastore.v1.CommitRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {google.datastore.v1.ICommitRequest} message CommitRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CommitRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a CommitRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.CommitRequest} CommitRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CommitRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.CommitRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 8:
                                message.projectId = reader.string();
                                break;
                            case 5:
                                message.mode = reader.int32();
                                break;
                            case 1:
                                message.transaction = reader.bytes();
                                break;
                            case 6:
                                if (!(message.mutations && message.mutations.length))
                                    message.mutations = [];
                                message.mutations.push($root.google.datastore.v1.Mutation.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a CommitRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.CommitRequest} CommitRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CommitRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a CommitRequest message.
                     * @function verify
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    CommitRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.mode != null && message.hasOwnProperty("mode"))
                            switch (message.mode) {
                            default:
                                return "mode: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.transaction != null && message.hasOwnProperty("transaction")) {
                            properties.transactionSelector = 1;
                            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
                                return "transaction: buffer expected";
                        }
                        if (message.mutations != null && message.hasOwnProperty("mutations")) {
                            if (!Array.isArray(message.mutations))
                                return "mutations: array expected";
                            for (var i = 0; i < message.mutations.length; ++i) {
                                var error = $root.google.datastore.v1.Mutation.verify(message.mutations[i]);
                                if (error)
                                    return "mutations." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a CommitRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.CommitRequest} CommitRequest
                     */
                    CommitRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.CommitRequest)
                            return object;
                        var message = new $root.google.datastore.v1.CommitRequest();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        switch (object.mode) {
                        case "MODE_UNSPECIFIED":
                        case 0:
                            message.mode = 0;
                            break;
                        case "TRANSACTIONAL":
                        case 1:
                            message.mode = 1;
                            break;
                        case "NON_TRANSACTIONAL":
                        case 2:
                            message.mode = 2;
                            break;
                        }
                        if (object.transaction != null)
                            if (typeof object.transaction === "string")
                                $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
                            else if (object.transaction.length)
                                message.transaction = object.transaction;
                        if (object.mutations) {
                            if (!Array.isArray(object.mutations))
                                throw TypeError(".google.datastore.v1.CommitRequest.mutations: array expected");
                            message.mutations = [];
                            for (var i = 0; i < object.mutations.length; ++i) {
                                if (typeof object.mutations[i] !== "object")
                                    throw TypeError(".google.datastore.v1.CommitRequest.mutations: object expected");
                                message.mutations[i] = $root.google.datastore.v1.Mutation.fromObject(object.mutations[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a CommitRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.CommitRequest
                     * @static
                     * @param {google.datastore.v1.CommitRequest} message CommitRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    CommitRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.mutations = [];
                        if (options.defaults) {
                            object.mode = options.enums === String ? "MODE_UNSPECIFIED" : 0;
                            object.projectId = "";
                        }
                        if (message.transaction != null && message.hasOwnProperty("transaction")) {
                            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
                            if (options.oneofs)
                                object.transactionSelector = "transaction";
                        }
                        if (message.mode != null && message.hasOwnProperty("mode"))
                            object.mode = options.enums === String ? $root.google.datastore.v1.CommitRequest.Mode[message.mode] : message.mode;
                        if (message.mutations && message.mutations.length) {
                            object.mutations = [];
                            for (var j = 0; j < message.mutations.length; ++j)
                                object.mutations[j] = $root.google.datastore.v1.Mutation.toObject(message.mutations[j], options);
                        }
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        return object;
                    };
    
                    /**
                     * Converts this CommitRequest to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.CommitRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    CommitRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Mode enum.
                     * @name google.datastore.v1.CommitRequest.Mode
                     * @enum {number}
                     * @property {number} MODE_UNSPECIFIED=0 MODE_UNSPECIFIED value
                     * @property {number} TRANSACTIONAL=1 TRANSACTIONAL value
                     * @property {number} NON_TRANSACTIONAL=2 NON_TRANSACTIONAL value
                     */
                    CommitRequest.Mode = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "MODE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "TRANSACTIONAL"] = 1;
                        values[valuesById[2] = "NON_TRANSACTIONAL"] = 2;
                        return values;
                    })();
    
                    return CommitRequest;
                })();
    
                v1.CommitResponse = (function() {
    
                    /**
                     * Properties of a CommitResponse.
                     * @memberof google.datastore.v1
                     * @interface ICommitResponse
                     * @property {Array.<google.datastore.v1.IMutationResult>|null} [mutationResults] CommitResponse mutationResults
                     * @property {number|null} [indexUpdates] CommitResponse indexUpdates
                     */
    
                    /**
                     * Constructs a new CommitResponse.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a CommitResponse.
                     * @implements ICommitResponse
                     * @constructor
                     * @param {google.datastore.v1.ICommitResponse=} [properties] Properties to set
                     */
                    function CommitResponse(properties) {
                        this.mutationResults = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * CommitResponse mutationResults.
                     * @member {Array.<google.datastore.v1.IMutationResult>} mutationResults
                     * @memberof google.datastore.v1.CommitResponse
                     * @instance
                     */
                    CommitResponse.prototype.mutationResults = $util.emptyArray;
    
                    /**
                     * CommitResponse indexUpdates.
                     * @member {number} indexUpdates
                     * @memberof google.datastore.v1.CommitResponse
                     * @instance
                     */
                    CommitResponse.prototype.indexUpdates = 0;
    
                    /**
                     * Creates a new CommitResponse instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {google.datastore.v1.ICommitResponse=} [properties] Properties to set
                     * @returns {google.datastore.v1.CommitResponse} CommitResponse instance
                     */
                    CommitResponse.create = function create(properties) {
                        return new CommitResponse(properties);
                    };
    
                    /**
                     * Encodes the specified CommitResponse message. Does not implicitly {@link google.datastore.v1.CommitResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {google.datastore.v1.ICommitResponse} message CommitResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CommitResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.mutationResults != null && message.mutationResults.length)
                            for (var i = 0; i < message.mutationResults.length; ++i)
                                $root.google.datastore.v1.MutationResult.encode(message.mutationResults[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.indexUpdates != null && Object.hasOwnProperty.call(message, "indexUpdates"))
                            writer.uint32(/* id 4, wireType 0 =*/32).int32(message.indexUpdates);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified CommitResponse message, length delimited. Does not implicitly {@link google.datastore.v1.CommitResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {google.datastore.v1.ICommitResponse} message CommitResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CommitResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a CommitResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.CommitResponse} CommitResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CommitResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.CommitResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 3:
                                if (!(message.mutationResults && message.mutationResults.length))
                                    message.mutationResults = [];
                                message.mutationResults.push($root.google.datastore.v1.MutationResult.decode(reader, reader.uint32()));
                                break;
                            case 4:
                                message.indexUpdates = reader.int32();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a CommitResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.CommitResponse} CommitResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CommitResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a CommitResponse message.
                     * @function verify
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    CommitResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.mutationResults != null && message.hasOwnProperty("mutationResults")) {
                            if (!Array.isArray(message.mutationResults))
                                return "mutationResults: array expected";
                            for (var i = 0; i < message.mutationResults.length; ++i) {
                                var error = $root.google.datastore.v1.MutationResult.verify(message.mutationResults[i]);
                                if (error)
                                    return "mutationResults." + error;
                            }
                        }
                        if (message.indexUpdates != null && message.hasOwnProperty("indexUpdates"))
                            if (!$util.isInteger(message.indexUpdates))
                                return "indexUpdates: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a CommitResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.CommitResponse} CommitResponse
                     */
                    CommitResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.CommitResponse)
                            return object;
                        var message = new $root.google.datastore.v1.CommitResponse();
                        if (object.mutationResults) {
                            if (!Array.isArray(object.mutationResults))
                                throw TypeError(".google.datastore.v1.CommitResponse.mutationResults: array expected");
                            message.mutationResults = [];
                            for (var i = 0; i < object.mutationResults.length; ++i) {
                                if (typeof object.mutationResults[i] !== "object")
                                    throw TypeError(".google.datastore.v1.CommitResponse.mutationResults: object expected");
                                message.mutationResults[i] = $root.google.datastore.v1.MutationResult.fromObject(object.mutationResults[i]);
                            }
                        }
                        if (object.indexUpdates != null)
                            message.indexUpdates = object.indexUpdates | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a CommitResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.CommitResponse
                     * @static
                     * @param {google.datastore.v1.CommitResponse} message CommitResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    CommitResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.mutationResults = [];
                        if (options.defaults)
                            object.indexUpdates = 0;
                        if (message.mutationResults && message.mutationResults.length) {
                            object.mutationResults = [];
                            for (var j = 0; j < message.mutationResults.length; ++j)
                                object.mutationResults[j] = $root.google.datastore.v1.MutationResult.toObject(message.mutationResults[j], options);
                        }
                        if (message.indexUpdates != null && message.hasOwnProperty("indexUpdates"))
                            object.indexUpdates = message.indexUpdates;
                        return object;
                    };
    
                    /**
                     * Converts this CommitResponse to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.CommitResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    CommitResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return CommitResponse;
                })();
    
                v1.AllocateIdsRequest = (function() {
    
                    /**
                     * Properties of an AllocateIdsRequest.
                     * @memberof google.datastore.v1
                     * @interface IAllocateIdsRequest
                     * @property {string|null} [projectId] AllocateIdsRequest projectId
                     * @property {Array.<google.datastore.v1.IKey>|null} [keys] AllocateIdsRequest keys
                     */
    
                    /**
                     * Constructs a new AllocateIdsRequest.
                     * @memberof google.datastore.v1
                     * @classdesc Represents an AllocateIdsRequest.
                     * @implements IAllocateIdsRequest
                     * @constructor
                     * @param {google.datastore.v1.IAllocateIdsRequest=} [properties] Properties to set
                     */
                    function AllocateIdsRequest(properties) {
                        this.keys = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * AllocateIdsRequest projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @instance
                     */
                    AllocateIdsRequest.prototype.projectId = "";
    
                    /**
                     * AllocateIdsRequest keys.
                     * @member {Array.<google.datastore.v1.IKey>} keys
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @instance
                     */
                    AllocateIdsRequest.prototype.keys = $util.emptyArray;
    
                    /**
                     * Creates a new AllocateIdsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {google.datastore.v1.IAllocateIdsRequest=} [properties] Properties to set
                     * @returns {google.datastore.v1.AllocateIdsRequest} AllocateIdsRequest instance
                     */
                    AllocateIdsRequest.create = function create(properties) {
                        return new AllocateIdsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified AllocateIdsRequest message. Does not implicitly {@link google.datastore.v1.AllocateIdsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {google.datastore.v1.IAllocateIdsRequest} message AllocateIdsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    AllocateIdsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.keys != null && message.keys.length)
                            for (var i = 0; i < message.keys.length; ++i)
                                $root.google.datastore.v1.Key.encode(message.keys[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 8, wireType 2 =*/66).string(message.projectId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified AllocateIdsRequest message, length delimited. Does not implicitly {@link google.datastore.v1.AllocateIdsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {google.datastore.v1.IAllocateIdsRequest} message AllocateIdsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    AllocateIdsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an AllocateIdsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.AllocateIdsRequest} AllocateIdsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    AllocateIdsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.AllocateIdsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 8:
                                message.projectId = reader.string();
                                break;
                            case 1:
                                if (!(message.keys && message.keys.length))
                                    message.keys = [];
                                message.keys.push($root.google.datastore.v1.Key.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an AllocateIdsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.AllocateIdsRequest} AllocateIdsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    AllocateIdsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an AllocateIdsRequest message.
                     * @function verify
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    AllocateIdsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.keys != null && message.hasOwnProperty("keys")) {
                            if (!Array.isArray(message.keys))
                                return "keys: array expected";
                            for (var i = 0; i < message.keys.length; ++i) {
                                var error = $root.google.datastore.v1.Key.verify(message.keys[i]);
                                if (error)
                                    return "keys." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates an AllocateIdsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.AllocateIdsRequest} AllocateIdsRequest
                     */
                    AllocateIdsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.AllocateIdsRequest)
                            return object;
                        var message = new $root.google.datastore.v1.AllocateIdsRequest();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        if (object.keys) {
                            if (!Array.isArray(object.keys))
                                throw TypeError(".google.datastore.v1.AllocateIdsRequest.keys: array expected");
                            message.keys = [];
                            for (var i = 0; i < object.keys.length; ++i) {
                                if (typeof object.keys[i] !== "object")
                                    throw TypeError(".google.datastore.v1.AllocateIdsRequest.keys: object expected");
                                message.keys[i] = $root.google.datastore.v1.Key.fromObject(object.keys[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an AllocateIdsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @static
                     * @param {google.datastore.v1.AllocateIdsRequest} message AllocateIdsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    AllocateIdsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.keys = [];
                        if (options.defaults)
                            object.projectId = "";
                        if (message.keys && message.keys.length) {
                            object.keys = [];
                            for (var j = 0; j < message.keys.length; ++j)
                                object.keys[j] = $root.google.datastore.v1.Key.toObject(message.keys[j], options);
                        }
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        return object;
                    };
    
                    /**
                     * Converts this AllocateIdsRequest to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.AllocateIdsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    AllocateIdsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return AllocateIdsRequest;
                })();
    
                v1.AllocateIdsResponse = (function() {
    
                    /**
                     * Properties of an AllocateIdsResponse.
                     * @memberof google.datastore.v1
                     * @interface IAllocateIdsResponse
                     * @property {Array.<google.datastore.v1.IKey>|null} [keys] AllocateIdsResponse keys
                     */
    
                    /**
                     * Constructs a new AllocateIdsResponse.
                     * @memberof google.datastore.v1
                     * @classdesc Represents an AllocateIdsResponse.
                     * @implements IAllocateIdsResponse
                     * @constructor
                     * @param {google.datastore.v1.IAllocateIdsResponse=} [properties] Properties to set
                     */
                    function AllocateIdsResponse(properties) {
                        this.keys = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * AllocateIdsResponse keys.
                     * @member {Array.<google.datastore.v1.IKey>} keys
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @instance
                     */
                    AllocateIdsResponse.prototype.keys = $util.emptyArray;
    
                    /**
                     * Creates a new AllocateIdsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {google.datastore.v1.IAllocateIdsResponse=} [properties] Properties to set
                     * @returns {google.datastore.v1.AllocateIdsResponse} AllocateIdsResponse instance
                     */
                    AllocateIdsResponse.create = function create(properties) {
                        return new AllocateIdsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified AllocateIdsResponse message. Does not implicitly {@link google.datastore.v1.AllocateIdsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {google.datastore.v1.IAllocateIdsResponse} message AllocateIdsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    AllocateIdsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.keys != null && message.keys.length)
                            for (var i = 0; i < message.keys.length; ++i)
                                $root.google.datastore.v1.Key.encode(message.keys[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified AllocateIdsResponse message, length delimited. Does not implicitly {@link google.datastore.v1.AllocateIdsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {google.datastore.v1.IAllocateIdsResponse} message AllocateIdsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    AllocateIdsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an AllocateIdsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.AllocateIdsResponse} AllocateIdsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    AllocateIdsResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.AllocateIdsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                if (!(message.keys && message.keys.length))
                                    message.keys = [];
                                message.keys.push($root.google.datastore.v1.Key.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an AllocateIdsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.AllocateIdsResponse} AllocateIdsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    AllocateIdsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an AllocateIdsResponse message.
                     * @function verify
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    AllocateIdsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.keys != null && message.hasOwnProperty("keys")) {
                            if (!Array.isArray(message.keys))
                                return "keys: array expected";
                            for (var i = 0; i < message.keys.length; ++i) {
                                var error = $root.google.datastore.v1.Key.verify(message.keys[i]);
                                if (error)
                                    return "keys." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates an AllocateIdsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.AllocateIdsResponse} AllocateIdsResponse
                     */
                    AllocateIdsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.AllocateIdsResponse)
                            return object;
                        var message = new $root.google.datastore.v1.AllocateIdsResponse();
                        if (object.keys) {
                            if (!Array.isArray(object.keys))
                                throw TypeError(".google.datastore.v1.AllocateIdsResponse.keys: array expected");
                            message.keys = [];
                            for (var i = 0; i < object.keys.length; ++i) {
                                if (typeof object.keys[i] !== "object")
                                    throw TypeError(".google.datastore.v1.AllocateIdsResponse.keys: object expected");
                                message.keys[i] = $root.google.datastore.v1.Key.fromObject(object.keys[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an AllocateIdsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @static
                     * @param {google.datastore.v1.AllocateIdsResponse} message AllocateIdsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    AllocateIdsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.keys = [];
                        if (message.keys && message.keys.length) {
                            object.keys = [];
                            for (var j = 0; j < message.keys.length; ++j)
                                object.keys[j] = $root.google.datastore.v1.Key.toObject(message.keys[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this AllocateIdsResponse to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.AllocateIdsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    AllocateIdsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return AllocateIdsResponse;
                })();
    
                v1.ReserveIdsRequest = (function() {
    
                    /**
                     * Properties of a ReserveIdsRequest.
                     * @memberof google.datastore.v1
                     * @interface IReserveIdsRequest
                     * @property {string|null} [projectId] ReserveIdsRequest projectId
                     * @property {string|null} [databaseId] ReserveIdsRequest databaseId
                     * @property {Array.<google.datastore.v1.IKey>|null} [keys] ReserveIdsRequest keys
                     */
    
                    /**
                     * Constructs a new ReserveIdsRequest.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a ReserveIdsRequest.
                     * @implements IReserveIdsRequest
                     * @constructor
                     * @param {google.datastore.v1.IReserveIdsRequest=} [properties] Properties to set
                     */
                    function ReserveIdsRequest(properties) {
                        this.keys = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ReserveIdsRequest projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @instance
                     */
                    ReserveIdsRequest.prototype.projectId = "";
    
                    /**
                     * ReserveIdsRequest databaseId.
                     * @member {string} databaseId
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @instance
                     */
                    ReserveIdsRequest.prototype.databaseId = "";
    
                    /**
                     * ReserveIdsRequest keys.
                     * @member {Array.<google.datastore.v1.IKey>} keys
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @instance
                     */
                    ReserveIdsRequest.prototype.keys = $util.emptyArray;
    
                    /**
                     * Creates a new ReserveIdsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {google.datastore.v1.IReserveIdsRequest=} [properties] Properties to set
                     * @returns {google.datastore.v1.ReserveIdsRequest} ReserveIdsRequest instance
                     */
                    ReserveIdsRequest.create = function create(properties) {
                        return new ReserveIdsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ReserveIdsRequest message. Does not implicitly {@link google.datastore.v1.ReserveIdsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {google.datastore.v1.IReserveIdsRequest} message ReserveIdsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReserveIdsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.keys != null && message.keys.length)
                            for (var i = 0; i < message.keys.length; ++i)
                                $root.google.datastore.v1.Key.encode(message.keys[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 8, wireType 2 =*/66).string(message.projectId);
                        if (message.databaseId != null && Object.hasOwnProperty.call(message, "databaseId"))
                            writer.uint32(/* id 9, wireType 2 =*/74).string(message.databaseId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ReserveIdsRequest message, length delimited. Does not implicitly {@link google.datastore.v1.ReserveIdsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {google.datastore.v1.IReserveIdsRequest} message ReserveIdsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReserveIdsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ReserveIdsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.ReserveIdsRequest} ReserveIdsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReserveIdsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.ReserveIdsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 8:
                                message.projectId = reader.string();
                                break;
                            case 9:
                                message.databaseId = reader.string();
                                break;
                            case 1:
                                if (!(message.keys && message.keys.length))
                                    message.keys = [];
                                message.keys.push($root.google.datastore.v1.Key.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ReserveIdsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.ReserveIdsRequest} ReserveIdsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReserveIdsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ReserveIdsRequest message.
                     * @function verify
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ReserveIdsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.databaseId != null && message.hasOwnProperty("databaseId"))
                            if (!$util.isString(message.databaseId))
                                return "databaseId: string expected";
                        if (message.keys != null && message.hasOwnProperty("keys")) {
                            if (!Array.isArray(message.keys))
                                return "keys: array expected";
                            for (var i = 0; i < message.keys.length; ++i) {
                                var error = $root.google.datastore.v1.Key.verify(message.keys[i]);
                                if (error)
                                    return "keys." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a ReserveIdsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.ReserveIdsRequest} ReserveIdsRequest
                     */
                    ReserveIdsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.ReserveIdsRequest)
                            return object;
                        var message = new $root.google.datastore.v1.ReserveIdsRequest();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        if (object.databaseId != null)
                            message.databaseId = String(object.databaseId);
                        if (object.keys) {
                            if (!Array.isArray(object.keys))
                                throw TypeError(".google.datastore.v1.ReserveIdsRequest.keys: array expected");
                            message.keys = [];
                            for (var i = 0; i < object.keys.length; ++i) {
                                if (typeof object.keys[i] !== "object")
                                    throw TypeError(".google.datastore.v1.ReserveIdsRequest.keys: object expected");
                                message.keys[i] = $root.google.datastore.v1.Key.fromObject(object.keys[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ReserveIdsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @static
                     * @param {google.datastore.v1.ReserveIdsRequest} message ReserveIdsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ReserveIdsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.keys = [];
                        if (options.defaults) {
                            object.projectId = "";
                            object.databaseId = "";
                        }
                        if (message.keys && message.keys.length) {
                            object.keys = [];
                            for (var j = 0; j < message.keys.length; ++j)
                                object.keys[j] = $root.google.datastore.v1.Key.toObject(message.keys[j], options);
                        }
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        if (message.databaseId != null && message.hasOwnProperty("databaseId"))
                            object.databaseId = message.databaseId;
                        return object;
                    };
    
                    /**
                     * Converts this ReserveIdsRequest to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.ReserveIdsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ReserveIdsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return ReserveIdsRequest;
                })();
    
                v1.ReserveIdsResponse = (function() {
    
                    /**
                     * Properties of a ReserveIdsResponse.
                     * @memberof google.datastore.v1
                     * @interface IReserveIdsResponse
                     */
    
                    /**
                     * Constructs a new ReserveIdsResponse.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a ReserveIdsResponse.
                     * @implements IReserveIdsResponse
                     * @constructor
                     * @param {google.datastore.v1.IReserveIdsResponse=} [properties] Properties to set
                     */
                    function ReserveIdsResponse(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Creates a new ReserveIdsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {google.datastore.v1.IReserveIdsResponse=} [properties] Properties to set
                     * @returns {google.datastore.v1.ReserveIdsResponse} ReserveIdsResponse instance
                     */
                    ReserveIdsResponse.create = function create(properties) {
                        return new ReserveIdsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ReserveIdsResponse message. Does not implicitly {@link google.datastore.v1.ReserveIdsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {google.datastore.v1.IReserveIdsResponse} message ReserveIdsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReserveIdsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ReserveIdsResponse message, length delimited. Does not implicitly {@link google.datastore.v1.ReserveIdsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {google.datastore.v1.IReserveIdsResponse} message ReserveIdsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReserveIdsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ReserveIdsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.ReserveIdsResponse} ReserveIdsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReserveIdsResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.ReserveIdsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ReserveIdsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.ReserveIdsResponse} ReserveIdsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReserveIdsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ReserveIdsResponse message.
                     * @function verify
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ReserveIdsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        return null;
                    };
    
                    /**
                     * Creates a ReserveIdsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.ReserveIdsResponse} ReserveIdsResponse
                     */
                    ReserveIdsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.ReserveIdsResponse)
                            return object;
                        return new $root.google.datastore.v1.ReserveIdsResponse();
                    };
    
                    /**
                     * Creates a plain object from a ReserveIdsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @static
                     * @param {google.datastore.v1.ReserveIdsResponse} message ReserveIdsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ReserveIdsResponse.toObject = function toObject() {
                        return {};
                    };
    
                    /**
                     * Converts this ReserveIdsResponse to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.ReserveIdsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ReserveIdsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return ReserveIdsResponse;
                })();
    
                v1.Mutation = (function() {
    
                    /**
                     * Properties of a Mutation.
                     * @memberof google.datastore.v1
                     * @interface IMutation
                     * @property {google.datastore.v1.IEntity|null} [insert] Mutation insert
                     * @property {google.datastore.v1.IEntity|null} [update] Mutation update
                     * @property {google.datastore.v1.IEntity|null} [upsert] Mutation upsert
                     * @property {google.datastore.v1.IKey|null} ["delete"] Mutation delete
                     * @property {number|Long|null} [baseVersion] Mutation baseVersion
                     */
    
                    /**
                     * Constructs a new Mutation.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a Mutation.
                     * @implements IMutation
                     * @constructor
                     * @param {google.datastore.v1.IMutation=} [properties] Properties to set
                     */
                    function Mutation(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Mutation insert.
                     * @member {google.datastore.v1.IEntity|null|undefined} insert
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     */
                    Mutation.prototype.insert = null;
    
                    /**
                     * Mutation update.
                     * @member {google.datastore.v1.IEntity|null|undefined} update
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     */
                    Mutation.prototype.update = null;
    
                    /**
                     * Mutation upsert.
                     * @member {google.datastore.v1.IEntity|null|undefined} upsert
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     */
                    Mutation.prototype.upsert = null;
    
                    /**
                     * Mutation delete.
                     * @member {google.datastore.v1.IKey|null|undefined} delete
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     */
                    Mutation.prototype["delete"] = null;
    
                    /**
                     * Mutation baseVersion.
                     * @member {number|Long} baseVersion
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     */
                    Mutation.prototype.baseVersion = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * Mutation operation.
                     * @member {"insert"|"update"|"upsert"|"delete"|undefined} operation
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     */
                    Object.defineProperty(Mutation.prototype, "operation", {
                        get: $util.oneOfGetter($oneOfFields = ["insert", "update", "upsert", "delete"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Mutation conflictDetectionStrategy.
                     * @member {"baseVersion"|undefined} conflictDetectionStrategy
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     */
                    Object.defineProperty(Mutation.prototype, "conflictDetectionStrategy", {
                        get: $util.oneOfGetter($oneOfFields = ["baseVersion"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new Mutation instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {google.datastore.v1.IMutation=} [properties] Properties to set
                     * @returns {google.datastore.v1.Mutation} Mutation instance
                     */
                    Mutation.create = function create(properties) {
                        return new Mutation(properties);
                    };
    
                    /**
                     * Encodes the specified Mutation message. Does not implicitly {@link google.datastore.v1.Mutation.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {google.datastore.v1.IMutation} message Mutation message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Mutation.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.insert != null && Object.hasOwnProperty.call(message, "insert"))
                            $root.google.datastore.v1.Entity.encode(message.insert, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.update != null && Object.hasOwnProperty.call(message, "update"))
                            $root.google.datastore.v1.Entity.encode(message.update, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.upsert != null && Object.hasOwnProperty.call(message, "upsert"))
                            $root.google.datastore.v1.Entity.encode(message.upsert, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message["delete"] != null && Object.hasOwnProperty.call(message, "delete"))
                            $root.google.datastore.v1.Key.encode(message["delete"], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                        if (message.baseVersion != null && Object.hasOwnProperty.call(message, "baseVersion"))
                            writer.uint32(/* id 8, wireType 0 =*/64).int64(message.baseVersion);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Mutation message, length delimited. Does not implicitly {@link google.datastore.v1.Mutation.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {google.datastore.v1.IMutation} message Mutation message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Mutation.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Mutation message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.Mutation} Mutation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Mutation.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Mutation();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 4:
                                message.insert = $root.google.datastore.v1.Entity.decode(reader, reader.uint32());
                                break;
                            case 5:
                                message.update = $root.google.datastore.v1.Entity.decode(reader, reader.uint32());
                                break;
                            case 6:
                                message.upsert = $root.google.datastore.v1.Entity.decode(reader, reader.uint32());
                                break;
                            case 7:
                                message["delete"] = $root.google.datastore.v1.Key.decode(reader, reader.uint32());
                                break;
                            case 8:
                                message.baseVersion = reader.int64();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Mutation message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.Mutation} Mutation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Mutation.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Mutation message.
                     * @function verify
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Mutation.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.insert != null && message.hasOwnProperty("insert")) {
                            properties.operation = 1;
                            {
                                var error = $root.google.datastore.v1.Entity.verify(message.insert);
                                if (error)
                                    return "insert." + error;
                            }
                        }
                        if (message.update != null && message.hasOwnProperty("update")) {
                            if (properties.operation === 1)
                                return "operation: multiple values";
                            properties.operation = 1;
                            {
                                var error = $root.google.datastore.v1.Entity.verify(message.update);
                                if (error)
                                    return "update." + error;
                            }
                        }
                        if (message.upsert != null && message.hasOwnProperty("upsert")) {
                            if (properties.operation === 1)
                                return "operation: multiple values";
                            properties.operation = 1;
                            {
                                var error = $root.google.datastore.v1.Entity.verify(message.upsert);
                                if (error)
                                    return "upsert." + error;
                            }
                        }
                        if (message["delete"] != null && message.hasOwnProperty("delete")) {
                            if (properties.operation === 1)
                                return "operation: multiple values";
                            properties.operation = 1;
                            {
                                var error = $root.google.datastore.v1.Key.verify(message["delete"]);
                                if (error)
                                    return "delete." + error;
                            }
                        }
                        if (message.baseVersion != null && message.hasOwnProperty("baseVersion")) {
                            properties.conflictDetectionStrategy = 1;
                            if (!$util.isInteger(message.baseVersion) && !(message.baseVersion && $util.isInteger(message.baseVersion.low) && $util.isInteger(message.baseVersion.high)))
                                return "baseVersion: integer|Long expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Mutation message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.Mutation} Mutation
                     */
                    Mutation.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.Mutation)
                            return object;
                        var message = new $root.google.datastore.v1.Mutation();
                        if (object.insert != null) {
                            if (typeof object.insert !== "object")
                                throw TypeError(".google.datastore.v1.Mutation.insert: object expected");
                            message.insert = $root.google.datastore.v1.Entity.fromObject(object.insert);
                        }
                        if (object.update != null) {
                            if (typeof object.update !== "object")
                                throw TypeError(".google.datastore.v1.Mutation.update: object expected");
                            message.update = $root.google.datastore.v1.Entity.fromObject(object.update);
                        }
                        if (object.upsert != null) {
                            if (typeof object.upsert !== "object")
                                throw TypeError(".google.datastore.v1.Mutation.upsert: object expected");
                            message.upsert = $root.google.datastore.v1.Entity.fromObject(object.upsert);
                        }
                        if (object["delete"] != null) {
                            if (typeof object["delete"] !== "object")
                                throw TypeError(".google.datastore.v1.Mutation.delete: object expected");
                            message["delete"] = $root.google.datastore.v1.Key.fromObject(object["delete"]);
                        }
                        if (object.baseVersion != null)
                            if ($util.Long)
                                (message.baseVersion = $util.Long.fromValue(object.baseVersion)).unsigned = false;
                            else if (typeof object.baseVersion === "string")
                                message.baseVersion = parseInt(object.baseVersion, 10);
                            else if (typeof object.baseVersion === "number")
                                message.baseVersion = object.baseVersion;
                            else if (typeof object.baseVersion === "object")
                                message.baseVersion = new $util.LongBits(object.baseVersion.low >>> 0, object.baseVersion.high >>> 0).toNumber();
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Mutation message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.Mutation
                     * @static
                     * @param {google.datastore.v1.Mutation} message Mutation
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Mutation.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (message.insert != null && message.hasOwnProperty("insert")) {
                            object.insert = $root.google.datastore.v1.Entity.toObject(message.insert, options);
                            if (options.oneofs)
                                object.operation = "insert";
                        }
                        if (message.update != null && message.hasOwnProperty("update")) {
                            object.update = $root.google.datastore.v1.Entity.toObject(message.update, options);
                            if (options.oneofs)
                                object.operation = "update";
                        }
                        if (message.upsert != null && message.hasOwnProperty("upsert")) {
                            object.upsert = $root.google.datastore.v1.Entity.toObject(message.upsert, options);
                            if (options.oneofs)
                                object.operation = "upsert";
                        }
                        if (message["delete"] != null && message.hasOwnProperty("delete")) {
                            object["delete"] = $root.google.datastore.v1.Key.toObject(message["delete"], options);
                            if (options.oneofs)
                                object.operation = "delete";
                        }
                        if (message.baseVersion != null && message.hasOwnProperty("baseVersion")) {
                            if (typeof message.baseVersion === "number")
                                object.baseVersion = options.longs === String ? String(message.baseVersion) : message.baseVersion;
                            else
                                object.baseVersion = options.longs === String ? $util.Long.prototype.toString.call(message.baseVersion) : options.longs === Number ? new $util.LongBits(message.baseVersion.low >>> 0, message.baseVersion.high >>> 0).toNumber() : message.baseVersion;
                            if (options.oneofs)
                                object.conflictDetectionStrategy = "baseVersion";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this Mutation to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.Mutation
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Mutation.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return Mutation;
                })();
    
                v1.MutationResult = (function() {
    
                    /**
                     * Properties of a MutationResult.
                     * @memberof google.datastore.v1
                     * @interface IMutationResult
                     * @property {google.datastore.v1.IKey|null} [key] MutationResult key
                     * @property {number|Long|null} [version] MutationResult version
                     * @property {boolean|null} [conflictDetected] MutationResult conflictDetected
                     */
    
                    /**
                     * Constructs a new MutationResult.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a MutationResult.
                     * @implements IMutationResult
                     * @constructor
                     * @param {google.datastore.v1.IMutationResult=} [properties] Properties to set
                     */
                    function MutationResult(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * MutationResult key.
                     * @member {google.datastore.v1.IKey|null|undefined} key
                     * @memberof google.datastore.v1.MutationResult
                     * @instance
                     */
                    MutationResult.prototype.key = null;
    
                    /**
                     * MutationResult version.
                     * @member {number|Long} version
                     * @memberof google.datastore.v1.MutationResult
                     * @instance
                     */
                    MutationResult.prototype.version = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * MutationResult conflictDetected.
                     * @member {boolean} conflictDetected
                     * @memberof google.datastore.v1.MutationResult
                     * @instance
                     */
                    MutationResult.prototype.conflictDetected = false;
    
                    /**
                     * Creates a new MutationResult instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {google.datastore.v1.IMutationResult=} [properties] Properties to set
                     * @returns {google.datastore.v1.MutationResult} MutationResult instance
                     */
                    MutationResult.create = function create(properties) {
                        return new MutationResult(properties);
                    };
    
                    /**
                     * Encodes the specified MutationResult message. Does not implicitly {@link google.datastore.v1.MutationResult.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {google.datastore.v1.IMutationResult} message MutationResult message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MutationResult.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                            $root.google.datastore.v1.Key.encode(message.key, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                            writer.uint32(/* id 4, wireType 0 =*/32).int64(message.version);
                        if (message.conflictDetected != null && Object.hasOwnProperty.call(message, "conflictDetected"))
                            writer.uint32(/* id 5, wireType 0 =*/40).bool(message.conflictDetected);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified MutationResult message, length delimited. Does not implicitly {@link google.datastore.v1.MutationResult.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {google.datastore.v1.IMutationResult} message MutationResult message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MutationResult.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a MutationResult message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.MutationResult} MutationResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MutationResult.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.MutationResult();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 3:
                                message.key = $root.google.datastore.v1.Key.decode(reader, reader.uint32());
                                break;
                            case 4:
                                message.version = reader.int64();
                                break;
                            case 5:
                                message.conflictDetected = reader.bool();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a MutationResult message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.MutationResult} MutationResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MutationResult.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a MutationResult message.
                     * @function verify
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    MutationResult.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.key != null && message.hasOwnProperty("key")) {
                            var error = $root.google.datastore.v1.Key.verify(message.key);
                            if (error)
                                return "key." + error;
                        }
                        if (message.version != null && message.hasOwnProperty("version"))
                            if (!$util.isInteger(message.version) && !(message.version && $util.isInteger(message.version.low) && $util.isInteger(message.version.high)))
                                return "version: integer|Long expected";
                        if (message.conflictDetected != null && message.hasOwnProperty("conflictDetected"))
                            if (typeof message.conflictDetected !== "boolean")
                                return "conflictDetected: boolean expected";
                        return null;
                    };
    
                    /**
                     * Creates a MutationResult message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.MutationResult} MutationResult
                     */
                    MutationResult.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.MutationResult)
                            return object;
                        var message = new $root.google.datastore.v1.MutationResult();
                        if (object.key != null) {
                            if (typeof object.key !== "object")
                                throw TypeError(".google.datastore.v1.MutationResult.key: object expected");
                            message.key = $root.google.datastore.v1.Key.fromObject(object.key);
                        }
                        if (object.version != null)
                            if ($util.Long)
                                (message.version = $util.Long.fromValue(object.version)).unsigned = false;
                            else if (typeof object.version === "string")
                                message.version = parseInt(object.version, 10);
                            else if (typeof object.version === "number")
                                message.version = object.version;
                            else if (typeof object.version === "object")
                                message.version = new $util.LongBits(object.version.low >>> 0, object.version.high >>> 0).toNumber();
                        if (object.conflictDetected != null)
                            message.conflictDetected = Boolean(object.conflictDetected);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a MutationResult message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.MutationResult
                     * @static
                     * @param {google.datastore.v1.MutationResult} message MutationResult
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    MutationResult.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.key = null;
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.version = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.version = options.longs === String ? "0" : 0;
                            object.conflictDetected = false;
                        }
                        if (message.key != null && message.hasOwnProperty("key"))
                            object.key = $root.google.datastore.v1.Key.toObject(message.key, options);
                        if (message.version != null && message.hasOwnProperty("version"))
                            if (typeof message.version === "number")
                                object.version = options.longs === String ? String(message.version) : message.version;
                            else
                                object.version = options.longs === String ? $util.Long.prototype.toString.call(message.version) : options.longs === Number ? new $util.LongBits(message.version.low >>> 0, message.version.high >>> 0).toNumber() : message.version;
                        if (message.conflictDetected != null && message.hasOwnProperty("conflictDetected"))
                            object.conflictDetected = message.conflictDetected;
                        return object;
                    };
    
                    /**
                     * Converts this MutationResult to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.MutationResult
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    MutationResult.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return MutationResult;
                })();
    
                v1.ReadOptions = (function() {
    
                    /**
                     * Properties of a ReadOptions.
                     * @memberof google.datastore.v1
                     * @interface IReadOptions
                     * @property {google.datastore.v1.ReadOptions.ReadConsistency|null} [readConsistency] ReadOptions readConsistency
                     * @property {Uint8Array|null} [transaction] ReadOptions transaction
                     */
    
                    /**
                     * Constructs a new ReadOptions.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a ReadOptions.
                     * @implements IReadOptions
                     * @constructor
                     * @param {google.datastore.v1.IReadOptions=} [properties] Properties to set
                     */
                    function ReadOptions(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ReadOptions readConsistency.
                     * @member {google.datastore.v1.ReadOptions.ReadConsistency} readConsistency
                     * @memberof google.datastore.v1.ReadOptions
                     * @instance
                     */
                    ReadOptions.prototype.readConsistency = 0;
    
                    /**
                     * ReadOptions transaction.
                     * @member {Uint8Array} transaction
                     * @memberof google.datastore.v1.ReadOptions
                     * @instance
                     */
                    ReadOptions.prototype.transaction = $util.newBuffer([]);
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * ReadOptions consistencyType.
                     * @member {"readConsistency"|"transaction"|undefined} consistencyType
                     * @memberof google.datastore.v1.ReadOptions
                     * @instance
                     */
                    Object.defineProperty(ReadOptions.prototype, "consistencyType", {
                        get: $util.oneOfGetter($oneOfFields = ["readConsistency", "transaction"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new ReadOptions instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {google.datastore.v1.IReadOptions=} [properties] Properties to set
                     * @returns {google.datastore.v1.ReadOptions} ReadOptions instance
                     */
                    ReadOptions.create = function create(properties) {
                        return new ReadOptions(properties);
                    };
    
                    /**
                     * Encodes the specified ReadOptions message. Does not implicitly {@link google.datastore.v1.ReadOptions.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {google.datastore.v1.IReadOptions} message ReadOptions message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReadOptions.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.readConsistency != null && Object.hasOwnProperty.call(message, "readConsistency"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.readConsistency);
                        if (message.transaction != null && Object.hasOwnProperty.call(message, "transaction"))
                            writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.transaction);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ReadOptions message, length delimited. Does not implicitly {@link google.datastore.v1.ReadOptions.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {google.datastore.v1.IReadOptions} message ReadOptions message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReadOptions.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ReadOptions message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.ReadOptions} ReadOptions
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReadOptions.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.ReadOptions();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.readConsistency = reader.int32();
                                break;
                            case 2:
                                message.transaction = reader.bytes();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ReadOptions message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.ReadOptions} ReadOptions
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReadOptions.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ReadOptions message.
                     * @function verify
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ReadOptions.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.readConsistency != null && message.hasOwnProperty("readConsistency")) {
                            properties.consistencyType = 1;
                            switch (message.readConsistency) {
                            default:
                                return "readConsistency: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        }
                        if (message.transaction != null && message.hasOwnProperty("transaction")) {
                            if (properties.consistencyType === 1)
                                return "consistencyType: multiple values";
                            properties.consistencyType = 1;
                            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
                                return "transaction: buffer expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a ReadOptions message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.ReadOptions} ReadOptions
                     */
                    ReadOptions.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.ReadOptions)
                            return object;
                        var message = new $root.google.datastore.v1.ReadOptions();
                        switch (object.readConsistency) {
                        case "READ_CONSISTENCY_UNSPECIFIED":
                        case 0:
                            message.readConsistency = 0;
                            break;
                        case "STRONG":
                        case 1:
                            message.readConsistency = 1;
                            break;
                        case "EVENTUAL":
                        case 2:
                            message.readConsistency = 2;
                            break;
                        }
                        if (object.transaction != null)
                            if (typeof object.transaction === "string")
                                $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
                            else if (object.transaction.length)
                                message.transaction = object.transaction;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ReadOptions message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.ReadOptions
                     * @static
                     * @param {google.datastore.v1.ReadOptions} message ReadOptions
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ReadOptions.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (message.readConsistency != null && message.hasOwnProperty("readConsistency")) {
                            object.readConsistency = options.enums === String ? $root.google.datastore.v1.ReadOptions.ReadConsistency[message.readConsistency] : message.readConsistency;
                            if (options.oneofs)
                                object.consistencyType = "readConsistency";
                        }
                        if (message.transaction != null && message.hasOwnProperty("transaction")) {
                            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
                            if (options.oneofs)
                                object.consistencyType = "transaction";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this ReadOptions to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.ReadOptions
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ReadOptions.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * ReadConsistency enum.
                     * @name google.datastore.v1.ReadOptions.ReadConsistency
                     * @enum {number}
                     * @property {number} READ_CONSISTENCY_UNSPECIFIED=0 READ_CONSISTENCY_UNSPECIFIED value
                     * @property {number} STRONG=1 STRONG value
                     * @property {number} EVENTUAL=2 EVENTUAL value
                     */
                    ReadOptions.ReadConsistency = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "READ_CONSISTENCY_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "STRONG"] = 1;
                        values[valuesById[2] = "EVENTUAL"] = 2;
                        return values;
                    })();
    
                    return ReadOptions;
                })();
    
                v1.TransactionOptions = (function() {
    
                    /**
                     * Properties of a TransactionOptions.
                     * @memberof google.datastore.v1
                     * @interface ITransactionOptions
                     * @property {google.datastore.v1.TransactionOptions.IReadWrite|null} [readWrite] TransactionOptions readWrite
                     * @property {google.datastore.v1.TransactionOptions.IReadOnly|null} [readOnly] TransactionOptions readOnly
                     */
    
                    /**
                     * Constructs a new TransactionOptions.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a TransactionOptions.
                     * @implements ITransactionOptions
                     * @constructor
                     * @param {google.datastore.v1.ITransactionOptions=} [properties] Properties to set
                     */
                    function TransactionOptions(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * TransactionOptions readWrite.
                     * @member {google.datastore.v1.TransactionOptions.IReadWrite|null|undefined} readWrite
                     * @memberof google.datastore.v1.TransactionOptions
                     * @instance
                     */
                    TransactionOptions.prototype.readWrite = null;
    
                    /**
                     * TransactionOptions readOnly.
                     * @member {google.datastore.v1.TransactionOptions.IReadOnly|null|undefined} readOnly
                     * @memberof google.datastore.v1.TransactionOptions
                     * @instance
                     */
                    TransactionOptions.prototype.readOnly = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * TransactionOptions mode.
                     * @member {"readWrite"|"readOnly"|undefined} mode
                     * @memberof google.datastore.v1.TransactionOptions
                     * @instance
                     */
                    Object.defineProperty(TransactionOptions.prototype, "mode", {
                        get: $util.oneOfGetter($oneOfFields = ["readWrite", "readOnly"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new TransactionOptions instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {google.datastore.v1.ITransactionOptions=} [properties] Properties to set
                     * @returns {google.datastore.v1.TransactionOptions} TransactionOptions instance
                     */
                    TransactionOptions.create = function create(properties) {
                        return new TransactionOptions(properties);
                    };
    
                    /**
                     * Encodes the specified TransactionOptions message. Does not implicitly {@link google.datastore.v1.TransactionOptions.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {google.datastore.v1.ITransactionOptions} message TransactionOptions message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TransactionOptions.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.readWrite != null && Object.hasOwnProperty.call(message, "readWrite"))
                            $root.google.datastore.v1.TransactionOptions.ReadWrite.encode(message.readWrite, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.readOnly != null && Object.hasOwnProperty.call(message, "readOnly"))
                            $root.google.datastore.v1.TransactionOptions.ReadOnly.encode(message.readOnly, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified TransactionOptions message, length delimited. Does not implicitly {@link google.datastore.v1.TransactionOptions.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {google.datastore.v1.ITransactionOptions} message TransactionOptions message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TransactionOptions.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a TransactionOptions message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.TransactionOptions} TransactionOptions
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TransactionOptions.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.TransactionOptions();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.readWrite = $root.google.datastore.v1.TransactionOptions.ReadWrite.decode(reader, reader.uint32());
                                break;
                            case 2:
                                message.readOnly = $root.google.datastore.v1.TransactionOptions.ReadOnly.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a TransactionOptions message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.TransactionOptions} TransactionOptions
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TransactionOptions.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a TransactionOptions message.
                     * @function verify
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TransactionOptions.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.readWrite != null && message.hasOwnProperty("readWrite")) {
                            properties.mode = 1;
                            {
                                var error = $root.google.datastore.v1.TransactionOptions.ReadWrite.verify(message.readWrite);
                                if (error)
                                    return "readWrite." + error;
                            }
                        }
                        if (message.readOnly != null && message.hasOwnProperty("readOnly")) {
                            if (properties.mode === 1)
                                return "mode: multiple values";
                            properties.mode = 1;
                            {
                                var error = $root.google.datastore.v1.TransactionOptions.ReadOnly.verify(message.readOnly);
                                if (error)
                                    return "readOnly." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a TransactionOptions message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.TransactionOptions} TransactionOptions
                     */
                    TransactionOptions.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.TransactionOptions)
                            return object;
                        var message = new $root.google.datastore.v1.TransactionOptions();
                        if (object.readWrite != null) {
                            if (typeof object.readWrite !== "object")
                                throw TypeError(".google.datastore.v1.TransactionOptions.readWrite: object expected");
                            message.readWrite = $root.google.datastore.v1.TransactionOptions.ReadWrite.fromObject(object.readWrite);
                        }
                        if (object.readOnly != null) {
                            if (typeof object.readOnly !== "object")
                                throw TypeError(".google.datastore.v1.TransactionOptions.readOnly: object expected");
                            message.readOnly = $root.google.datastore.v1.TransactionOptions.ReadOnly.fromObject(object.readOnly);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a TransactionOptions message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.TransactionOptions
                     * @static
                     * @param {google.datastore.v1.TransactionOptions} message TransactionOptions
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TransactionOptions.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (message.readWrite != null && message.hasOwnProperty("readWrite")) {
                            object.readWrite = $root.google.datastore.v1.TransactionOptions.ReadWrite.toObject(message.readWrite, options);
                            if (options.oneofs)
                                object.mode = "readWrite";
                        }
                        if (message.readOnly != null && message.hasOwnProperty("readOnly")) {
                            object.readOnly = $root.google.datastore.v1.TransactionOptions.ReadOnly.toObject(message.readOnly, options);
                            if (options.oneofs)
                                object.mode = "readOnly";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this TransactionOptions to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.TransactionOptions
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TransactionOptions.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    TransactionOptions.ReadWrite = (function() {
    
                        /**
                         * Properties of a ReadWrite.
                         * @memberof google.datastore.v1.TransactionOptions
                         * @interface IReadWrite
                         * @property {Uint8Array|null} [previousTransaction] ReadWrite previousTransaction
                         */
    
                        /**
                         * Constructs a new ReadWrite.
                         * @memberof google.datastore.v1.TransactionOptions
                         * @classdesc Represents a ReadWrite.
                         * @implements IReadWrite
                         * @constructor
                         * @param {google.datastore.v1.TransactionOptions.IReadWrite=} [properties] Properties to set
                         */
                        function ReadWrite(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ReadWrite previousTransaction.
                         * @member {Uint8Array} previousTransaction
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @instance
                         */
                        ReadWrite.prototype.previousTransaction = $util.newBuffer([]);
    
                        /**
                         * Creates a new ReadWrite instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.IReadWrite=} [properties] Properties to set
                         * @returns {google.datastore.v1.TransactionOptions.ReadWrite} ReadWrite instance
                         */
                        ReadWrite.create = function create(properties) {
                            return new ReadWrite(properties);
                        };
    
                        /**
                         * Encodes the specified ReadWrite message. Does not implicitly {@link google.datastore.v1.TransactionOptions.ReadWrite.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.IReadWrite} message ReadWrite message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReadWrite.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.previousTransaction != null && Object.hasOwnProperty.call(message, "previousTransaction"))
                                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.previousTransaction);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReadWrite message, length delimited. Does not implicitly {@link google.datastore.v1.TransactionOptions.ReadWrite.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.IReadWrite} message ReadWrite message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReadWrite.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReadWrite message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.v1.TransactionOptions.ReadWrite} ReadWrite
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReadWrite.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.TransactionOptions.ReadWrite();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.previousTransaction = reader.bytes();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReadWrite message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.v1.TransactionOptions.ReadWrite} ReadWrite
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReadWrite.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReadWrite message.
                         * @function verify
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReadWrite.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.previousTransaction != null && message.hasOwnProperty("previousTransaction"))
                                if (!(message.previousTransaction && typeof message.previousTransaction.length === "number" || $util.isString(message.previousTransaction)))
                                    return "previousTransaction: buffer expected";
                            return null;
                        };
    
                        /**
                         * Creates a ReadWrite message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.v1.TransactionOptions.ReadWrite} ReadWrite
                         */
                        ReadWrite.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.v1.TransactionOptions.ReadWrite)
                                return object;
                            var message = new $root.google.datastore.v1.TransactionOptions.ReadWrite();
                            if (object.previousTransaction != null)
                                if (typeof object.previousTransaction === "string")
                                    $util.base64.decode(object.previousTransaction, message.previousTransaction = $util.newBuffer($util.base64.length(object.previousTransaction)), 0);
                                else if (object.previousTransaction.length)
                                    message.previousTransaction = object.previousTransaction;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ReadWrite message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.ReadWrite} message ReadWrite
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReadWrite.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                if (options.bytes === String)
                                    object.previousTransaction = "";
                                else {
                                    object.previousTransaction = [];
                                    if (options.bytes !== Array)
                                        object.previousTransaction = $util.newBuffer(object.previousTransaction);
                                }
                            if (message.previousTransaction != null && message.hasOwnProperty("previousTransaction"))
                                object.previousTransaction = options.bytes === String ? $util.base64.encode(message.previousTransaction, 0, message.previousTransaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.previousTransaction) : message.previousTransaction;
                            return object;
                        };
    
                        /**
                         * Converts this ReadWrite to JSON.
                         * @function toJSON
                         * @memberof google.datastore.v1.TransactionOptions.ReadWrite
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReadWrite.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ReadWrite;
                    })();
    
                    TransactionOptions.ReadOnly = (function() {
    
                        /**
                         * Properties of a ReadOnly.
                         * @memberof google.datastore.v1.TransactionOptions
                         * @interface IReadOnly
                         */
    
                        /**
                         * Constructs a new ReadOnly.
                         * @memberof google.datastore.v1.TransactionOptions
                         * @classdesc Represents a ReadOnly.
                         * @implements IReadOnly
                         * @constructor
                         * @param {google.datastore.v1.TransactionOptions.IReadOnly=} [properties] Properties to set
                         */
                        function ReadOnly(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new ReadOnly instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.IReadOnly=} [properties] Properties to set
                         * @returns {google.datastore.v1.TransactionOptions.ReadOnly} ReadOnly instance
                         */
                        ReadOnly.create = function create(properties) {
                            return new ReadOnly(properties);
                        };
    
                        /**
                         * Encodes the specified ReadOnly message. Does not implicitly {@link google.datastore.v1.TransactionOptions.ReadOnly.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.IReadOnly} message ReadOnly message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReadOnly.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReadOnly message, length delimited. Does not implicitly {@link google.datastore.v1.TransactionOptions.ReadOnly.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.IReadOnly} message ReadOnly message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReadOnly.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReadOnly message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.v1.TransactionOptions.ReadOnly} ReadOnly
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReadOnly.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.TransactionOptions.ReadOnly();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReadOnly message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.v1.TransactionOptions.ReadOnly} ReadOnly
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReadOnly.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReadOnly message.
                         * @function verify
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReadOnly.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a ReadOnly message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.v1.TransactionOptions.ReadOnly} ReadOnly
                         */
                        ReadOnly.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.v1.TransactionOptions.ReadOnly)
                                return object;
                            return new $root.google.datastore.v1.TransactionOptions.ReadOnly();
                        };
    
                        /**
                         * Creates a plain object from a ReadOnly message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @static
                         * @param {google.datastore.v1.TransactionOptions.ReadOnly} message ReadOnly
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReadOnly.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this ReadOnly to JSON.
                         * @function toJSON
                         * @memberof google.datastore.v1.TransactionOptions.ReadOnly
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReadOnly.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ReadOnly;
                    })();
    
                    return TransactionOptions;
                })();
    
                v1.PartitionId = (function() {
    
                    /**
                     * Properties of a PartitionId.
                     * @memberof google.datastore.v1
                     * @interface IPartitionId
                     * @property {string|null} [projectId] PartitionId projectId
                     * @property {string|null} [namespaceId] PartitionId namespaceId
                     */
    
                    /**
                     * Constructs a new PartitionId.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a PartitionId.
                     * @implements IPartitionId
                     * @constructor
                     * @param {google.datastore.v1.IPartitionId=} [properties] Properties to set
                     */
                    function PartitionId(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PartitionId projectId.
                     * @member {string} projectId
                     * @memberof google.datastore.v1.PartitionId
                     * @instance
                     */
                    PartitionId.prototype.projectId = "";
    
                    /**
                     * PartitionId namespaceId.
                     * @member {string} namespaceId
                     * @memberof google.datastore.v1.PartitionId
                     * @instance
                     */
                    PartitionId.prototype.namespaceId = "";
    
                    /**
                     * Creates a new PartitionId instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {google.datastore.v1.IPartitionId=} [properties] Properties to set
                     * @returns {google.datastore.v1.PartitionId} PartitionId instance
                     */
                    PartitionId.create = function create(properties) {
                        return new PartitionId(properties);
                    };
    
                    /**
                     * Encodes the specified PartitionId message. Does not implicitly {@link google.datastore.v1.PartitionId.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {google.datastore.v1.IPartitionId} message PartitionId message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PartitionId.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.projectId != null && Object.hasOwnProperty.call(message, "projectId"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.projectId);
                        if (message.namespaceId != null && Object.hasOwnProperty.call(message, "namespaceId"))
                            writer.uint32(/* id 4, wireType 2 =*/34).string(message.namespaceId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PartitionId message, length delimited. Does not implicitly {@link google.datastore.v1.PartitionId.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {google.datastore.v1.IPartitionId} message PartitionId message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PartitionId.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PartitionId message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.PartitionId} PartitionId
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PartitionId.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.PartitionId();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 2:
                                message.projectId = reader.string();
                                break;
                            case 4:
                                message.namespaceId = reader.string();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PartitionId message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.PartitionId} PartitionId
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PartitionId.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PartitionId message.
                     * @function verify
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PartitionId.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            if (!$util.isString(message.projectId))
                                return "projectId: string expected";
                        if (message.namespaceId != null && message.hasOwnProperty("namespaceId"))
                            if (!$util.isString(message.namespaceId))
                                return "namespaceId: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a PartitionId message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.PartitionId} PartitionId
                     */
                    PartitionId.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.PartitionId)
                            return object;
                        var message = new $root.google.datastore.v1.PartitionId();
                        if (object.projectId != null)
                            message.projectId = String(object.projectId);
                        if (object.namespaceId != null)
                            message.namespaceId = String(object.namespaceId);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PartitionId message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.PartitionId
                     * @static
                     * @param {google.datastore.v1.PartitionId} message PartitionId
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PartitionId.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.projectId = "";
                            object.namespaceId = "";
                        }
                        if (message.projectId != null && message.hasOwnProperty("projectId"))
                            object.projectId = message.projectId;
                        if (message.namespaceId != null && message.hasOwnProperty("namespaceId"))
                            object.namespaceId = message.namespaceId;
                        return object;
                    };
    
                    /**
                     * Converts this PartitionId to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.PartitionId
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PartitionId.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return PartitionId;
                })();
    
                v1.Key = (function() {
    
                    /**
                     * Properties of a Key.
                     * @memberof google.datastore.v1
                     * @interface IKey
                     * @property {google.datastore.v1.IPartitionId|null} [partitionId] Key partitionId
                     * @property {Array.<google.datastore.v1.Key.IPathElement>|null} [path] Key path
                     */
    
                    /**
                     * Constructs a new Key.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a Key.
                     * @implements IKey
                     * @constructor
                     * @param {google.datastore.v1.IKey=} [properties] Properties to set
                     */
                    function Key(properties) {
                        this.path = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Key partitionId.
                     * @member {google.datastore.v1.IPartitionId|null|undefined} partitionId
                     * @memberof google.datastore.v1.Key
                     * @instance
                     */
                    Key.prototype.partitionId = null;
    
                    /**
                     * Key path.
                     * @member {Array.<google.datastore.v1.Key.IPathElement>} path
                     * @memberof google.datastore.v1.Key
                     * @instance
                     */
                    Key.prototype.path = $util.emptyArray;
    
                    /**
                     * Creates a new Key instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {google.datastore.v1.IKey=} [properties] Properties to set
                     * @returns {google.datastore.v1.Key} Key instance
                     */
                    Key.create = function create(properties) {
                        return new Key(properties);
                    };
    
                    /**
                     * Encodes the specified Key message. Does not implicitly {@link google.datastore.v1.Key.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {google.datastore.v1.IKey} message Key message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Key.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.partitionId != null && Object.hasOwnProperty.call(message, "partitionId"))
                            $root.google.datastore.v1.PartitionId.encode(message.partitionId, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.path != null && message.path.length)
                            for (var i = 0; i < message.path.length; ++i)
                                $root.google.datastore.v1.Key.PathElement.encode(message.path[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Key message, length delimited. Does not implicitly {@link google.datastore.v1.Key.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {google.datastore.v1.IKey} message Key message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Key.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Key message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.Key} Key
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Key.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Key();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.partitionId = $root.google.datastore.v1.PartitionId.decode(reader, reader.uint32());
                                break;
                            case 2:
                                if (!(message.path && message.path.length))
                                    message.path = [];
                                message.path.push($root.google.datastore.v1.Key.PathElement.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Key message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.Key} Key
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Key.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Key message.
                     * @function verify
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Key.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.partitionId != null && message.hasOwnProperty("partitionId")) {
                            var error = $root.google.datastore.v1.PartitionId.verify(message.partitionId);
                            if (error)
                                return "partitionId." + error;
                        }
                        if (message.path != null && message.hasOwnProperty("path")) {
                            if (!Array.isArray(message.path))
                                return "path: array expected";
                            for (var i = 0; i < message.path.length; ++i) {
                                var error = $root.google.datastore.v1.Key.PathElement.verify(message.path[i]);
                                if (error)
                                    return "path." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Key message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.Key} Key
                     */
                    Key.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.Key)
                            return object;
                        var message = new $root.google.datastore.v1.Key();
                        if (object.partitionId != null) {
                            if (typeof object.partitionId !== "object")
                                throw TypeError(".google.datastore.v1.Key.partitionId: object expected");
                            message.partitionId = $root.google.datastore.v1.PartitionId.fromObject(object.partitionId);
                        }
                        if (object.path) {
                            if (!Array.isArray(object.path))
                                throw TypeError(".google.datastore.v1.Key.path: array expected");
                            message.path = [];
                            for (var i = 0; i < object.path.length; ++i) {
                                if (typeof object.path[i] !== "object")
                                    throw TypeError(".google.datastore.v1.Key.path: object expected");
                                message.path[i] = $root.google.datastore.v1.Key.PathElement.fromObject(object.path[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Key message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.Key
                     * @static
                     * @param {google.datastore.v1.Key} message Key
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Key.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.path = [];
                        if (options.defaults)
                            object.partitionId = null;
                        if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                            object.partitionId = $root.google.datastore.v1.PartitionId.toObject(message.partitionId, options);
                        if (message.path && message.path.length) {
                            object.path = [];
                            for (var j = 0; j < message.path.length; ++j)
                                object.path[j] = $root.google.datastore.v1.Key.PathElement.toObject(message.path[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this Key to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.Key
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Key.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    Key.PathElement = (function() {
    
                        /**
                         * Properties of a PathElement.
                         * @memberof google.datastore.v1.Key
                         * @interface IPathElement
                         * @property {string|null} [kind] PathElement kind
                         * @property {number|Long|null} [id] PathElement id
                         * @property {string|null} [name] PathElement name
                         */
    
                        /**
                         * Constructs a new PathElement.
                         * @memberof google.datastore.v1.Key
                         * @classdesc Represents a PathElement.
                         * @implements IPathElement
                         * @constructor
                         * @param {google.datastore.v1.Key.IPathElement=} [properties] Properties to set
                         */
                        function PathElement(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * PathElement kind.
                         * @member {string} kind
                         * @memberof google.datastore.v1.Key.PathElement
                         * @instance
                         */
                        PathElement.prototype.kind = "";
    
                        /**
                         * PathElement id.
                         * @member {number|Long} id
                         * @memberof google.datastore.v1.Key.PathElement
                         * @instance
                         */
                        PathElement.prototype.id = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * PathElement name.
                         * @member {string} name
                         * @memberof google.datastore.v1.Key.PathElement
                         * @instance
                         */
                        PathElement.prototype.name = "";
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * PathElement idType.
                         * @member {"id"|"name"|undefined} idType
                         * @memberof google.datastore.v1.Key.PathElement
                         * @instance
                         */
                        Object.defineProperty(PathElement.prototype, "idType", {
                            get: $util.oneOfGetter($oneOfFields = ["id", "name"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new PathElement instance using the specified properties.
                         * @function create
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {google.datastore.v1.Key.IPathElement=} [properties] Properties to set
                         * @returns {google.datastore.v1.Key.PathElement} PathElement instance
                         */
                        PathElement.create = function create(properties) {
                            return new PathElement(properties);
                        };
    
                        /**
                         * Encodes the specified PathElement message. Does not implicitly {@link google.datastore.v1.Key.PathElement.verify|verify} messages.
                         * @function encode
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {google.datastore.v1.Key.IPathElement} message PathElement message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PathElement.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.kind);
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.id);
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified PathElement message, length delimited. Does not implicitly {@link google.datastore.v1.Key.PathElement.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {google.datastore.v1.Key.IPathElement} message PathElement message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PathElement.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a PathElement message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.datastore.v1.Key.PathElement} PathElement
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PathElement.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Key.PathElement();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.kind = reader.string();
                                    break;
                                case 2:
                                    message.id = reader.int64();
                                    break;
                                case 3:
                                    message.name = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a PathElement message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.datastore.v1.Key.PathElement} PathElement
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PathElement.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a PathElement message.
                         * @function verify
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        PathElement.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.kind != null && message.hasOwnProperty("kind"))
                                if (!$util.isString(message.kind))
                                    return "kind: string expected";
                            if (message.id != null && message.hasOwnProperty("id")) {
                                properties.idType = 1;
                                if (!$util.isInteger(message.id) && !(message.id && $util.isInteger(message.id.low) && $util.isInteger(message.id.high)))
                                    return "id: integer|Long expected";
                            }
                            if (message.name != null && message.hasOwnProperty("name")) {
                                if (properties.idType === 1)
                                    return "idType: multiple values";
                                properties.idType = 1;
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a PathElement message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.datastore.v1.Key.PathElement} PathElement
                         */
                        PathElement.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.datastore.v1.Key.PathElement)
                                return object;
                            var message = new $root.google.datastore.v1.Key.PathElement();
                            if (object.kind != null)
                                message.kind = String(object.kind);
                            if (object.id != null)
                                if ($util.Long)
                                    (message.id = $util.Long.fromValue(object.id)).unsigned = false;
                                else if (typeof object.id === "string")
                                    message.id = parseInt(object.id, 10);
                                else if (typeof object.id === "number")
                                    message.id = object.id;
                                else if (typeof object.id === "object")
                                    message.id = new $util.LongBits(object.id.low >>> 0, object.id.high >>> 0).toNumber();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a PathElement message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.datastore.v1.Key.PathElement
                         * @static
                         * @param {google.datastore.v1.Key.PathElement} message PathElement
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        PathElement.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.kind = "";
                            if (message.kind != null && message.hasOwnProperty("kind"))
                                object.kind = message.kind;
                            if (message.id != null && message.hasOwnProperty("id")) {
                                if (typeof message.id === "number")
                                    object.id = options.longs === String ? String(message.id) : message.id;
                                else
                                    object.id = options.longs === String ? $util.Long.prototype.toString.call(message.id) : options.longs === Number ? new $util.LongBits(message.id.low >>> 0, message.id.high >>> 0).toNumber() : message.id;
                                if (options.oneofs)
                                    object.idType = "id";
                            }
                            if (message.name != null && message.hasOwnProperty("name")) {
                                object.name = message.name;
                                if (options.oneofs)
                                    object.idType = "name";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this PathElement to JSON.
                         * @function toJSON
                         * @memberof google.datastore.v1.Key.PathElement
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        PathElement.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return PathElement;
                    })();
    
                    return Key;
                })();
    
                v1.ArrayValue = (function() {
    
                    /**
                     * Properties of an ArrayValue.
                     * @memberof google.datastore.v1
                     * @interface IArrayValue
                     * @property {Array.<google.datastore.v1.IValue>|null} [values] ArrayValue values
                     */
    
                    /**
                     * Constructs a new ArrayValue.
                     * @memberof google.datastore.v1
                     * @classdesc Represents an ArrayValue.
                     * @implements IArrayValue
                     * @constructor
                     * @param {google.datastore.v1.IArrayValue=} [properties] Properties to set
                     */
                    function ArrayValue(properties) {
                        this.values = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ArrayValue values.
                     * @member {Array.<google.datastore.v1.IValue>} values
                     * @memberof google.datastore.v1.ArrayValue
                     * @instance
                     */
                    ArrayValue.prototype.values = $util.emptyArray;
    
                    /**
                     * Creates a new ArrayValue instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {google.datastore.v1.IArrayValue=} [properties] Properties to set
                     * @returns {google.datastore.v1.ArrayValue} ArrayValue instance
                     */
                    ArrayValue.create = function create(properties) {
                        return new ArrayValue(properties);
                    };
    
                    /**
                     * Encodes the specified ArrayValue message. Does not implicitly {@link google.datastore.v1.ArrayValue.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {google.datastore.v1.IArrayValue} message ArrayValue message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ArrayValue.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.values != null && message.values.length)
                            for (var i = 0; i < message.values.length; ++i)
                                $root.google.datastore.v1.Value.encode(message.values[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ArrayValue message, length delimited. Does not implicitly {@link google.datastore.v1.ArrayValue.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {google.datastore.v1.IArrayValue} message ArrayValue message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ArrayValue.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an ArrayValue message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.ArrayValue} ArrayValue
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ArrayValue.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.ArrayValue();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                if (!(message.values && message.values.length))
                                    message.values = [];
                                message.values.push($root.google.datastore.v1.Value.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an ArrayValue message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.ArrayValue} ArrayValue
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ArrayValue.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an ArrayValue message.
                     * @function verify
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ArrayValue.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.values != null && message.hasOwnProperty("values")) {
                            if (!Array.isArray(message.values))
                                return "values: array expected";
                            for (var i = 0; i < message.values.length; ++i) {
                                var error = $root.google.datastore.v1.Value.verify(message.values[i]);
                                if (error)
                                    return "values." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates an ArrayValue message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.ArrayValue} ArrayValue
                     */
                    ArrayValue.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.ArrayValue)
                            return object;
                        var message = new $root.google.datastore.v1.ArrayValue();
                        if (object.values) {
                            if (!Array.isArray(object.values))
                                throw TypeError(".google.datastore.v1.ArrayValue.values: array expected");
                            message.values = [];
                            for (var i = 0; i < object.values.length; ++i) {
                                if (typeof object.values[i] !== "object")
                                    throw TypeError(".google.datastore.v1.ArrayValue.values: object expected");
                                message.values[i] = $root.google.datastore.v1.Value.fromObject(object.values[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an ArrayValue message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.ArrayValue
                     * @static
                     * @param {google.datastore.v1.ArrayValue} message ArrayValue
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ArrayValue.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.values = [];
                        if (message.values && message.values.length) {
                            object.values = [];
                            for (var j = 0; j < message.values.length; ++j)
                                object.values[j] = $root.google.datastore.v1.Value.toObject(message.values[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this ArrayValue to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.ArrayValue
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ArrayValue.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return ArrayValue;
                })();
    
                v1.Value = (function() {
    
                    /**
                     * Properties of a Value.
                     * @memberof google.datastore.v1
                     * @interface IValue
                     * @property {google.protobuf.NullValue|null} [nullValue] Value nullValue
                     * @property {boolean|null} [booleanValue] Value booleanValue
                     * @property {number|Long|null} [integerValue] Value integerValue
                     * @property {number|null} [doubleValue] Value doubleValue
                     * @property {google.protobuf.ITimestamp|null} [timestampValue] Value timestampValue
                     * @property {google.datastore.v1.IKey|null} [keyValue] Value keyValue
                     * @property {string|null} [stringValue] Value stringValue
                     * @property {Uint8Array|null} [blobValue] Value blobValue
                     * @property {google.type.ILatLng|null} [geoPointValue] Value geoPointValue
                     * @property {google.datastore.v1.IEntity|null} [entityValue] Value entityValue
                     * @property {google.datastore.v1.IArrayValue|null} [arrayValue] Value arrayValue
                     * @property {number|null} [meaning] Value meaning
                     * @property {boolean|null} [excludeFromIndexes] Value excludeFromIndexes
                     */
    
                    /**
                     * Constructs a new Value.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a Value.
                     * @implements IValue
                     * @constructor
                     * @param {google.datastore.v1.IValue=} [properties] Properties to set
                     */
                    function Value(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Value nullValue.
                     * @member {google.protobuf.NullValue} nullValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.nullValue = 0;
    
                    /**
                     * Value booleanValue.
                     * @member {boolean} booleanValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.booleanValue = false;
    
                    /**
                     * Value integerValue.
                     * @member {number|Long} integerValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.integerValue = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * Value doubleValue.
                     * @member {number} doubleValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.doubleValue = 0;
    
                    /**
                     * Value timestampValue.
                     * @member {google.protobuf.ITimestamp|null|undefined} timestampValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.timestampValue = null;
    
                    /**
                     * Value keyValue.
                     * @member {google.datastore.v1.IKey|null|undefined} keyValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.keyValue = null;
    
                    /**
                     * Value stringValue.
                     * @member {string} stringValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.stringValue = "";
    
                    /**
                     * Value blobValue.
                     * @member {Uint8Array} blobValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.blobValue = $util.newBuffer([]);
    
                    /**
                     * Value geoPointValue.
                     * @member {google.type.ILatLng|null|undefined} geoPointValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.geoPointValue = null;
    
                    /**
                     * Value entityValue.
                     * @member {google.datastore.v1.IEntity|null|undefined} entityValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.entityValue = null;
    
                    /**
                     * Value arrayValue.
                     * @member {google.datastore.v1.IArrayValue|null|undefined} arrayValue
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.arrayValue = null;
    
                    /**
                     * Value meaning.
                     * @member {number} meaning
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.meaning = 0;
    
                    /**
                     * Value excludeFromIndexes.
                     * @member {boolean} excludeFromIndexes
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Value.prototype.excludeFromIndexes = false;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * Value valueType.
                     * @member {"nullValue"|"booleanValue"|"integerValue"|"doubleValue"|"timestampValue"|"keyValue"|"stringValue"|"blobValue"|"geoPointValue"|"entityValue"|"arrayValue"|undefined} valueType
                     * @memberof google.datastore.v1.Value
                     * @instance
                     */
                    Object.defineProperty(Value.prototype, "valueType", {
                        get: $util.oneOfGetter($oneOfFields = ["nullValue", "booleanValue", "integerValue", "doubleValue", "timestampValue", "keyValue", "stringValue", "blobValue", "geoPointValue", "entityValue", "arrayValue"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new Value instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {google.datastore.v1.IValue=} [properties] Properties to set
                     * @returns {google.datastore.v1.Value} Value instance
                     */
                    Value.create = function create(properties) {
                        return new Value(properties);
                    };
    
                    /**
                     * Encodes the specified Value message. Does not implicitly {@link google.datastore.v1.Value.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {google.datastore.v1.IValue} message Value message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Value.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.booleanValue != null && Object.hasOwnProperty.call(message, "booleanValue"))
                            writer.uint32(/* id 1, wireType 0 =*/8).bool(message.booleanValue);
                        if (message.integerValue != null && Object.hasOwnProperty.call(message, "integerValue"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int64(message.integerValue);
                        if (message.doubleValue != null && Object.hasOwnProperty.call(message, "doubleValue"))
                            writer.uint32(/* id 3, wireType 1 =*/25).double(message.doubleValue);
                        if (message.keyValue != null && Object.hasOwnProperty.call(message, "keyValue"))
                            $root.google.datastore.v1.Key.encode(message.keyValue, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.entityValue != null && Object.hasOwnProperty.call(message, "entityValue"))
                            $root.google.datastore.v1.Entity.encode(message.entityValue, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.geoPointValue != null && Object.hasOwnProperty.call(message, "geoPointValue"))
                            $root.google.type.LatLng.encode(message.geoPointValue, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                        if (message.arrayValue != null && Object.hasOwnProperty.call(message, "arrayValue"))
                            $root.google.datastore.v1.ArrayValue.encode(message.arrayValue, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                        if (message.timestampValue != null && Object.hasOwnProperty.call(message, "timestampValue"))
                            $root.google.protobuf.Timestamp.encode(message.timestampValue, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                        if (message.nullValue != null && Object.hasOwnProperty.call(message, "nullValue"))
                            writer.uint32(/* id 11, wireType 0 =*/88).int32(message.nullValue);
                        if (message.meaning != null && Object.hasOwnProperty.call(message, "meaning"))
                            writer.uint32(/* id 14, wireType 0 =*/112).int32(message.meaning);
                        if (message.stringValue != null && Object.hasOwnProperty.call(message, "stringValue"))
                            writer.uint32(/* id 17, wireType 2 =*/138).string(message.stringValue);
                        if (message.blobValue != null && Object.hasOwnProperty.call(message, "blobValue"))
                            writer.uint32(/* id 18, wireType 2 =*/146).bytes(message.blobValue);
                        if (message.excludeFromIndexes != null && Object.hasOwnProperty.call(message, "excludeFromIndexes"))
                            writer.uint32(/* id 19, wireType 0 =*/152).bool(message.excludeFromIndexes);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Value message, length delimited. Does not implicitly {@link google.datastore.v1.Value.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {google.datastore.v1.IValue} message Value message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Value.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Value message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.Value} Value
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Value.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Value();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 11:
                                message.nullValue = reader.int32();
                                break;
                            case 1:
                                message.booleanValue = reader.bool();
                                break;
                            case 2:
                                message.integerValue = reader.int64();
                                break;
                            case 3:
                                message.doubleValue = reader.double();
                                break;
                            case 10:
                                message.timestampValue = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                break;
                            case 5:
                                message.keyValue = $root.google.datastore.v1.Key.decode(reader, reader.uint32());
                                break;
                            case 17:
                                message.stringValue = reader.string();
                                break;
                            case 18:
                                message.blobValue = reader.bytes();
                                break;
                            case 8:
                                message.geoPointValue = $root.google.type.LatLng.decode(reader, reader.uint32());
                                break;
                            case 6:
                                message.entityValue = $root.google.datastore.v1.Entity.decode(reader, reader.uint32());
                                break;
                            case 9:
                                message.arrayValue = $root.google.datastore.v1.ArrayValue.decode(reader, reader.uint32());
                                break;
                            case 14:
                                message.meaning = reader.int32();
                                break;
                            case 19:
                                message.excludeFromIndexes = reader.bool();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Value message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.Value} Value
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Value.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Value message.
                     * @function verify
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Value.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.nullValue != null && message.hasOwnProperty("nullValue")) {
                            properties.valueType = 1;
                            switch (message.nullValue) {
                            default:
                                return "nullValue: enum value expected";
                            case 0:
                                break;
                            }
                        }
                        if (message.booleanValue != null && message.hasOwnProperty("booleanValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            if (typeof message.booleanValue !== "boolean")
                                return "booleanValue: boolean expected";
                        }
                        if (message.integerValue != null && message.hasOwnProperty("integerValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            if (!$util.isInteger(message.integerValue) && !(message.integerValue && $util.isInteger(message.integerValue.low) && $util.isInteger(message.integerValue.high)))
                                return "integerValue: integer|Long expected";
                        }
                        if (message.doubleValue != null && message.hasOwnProperty("doubleValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            if (typeof message.doubleValue !== "number")
                                return "doubleValue: number expected";
                        }
                        if (message.timestampValue != null && message.hasOwnProperty("timestampValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            {
                                var error = $root.google.protobuf.Timestamp.verify(message.timestampValue);
                                if (error)
                                    return "timestampValue." + error;
                            }
                        }
                        if (message.keyValue != null && message.hasOwnProperty("keyValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            {
                                var error = $root.google.datastore.v1.Key.verify(message.keyValue);
                                if (error)
                                    return "keyValue." + error;
                            }
                        }
                        if (message.stringValue != null && message.hasOwnProperty("stringValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            if (!$util.isString(message.stringValue))
                                return "stringValue: string expected";
                        }
                        if (message.blobValue != null && message.hasOwnProperty("blobValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            if (!(message.blobValue && typeof message.blobValue.length === "number" || $util.isString(message.blobValue)))
                                return "blobValue: buffer expected";
                        }
                        if (message.geoPointValue != null && message.hasOwnProperty("geoPointValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            {
                                var error = $root.google.type.LatLng.verify(message.geoPointValue);
                                if (error)
                                    return "geoPointValue." + error;
                            }
                        }
                        if (message.entityValue != null && message.hasOwnProperty("entityValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            {
                                var error = $root.google.datastore.v1.Entity.verify(message.entityValue);
                                if (error)
                                    return "entityValue." + error;
                            }
                        }
                        if (message.arrayValue != null && message.hasOwnProperty("arrayValue")) {
                            if (properties.valueType === 1)
                                return "valueType: multiple values";
                            properties.valueType = 1;
                            {
                                var error = $root.google.datastore.v1.ArrayValue.verify(message.arrayValue);
                                if (error)
                                    return "arrayValue." + error;
                            }
                        }
                        if (message.meaning != null && message.hasOwnProperty("meaning"))
                            if (!$util.isInteger(message.meaning))
                                return "meaning: integer expected";
                        if (message.excludeFromIndexes != null && message.hasOwnProperty("excludeFromIndexes"))
                            if (typeof message.excludeFromIndexes !== "boolean")
                                return "excludeFromIndexes: boolean expected";
                        return null;
                    };
    
                    /**
                     * Creates a Value message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.Value} Value
                     */
                    Value.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.Value)
                            return object;
                        var message = new $root.google.datastore.v1.Value();
                        switch (object.nullValue) {
                        case "NULL_VALUE":
                        case 0:
                            message.nullValue = 0;
                            break;
                        }
                        if (object.booleanValue != null)
                            message.booleanValue = Boolean(object.booleanValue);
                        if (object.integerValue != null)
                            if ($util.Long)
                                (message.integerValue = $util.Long.fromValue(object.integerValue)).unsigned = false;
                            else if (typeof object.integerValue === "string")
                                message.integerValue = parseInt(object.integerValue, 10);
                            else if (typeof object.integerValue === "number")
                                message.integerValue = object.integerValue;
                            else if (typeof object.integerValue === "object")
                                message.integerValue = new $util.LongBits(object.integerValue.low >>> 0, object.integerValue.high >>> 0).toNumber();
                        if (object.doubleValue != null)
                            message.doubleValue = Number(object.doubleValue);
                        if (object.timestampValue != null) {
                            if (typeof object.timestampValue !== "object")
                                throw TypeError(".google.datastore.v1.Value.timestampValue: object expected");
                            message.timestampValue = $root.google.protobuf.Timestamp.fromObject(object.timestampValue);
                        }
                        if (object.keyValue != null) {
                            if (typeof object.keyValue !== "object")
                                throw TypeError(".google.datastore.v1.Value.keyValue: object expected");
                            message.keyValue = $root.google.datastore.v1.Key.fromObject(object.keyValue);
                        }
                        if (object.stringValue != null)
                            message.stringValue = String(object.stringValue);
                        if (object.blobValue != null)
                            if (typeof object.blobValue === "string")
                                $util.base64.decode(object.blobValue, message.blobValue = $util.newBuffer($util.base64.length(object.blobValue)), 0);
                            else if (object.blobValue.length)
                                message.blobValue = object.blobValue;
                        if (object.geoPointValue != null) {
                            if (typeof object.geoPointValue !== "object")
                                throw TypeError(".google.datastore.v1.Value.geoPointValue: object expected");
                            message.geoPointValue = $root.google.type.LatLng.fromObject(object.geoPointValue);
                        }
                        if (object.entityValue != null) {
                            if (typeof object.entityValue !== "object")
                                throw TypeError(".google.datastore.v1.Value.entityValue: object expected");
                            message.entityValue = $root.google.datastore.v1.Entity.fromObject(object.entityValue);
                        }
                        if (object.arrayValue != null) {
                            if (typeof object.arrayValue !== "object")
                                throw TypeError(".google.datastore.v1.Value.arrayValue: object expected");
                            message.arrayValue = $root.google.datastore.v1.ArrayValue.fromObject(object.arrayValue);
                        }
                        if (object.meaning != null)
                            message.meaning = object.meaning | 0;
                        if (object.excludeFromIndexes != null)
                            message.excludeFromIndexes = Boolean(object.excludeFromIndexes);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Value message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.Value
                     * @static
                     * @param {google.datastore.v1.Value} message Value
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Value.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.meaning = 0;
                            object.excludeFromIndexes = false;
                        }
                        if (message.booleanValue != null && message.hasOwnProperty("booleanValue")) {
                            object.booleanValue = message.booleanValue;
                            if (options.oneofs)
                                object.valueType = "booleanValue";
                        }
                        if (message.integerValue != null && message.hasOwnProperty("integerValue")) {
                            if (typeof message.integerValue === "number")
                                object.integerValue = options.longs === String ? String(message.integerValue) : message.integerValue;
                            else
                                object.integerValue = options.longs === String ? $util.Long.prototype.toString.call(message.integerValue) : options.longs === Number ? new $util.LongBits(message.integerValue.low >>> 0, message.integerValue.high >>> 0).toNumber() : message.integerValue;
                            if (options.oneofs)
                                object.valueType = "integerValue";
                        }
                        if (message.doubleValue != null && message.hasOwnProperty("doubleValue")) {
                            object.doubleValue = options.json && !isFinite(message.doubleValue) ? String(message.doubleValue) : message.doubleValue;
                            if (options.oneofs)
                                object.valueType = "doubleValue";
                        }
                        if (message.keyValue != null && message.hasOwnProperty("keyValue")) {
                            object.keyValue = $root.google.datastore.v1.Key.toObject(message.keyValue, options);
                            if (options.oneofs)
                                object.valueType = "keyValue";
                        }
                        if (message.entityValue != null && message.hasOwnProperty("entityValue")) {
                            object.entityValue = $root.google.datastore.v1.Entity.toObject(message.entityValue, options);
                            if (options.oneofs)
                                object.valueType = "entityValue";
                        }
                        if (message.geoPointValue != null && message.hasOwnProperty("geoPointValue")) {
                            object.geoPointValue = $root.google.type.LatLng.toObject(message.geoPointValue, options);
                            if (options.oneofs)
                                object.valueType = "geoPointValue";
                        }
                        if (message.arrayValue != null && message.hasOwnProperty("arrayValue")) {
                            object.arrayValue = $root.google.datastore.v1.ArrayValue.toObject(message.arrayValue, options);
                            if (options.oneofs)
                                object.valueType = "arrayValue";
                        }
                        if (message.timestampValue != null && message.hasOwnProperty("timestampValue")) {
                            object.timestampValue = $root.google.protobuf.Timestamp.toObject(message.timestampValue, options);
                            if (options.oneofs)
                                object.valueType = "timestampValue";
                        }
                        if (message.nullValue != null && message.hasOwnProperty("nullValue")) {
                            object.nullValue = options.enums === String ? $root.google.protobuf.NullValue[message.nullValue] : message.nullValue;
                            if (options.oneofs)
                                object.valueType = "nullValue";
                        }
                        if (message.meaning != null && message.hasOwnProperty("meaning"))
                            object.meaning = message.meaning;
                        if (message.stringValue != null && message.hasOwnProperty("stringValue")) {
                            object.stringValue = message.stringValue;
                            if (options.oneofs)
                                object.valueType = "stringValue";
                        }
                        if (message.blobValue != null && message.hasOwnProperty("blobValue")) {
                            object.blobValue = options.bytes === String ? $util.base64.encode(message.blobValue, 0, message.blobValue.length) : options.bytes === Array ? Array.prototype.slice.call(message.blobValue) : message.blobValue;
                            if (options.oneofs)
                                object.valueType = "blobValue";
                        }
                        if (message.excludeFromIndexes != null && message.hasOwnProperty("excludeFromIndexes"))
                            object.excludeFromIndexes = message.excludeFromIndexes;
                        return object;
                    };
    
                    /**
                     * Converts this Value to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.Value
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Value.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return Value;
                })();
    
                v1.Entity = (function() {
    
                    /**
                     * Properties of an Entity.
                     * @memberof google.datastore.v1
                     * @interface IEntity
                     * @property {google.datastore.v1.IKey|null} [key] Entity key
                     * @property {Object.<string,google.datastore.v1.IValue>|null} [properties] Entity properties
                     */
    
                    /**
                     * Constructs a new Entity.
                     * @memberof google.datastore.v1
                     * @classdesc Represents an Entity.
                     * @implements IEntity
                     * @constructor
                     * @param {google.datastore.v1.IEntity=} [properties] Properties to set
                     */
                    function Entity(properties) {
                        this.properties = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Entity key.
                     * @member {google.datastore.v1.IKey|null|undefined} key
                     * @memberof google.datastore.v1.Entity
                     * @instance
                     */
                    Entity.prototype.key = null;
    
                    /**
                     * Entity properties.
                     * @member {Object.<string,google.datastore.v1.IValue>} properties
                     * @memberof google.datastore.v1.Entity
                     * @instance
                     */
                    Entity.prototype.properties = $util.emptyObject;
    
                    /**
                     * Creates a new Entity instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {google.datastore.v1.IEntity=} [properties] Properties to set
                     * @returns {google.datastore.v1.Entity} Entity instance
                     */
                    Entity.create = function create(properties) {
                        return new Entity(properties);
                    };
    
                    /**
                     * Encodes the specified Entity message. Does not implicitly {@link google.datastore.v1.Entity.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {google.datastore.v1.IEntity} message Entity message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Entity.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                            $root.google.datastore.v1.Key.encode(message.key, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.properties != null && Object.hasOwnProperty.call(message, "properties"))
                            for (var keys = Object.keys(message.properties), i = 0; i < keys.length; ++i) {
                                writer.uint32(/* id 3, wireType 2 =*/26).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                                $root.google.datastore.v1.Value.encode(message.properties[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                            }
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Entity message, length delimited. Does not implicitly {@link google.datastore.v1.Entity.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {google.datastore.v1.IEntity} message Entity message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Entity.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an Entity message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.Entity} Entity
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Entity.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Entity(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.key = $root.google.datastore.v1.Key.decode(reader, reader.uint32());
                                break;
                            case 3:
                                if (message.properties === $util.emptyObject)
                                    message.properties = {};
                                var end2 = reader.uint32() + reader.pos;
                                key = "";
                                value = null;
                                while (reader.pos < end2) {
                                    var tag2 = reader.uint32();
                                    switch (tag2 >>> 3) {
                                    case 1:
                                        key = reader.string();
                                        break;
                                    case 2:
                                        value = $root.google.datastore.v1.Value.decode(reader, reader.uint32());
                                        break;
                                    default:
                                        reader.skipType(tag2 & 7);
                                        break;
                                    }
                                }
                                message.properties[key] = value;
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an Entity message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.Entity} Entity
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Entity.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an Entity message.
                     * @function verify
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Entity.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.key != null && message.hasOwnProperty("key")) {
                            var error = $root.google.datastore.v1.Key.verify(message.key);
                            if (error)
                                return "key." + error;
                        }
                        if (message.properties != null && message.hasOwnProperty("properties")) {
                            if (!$util.isObject(message.properties))
                                return "properties: object expected";
                            var key = Object.keys(message.properties);
                            for (var i = 0; i < key.length; ++i) {
                                var error = $root.google.datastore.v1.Value.verify(message.properties[key[i]]);
                                if (error)
                                    return "properties." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates an Entity message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.Entity} Entity
                     */
                    Entity.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.Entity)
                            return object;
                        var message = new $root.google.datastore.v1.Entity();
                        if (object.key != null) {
                            if (typeof object.key !== "object")
                                throw TypeError(".google.datastore.v1.Entity.key: object expected");
                            message.key = $root.google.datastore.v1.Key.fromObject(object.key);
                        }
                        if (object.properties) {
                            if (typeof object.properties !== "object")
                                throw TypeError(".google.datastore.v1.Entity.properties: object expected");
                            message.properties = {};
                            for (var keys = Object.keys(object.properties), i = 0; i < keys.length; ++i) {
                                if (typeof object.properties[keys[i]] !== "object")
                                    throw TypeError(".google.datastore.v1.Entity.properties: object expected");
                                message.properties[keys[i]] = $root.google.datastore.v1.Value.fromObject(object.properties[keys[i]]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an Entity message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.Entity
                     * @static
                     * @param {google.datastore.v1.Entity} message Entity
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Entity.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.properties = {};
                        if (options.defaults)
                            object.key = null;
                        if (message.key != null && message.hasOwnProperty("key"))
                            object.key = $root.google.datastore.v1.Key.toObject(message.key, options);
                        var keys2;
                        if (message.properties && (keys2 = Object.keys(message.properties)).length) {
                            object.properties = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.properties[keys2[j]] = $root.google.datastore.v1.Value.toObject(message.properties[keys2[j]], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this Entity to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.Entity
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Entity.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return Entity;
                })();
    
                v1.EntityResult = (function() {
    
                    /**
                     * Properties of an EntityResult.
                     * @memberof google.datastore.v1
                     * @interface IEntityResult
                     * @property {google.datastore.v1.IEntity|null} [entity] EntityResult entity
                     * @property {number|Long|null} [version] EntityResult version
                     * @property {Uint8Array|null} [cursor] EntityResult cursor
                     */
    
                    /**
                     * Constructs a new EntityResult.
                     * @memberof google.datastore.v1
                     * @classdesc Represents an EntityResult.
                     * @implements IEntityResult
                     * @constructor
                     * @param {google.datastore.v1.IEntityResult=} [properties] Properties to set
                     */
                    function EntityResult(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * EntityResult entity.
                     * @member {google.datastore.v1.IEntity|null|undefined} entity
                     * @memberof google.datastore.v1.EntityResult
                     * @instance
                     */
                    EntityResult.prototype.entity = null;
    
                    /**
                     * EntityResult version.
                     * @member {number|Long} version
                     * @memberof google.datastore.v1.EntityResult
                     * @instance
                     */
                    EntityResult.prototype.version = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * EntityResult cursor.
                     * @member {Uint8Array} cursor
                     * @memberof google.datastore.v1.EntityResult
                     * @instance
                     */
                    EntityResult.prototype.cursor = $util.newBuffer([]);
    
                    /**
                     * Creates a new EntityResult instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {google.datastore.v1.IEntityResult=} [properties] Properties to set
                     * @returns {google.datastore.v1.EntityResult} EntityResult instance
                     */
                    EntityResult.create = function create(properties) {
                        return new EntityResult(properties);
                    };
    
                    /**
                     * Encodes the specified EntityResult message. Does not implicitly {@link google.datastore.v1.EntityResult.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {google.datastore.v1.IEntityResult} message EntityResult message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    EntityResult.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.entity != null && Object.hasOwnProperty.call(message, "entity"))
                            $root.google.datastore.v1.Entity.encode(message.entity, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.cursor != null && Object.hasOwnProperty.call(message, "cursor"))
                            writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.cursor);
                        if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                            writer.uint32(/* id 4, wireType 0 =*/32).int64(message.version);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified EntityResult message, length delimited. Does not implicitly {@link google.datastore.v1.EntityResult.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {google.datastore.v1.IEntityResult} message EntityResult message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    EntityResult.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an EntityResult message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.EntityResult} EntityResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    EntityResult.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.EntityResult();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.entity = $root.google.datastore.v1.Entity.decode(reader, reader.uint32());
                                break;
                            case 4:
                                message.version = reader.int64();
                                break;
                            case 3:
                                message.cursor = reader.bytes();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an EntityResult message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.EntityResult} EntityResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    EntityResult.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an EntityResult message.
                     * @function verify
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    EntityResult.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.entity != null && message.hasOwnProperty("entity")) {
                            var error = $root.google.datastore.v1.Entity.verify(message.entity);
                            if (error)
                                return "entity." + error;
                        }
                        if (message.version != null && message.hasOwnProperty("version"))
                            if (!$util.isInteger(message.version) && !(message.version && $util.isInteger(message.version.low) && $util.isInteger(message.version.high)))
                                return "version: integer|Long expected";
                        if (message.cursor != null && message.hasOwnProperty("cursor"))
                            if (!(message.cursor && typeof message.cursor.length === "number" || $util.isString(message.cursor)))
                                return "cursor: buffer expected";
                        return null;
                    };
    
                    /**
                     * Creates an EntityResult message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.EntityResult} EntityResult
                     */
                    EntityResult.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.EntityResult)
                            return object;
                        var message = new $root.google.datastore.v1.EntityResult();
                        if (object.entity != null) {
                            if (typeof object.entity !== "object")
                                throw TypeError(".google.datastore.v1.EntityResult.entity: object expected");
                            message.entity = $root.google.datastore.v1.Entity.fromObject(object.entity);
                        }
                        if (object.version != null)
                            if ($util.Long)
                                (message.version = $util.Long.fromValue(object.version)).unsigned = false;
                            else if (typeof object.version === "string")
                                message.version = parseInt(object.version, 10);
                            else if (typeof object.version === "number")
                                message.version = object.version;
                            else if (typeof object.version === "object")
                                message.version = new $util.LongBits(object.version.low >>> 0, object.version.high >>> 0).toNumber();
                        if (object.cursor != null)
                            if (typeof object.cursor === "string")
                                $util.base64.decode(object.cursor, message.cursor = $util.newBuffer($util.base64.length(object.cursor)), 0);
                            else if (object.cursor.length)
                                message.cursor = object.cursor;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an EntityResult message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.EntityResult
                     * @static
                     * @param {google.datastore.v1.EntityResult} message EntityResult
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    EntityResult.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.entity = null;
                            if (options.bytes === String)
                                object.cursor = "";
                            else {
                                object.cursor = [];
                                if (options.bytes !== Array)
                                    object.cursor = $util.newBuffer(object.cursor);
                            }
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.version = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.version = options.longs === String ? "0" : 0;
                        }
                        if (message.entity != null && message.hasOwnProperty("entity"))
                            object.entity = $root.google.datastore.v1.Entity.toObject(message.entity, options);
                        if (message.cursor != null && message.hasOwnProperty("cursor"))
                            object.cursor = options.bytes === String ? $util.base64.encode(message.cursor, 0, message.cursor.length) : options.bytes === Array ? Array.prototype.slice.call(message.cursor) : message.cursor;
                        if (message.version != null && message.hasOwnProperty("version"))
                            if (typeof message.version === "number")
                                object.version = options.longs === String ? String(message.version) : message.version;
                            else
                                object.version = options.longs === String ? $util.Long.prototype.toString.call(message.version) : options.longs === Number ? new $util.LongBits(message.version.low >>> 0, message.version.high >>> 0).toNumber() : message.version;
                        return object;
                    };
    
                    /**
                     * Converts this EntityResult to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.EntityResult
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    EntityResult.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * ResultType enum.
                     * @name google.datastore.v1.EntityResult.ResultType
                     * @enum {number}
                     * @property {number} RESULT_TYPE_UNSPECIFIED=0 RESULT_TYPE_UNSPECIFIED value
                     * @property {number} FULL=1 FULL value
                     * @property {number} PROJECTION=2 PROJECTION value
                     * @property {number} KEY_ONLY=3 KEY_ONLY value
                     */
                    EntityResult.ResultType = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "RESULT_TYPE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "FULL"] = 1;
                        values[valuesById[2] = "PROJECTION"] = 2;
                        values[valuesById[3] = "KEY_ONLY"] = 3;
                        return values;
                    })();
    
                    return EntityResult;
                })();
    
                v1.Query = (function() {
    
                    /**
                     * Properties of a Query.
                     * @memberof google.datastore.v1
                     * @interface IQuery
                     * @property {Array.<google.datastore.v1.IProjection>|null} [projection] Query projection
                     * @property {Array.<google.datastore.v1.IKindExpression>|null} [kind] Query kind
                     * @property {google.datastore.v1.IFilter|null} [filter] Query filter
                     * @property {Array.<google.datastore.v1.IPropertyOrder>|null} [order] Query order
                     * @property {Array.<google.datastore.v1.IPropertyReference>|null} [distinctOn] Query distinctOn
                     * @property {Uint8Array|null} [startCursor] Query startCursor
                     * @property {Uint8Array|null} [endCursor] Query endCursor
                     * @property {number|null} [offset] Query offset
                     * @property {google.protobuf.IInt32Value|null} [limit] Query limit
                     */
    
                    /**
                     * Constructs a new Query.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a Query.
                     * @implements IQuery
                     * @constructor
                     * @param {google.datastore.v1.IQuery=} [properties] Properties to set
                     */
                    function Query(properties) {
                        this.projection = [];
                        this.kind = [];
                        this.order = [];
                        this.distinctOn = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Query projection.
                     * @member {Array.<google.datastore.v1.IProjection>} projection
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.projection = $util.emptyArray;
    
                    /**
                     * Query kind.
                     * @member {Array.<google.datastore.v1.IKindExpression>} kind
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.kind = $util.emptyArray;
    
                    /**
                     * Query filter.
                     * @member {google.datastore.v1.IFilter|null|undefined} filter
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.filter = null;
    
                    /**
                     * Query order.
                     * @member {Array.<google.datastore.v1.IPropertyOrder>} order
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.order = $util.emptyArray;
    
                    /**
                     * Query distinctOn.
                     * @member {Array.<google.datastore.v1.IPropertyReference>} distinctOn
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.distinctOn = $util.emptyArray;
    
                    /**
                     * Query startCursor.
                     * @member {Uint8Array} startCursor
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.startCursor = $util.newBuffer([]);
    
                    /**
                     * Query endCursor.
                     * @member {Uint8Array} endCursor
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.endCursor = $util.newBuffer([]);
    
                    /**
                     * Query offset.
                     * @member {number} offset
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.offset = 0;
    
                    /**
                     * Query limit.
                     * @member {google.protobuf.IInt32Value|null|undefined} limit
                     * @memberof google.datastore.v1.Query
                     * @instance
                     */
                    Query.prototype.limit = null;
    
                    /**
                     * Creates a new Query instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {google.datastore.v1.IQuery=} [properties] Properties to set
                     * @returns {google.datastore.v1.Query} Query instance
                     */
                    Query.create = function create(properties) {
                        return new Query(properties);
                    };
    
                    /**
                     * Encodes the specified Query message. Does not implicitly {@link google.datastore.v1.Query.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {google.datastore.v1.IQuery} message Query message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Query.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.projection != null && message.projection.length)
                            for (var i = 0; i < message.projection.length; ++i)
                                $root.google.datastore.v1.Projection.encode(message.projection[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.kind != null && message.kind.length)
                            for (var i = 0; i < message.kind.length; ++i)
                                $root.google.datastore.v1.KindExpression.encode(message.kind[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                            $root.google.datastore.v1.Filter.encode(message.filter, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.order != null && message.order.length)
                            for (var i = 0; i < message.order.length; ++i)
                                $root.google.datastore.v1.PropertyOrder.encode(message.order[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.distinctOn != null && message.distinctOn.length)
                            for (var i = 0; i < message.distinctOn.length; ++i)
                                $root.google.datastore.v1.PropertyReference.encode(message.distinctOn[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.startCursor != null && Object.hasOwnProperty.call(message, "startCursor"))
                            writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.startCursor);
                        if (message.endCursor != null && Object.hasOwnProperty.call(message, "endCursor"))
                            writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.endCursor);
                        if (message.offset != null && Object.hasOwnProperty.call(message, "offset"))
                            writer.uint32(/* id 10, wireType 0 =*/80).int32(message.offset);
                        if (message.limit != null && Object.hasOwnProperty.call(message, "limit"))
                            $root.google.protobuf.Int32Value.encode(message.limit, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Query message, length delimited. Does not implicitly {@link google.datastore.v1.Query.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {google.datastore.v1.IQuery} message Query message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Query.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Query message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.Query} Query
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Query.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Query();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 2:
                                if (!(message.projection && message.projection.length))
                                    message.projection = [];
                                message.projection.push($root.google.datastore.v1.Projection.decode(reader, reader.uint32()));
                                break;
                            case 3:
                                if (!(message.kind && message.kind.length))
                                    message.kind = [];
                                message.kind.push($root.google.datastore.v1.KindExpression.decode(reader, reader.uint32()));
                                break;
                            case 4:
                                message.filter = $root.google.datastore.v1.Filter.decode(reader, reader.uint32());
                                break;
                            case 5:
                                if (!(message.order && message.order.length))
                                    message.order = [];
                                message.order.push($root.google.datastore.v1.PropertyOrder.decode(reader, reader.uint32()));
                                break;
                            case 6:
                                if (!(message.distinctOn && message.distinctOn.length))
                                    message.distinctOn = [];
                                message.distinctOn.push($root.google.datastore.v1.PropertyReference.decode(reader, reader.uint32()));
                                break;
                            case 7:
                                message.startCursor = reader.bytes();
                                break;
                            case 8:
                                message.endCursor = reader.bytes();
                                break;
                            case 10:
                                message.offset = reader.int32();
                                break;
                            case 12:
                                message.limit = $root.google.protobuf.Int32Value.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Query message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.Query} Query
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Query.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Query message.
                     * @function verify
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Query.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.projection != null && message.hasOwnProperty("projection")) {
                            if (!Array.isArray(message.projection))
                                return "projection: array expected";
                            for (var i = 0; i < message.projection.length; ++i) {
                                var error = $root.google.datastore.v1.Projection.verify(message.projection[i]);
                                if (error)
                                    return "projection." + error;
                            }
                        }
                        if (message.kind != null && message.hasOwnProperty("kind")) {
                            if (!Array.isArray(message.kind))
                                return "kind: array expected";
                            for (var i = 0; i < message.kind.length; ++i) {
                                var error = $root.google.datastore.v1.KindExpression.verify(message.kind[i]);
                                if (error)
                                    return "kind." + error;
                            }
                        }
                        if (message.filter != null && message.hasOwnProperty("filter")) {
                            var error = $root.google.datastore.v1.Filter.verify(message.filter);
                            if (error)
                                return "filter." + error;
                        }
                        if (message.order != null && message.hasOwnProperty("order")) {
                            if (!Array.isArray(message.order))
                                return "order: array expected";
                            for (var i = 0; i < message.order.length; ++i) {
                                var error = $root.google.datastore.v1.PropertyOrder.verify(message.order[i]);
                                if (error)
                                    return "order." + error;
                            }
                        }
                        if (message.distinctOn != null && message.hasOwnProperty("distinctOn")) {
                            if (!Array.isArray(message.distinctOn))
                                return "distinctOn: array expected";
                            for (var i = 0; i < message.distinctOn.length; ++i) {
                                var error = $root.google.datastore.v1.PropertyReference.verify(message.distinctOn[i]);
                                if (error)
                                    return "distinctOn." + error;
                            }
                        }
                        if (message.startCursor != null && message.hasOwnProperty("startCursor"))
                            if (!(message.startCursor && typeof message.startCursor.length === "number" || $util.isString(message.startCursor)))
                                return "startCursor: buffer expected";
                        if (message.endCursor != null && message.hasOwnProperty("endCursor"))
                            if (!(message.endCursor && typeof message.endCursor.length === "number" || $util.isString(message.endCursor)))
                                return "endCursor: buffer expected";
                        if (message.offset != null && message.hasOwnProperty("offset"))
                            if (!$util.isInteger(message.offset))
                                return "offset: integer expected";
                        if (message.limit != null && message.hasOwnProperty("limit")) {
                            var error = $root.google.protobuf.Int32Value.verify(message.limit);
                            if (error)
                                return "limit." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Query message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.Query} Query
                     */
                    Query.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.Query)
                            return object;
                        var message = new $root.google.datastore.v1.Query();
                        if (object.projection) {
                            if (!Array.isArray(object.projection))
                                throw TypeError(".google.datastore.v1.Query.projection: array expected");
                            message.projection = [];
                            for (var i = 0; i < object.projection.length; ++i) {
                                if (typeof object.projection[i] !== "object")
                                    throw TypeError(".google.datastore.v1.Query.projection: object expected");
                                message.projection[i] = $root.google.datastore.v1.Projection.fromObject(object.projection[i]);
                            }
                        }
                        if (object.kind) {
                            if (!Array.isArray(object.kind))
                                throw TypeError(".google.datastore.v1.Query.kind: array expected");
                            message.kind = [];
                            for (var i = 0; i < object.kind.length; ++i) {
                                if (typeof object.kind[i] !== "object")
                                    throw TypeError(".google.datastore.v1.Query.kind: object expected");
                                message.kind[i] = $root.google.datastore.v1.KindExpression.fromObject(object.kind[i]);
                            }
                        }
                        if (object.filter != null) {
                            if (typeof object.filter !== "object")
                                throw TypeError(".google.datastore.v1.Query.filter: object expected");
                            message.filter = $root.google.datastore.v1.Filter.fromObject(object.filter);
                        }
                        if (object.order) {
                            if (!Array.isArray(object.order))
                                throw TypeError(".google.datastore.v1.Query.order: array expected");
                            message.order = [];
                            for (var i = 0; i < object.order.length; ++i) {
                                if (typeof object.order[i] !== "object")
                                    throw TypeError(".google.datastore.v1.Query.order: object expected");
                                message.order[i] = $root.google.datastore.v1.PropertyOrder.fromObject(object.order[i]);
                            }
                        }
                        if (object.distinctOn) {
                            if (!Array.isArray(object.distinctOn))
                                throw TypeError(".google.datastore.v1.Query.distinctOn: array expected");
                            message.distinctOn = [];
                            for (var i = 0; i < object.distinctOn.length; ++i) {
                                if (typeof object.distinctOn[i] !== "object")
                                    throw TypeError(".google.datastore.v1.Query.distinctOn: object expected");
                                message.distinctOn[i] = $root.google.datastore.v1.PropertyReference.fromObject(object.distinctOn[i]);
                            }
                        }
                        if (object.startCursor != null)
                            if (typeof object.startCursor === "string")
                                $util.base64.decode(object.startCursor, message.startCursor = $util.newBuffer($util.base64.length(object.startCursor)), 0);
                            else if (object.startCursor.length)
                                message.startCursor = object.startCursor;
                        if (object.endCursor != null)
                            if (typeof object.endCursor === "string")
                                $util.base64.decode(object.endCursor, message.endCursor = $util.newBuffer($util.base64.length(object.endCursor)), 0);
                            else if (object.endCursor.length)
                                message.endCursor = object.endCursor;
                        if (object.offset != null)
                            message.offset = object.offset | 0;
                        if (object.limit != null) {
                            if (typeof object.limit !== "object")
                                throw TypeError(".google.datastore.v1.Query.limit: object expected");
                            message.limit = $root.google.protobuf.Int32Value.fromObject(object.limit);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Query message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.Query
                     * @static
                     * @param {google.datastore.v1.Query} message Query
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Query.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults) {
                            object.projection = [];
                            object.kind = [];
                            object.order = [];
                            object.distinctOn = [];
                        }
                        if (options.defaults) {
                            object.filter = null;
                            if (options.bytes === String)
                                object.startCursor = "";
                            else {
                                object.startCursor = [];
                                if (options.bytes !== Array)
                                    object.startCursor = $util.newBuffer(object.startCursor);
                            }
                            if (options.bytes === String)
                                object.endCursor = "";
                            else {
                                object.endCursor = [];
                                if (options.bytes !== Array)
                                    object.endCursor = $util.newBuffer(object.endCursor);
                            }
                            object.offset = 0;
                            object.limit = null;
                        }
                        if (message.projection && message.projection.length) {
                            object.projection = [];
                            for (var j = 0; j < message.projection.length; ++j)
                                object.projection[j] = $root.google.datastore.v1.Projection.toObject(message.projection[j], options);
                        }
                        if (message.kind && message.kind.length) {
                            object.kind = [];
                            for (var j = 0; j < message.kind.length; ++j)
                                object.kind[j] = $root.google.datastore.v1.KindExpression.toObject(message.kind[j], options);
                        }
                        if (message.filter != null && message.hasOwnProperty("filter"))
                            object.filter = $root.google.datastore.v1.Filter.toObject(message.filter, options);
                        if (message.order && message.order.length) {
                            object.order = [];
                            for (var j = 0; j < message.order.length; ++j)
                                object.order[j] = $root.google.datastore.v1.PropertyOrder.toObject(message.order[j], options);
                        }
                        if (message.distinctOn && message.distinctOn.length) {
                            object.distinctOn = [];
                            for (var j = 0; j < message.distinctOn.length; ++j)
                                object.distinctOn[j] = $root.google.datastore.v1.PropertyReference.toObject(message.distinctOn[j], options);
                        }
                        if (message.startCursor != null && message.hasOwnProperty("startCursor"))
                            object.startCursor = options.bytes === String ? $util.base64.encode(message.startCursor, 0, message.startCursor.length) : options.bytes === Array ? Array.prototype.slice.call(message.startCursor) : message.startCursor;
                        if (message.endCursor != null && message.hasOwnProperty("endCursor"))
                            object.endCursor = options.bytes === String ? $util.base64.encode(message.endCursor, 0, message.endCursor.length) : options.bytes === Array ? Array.prototype.slice.call(message.endCursor) : message.endCursor;
                        if (message.offset != null && message.hasOwnProperty("offset"))
                            object.offset = message.offset;
                        if (message.limit != null && message.hasOwnProperty("limit"))
                            object.limit = $root.google.protobuf.Int32Value.toObject(message.limit, options);
                        return object;
                    };
    
                    /**
                     * Converts this Query to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.Query
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Query.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return Query;
                })();
    
                v1.KindExpression = (function() {
    
                    /**
                     * Properties of a KindExpression.
                     * @memberof google.datastore.v1
                     * @interface IKindExpression
                     * @property {string|null} [name] KindExpression name
                     */
    
                    /**
                     * Constructs a new KindExpression.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a KindExpression.
                     * @implements IKindExpression
                     * @constructor
                     * @param {google.datastore.v1.IKindExpression=} [properties] Properties to set
                     */
                    function KindExpression(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * KindExpression name.
                     * @member {string} name
                     * @memberof google.datastore.v1.KindExpression
                     * @instance
                     */
                    KindExpression.prototype.name = "";
    
                    /**
                     * Creates a new KindExpression instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {google.datastore.v1.IKindExpression=} [properties] Properties to set
                     * @returns {google.datastore.v1.KindExpression} KindExpression instance
                     */
                    KindExpression.create = function create(properties) {
                        return new KindExpression(properties);
                    };
    
                    /**
                     * Encodes the specified KindExpression message. Does not implicitly {@link google.datastore.v1.KindExpression.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {google.datastore.v1.IKindExpression} message KindExpression message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    KindExpression.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified KindExpression message, length delimited. Does not implicitly {@link google.datastore.v1.KindExpression.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {google.datastore.v1.IKindExpression} message KindExpression message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    KindExpression.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a KindExpression message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.KindExpression} KindExpression
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    KindExpression.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.KindExpression();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.name = reader.string();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a KindExpression message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.KindExpression} KindExpression
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    KindExpression.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a KindExpression message.
                     * @function verify
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    KindExpression.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a KindExpression message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.KindExpression} KindExpression
                     */
                    KindExpression.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.KindExpression)
                            return object;
                        var message = new $root.google.datastore.v1.KindExpression();
                        if (object.name != null)
                            message.name = String(object.name);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a KindExpression message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.KindExpression
                     * @static
                     * @param {google.datastore.v1.KindExpression} message KindExpression
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    KindExpression.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.name = "";
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        return object;
                    };
    
                    /**
                     * Converts this KindExpression to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.KindExpression
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    KindExpression.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return KindExpression;
                })();
    
                v1.PropertyReference = (function() {
    
                    /**
                     * Properties of a PropertyReference.
                     * @memberof google.datastore.v1
                     * @interface IPropertyReference
                     * @property {string|null} [name] PropertyReference name
                     */
    
                    /**
                     * Constructs a new PropertyReference.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a PropertyReference.
                     * @implements IPropertyReference
                     * @constructor
                     * @param {google.datastore.v1.IPropertyReference=} [properties] Properties to set
                     */
                    function PropertyReference(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PropertyReference name.
                     * @member {string} name
                     * @memberof google.datastore.v1.PropertyReference
                     * @instance
                     */
                    PropertyReference.prototype.name = "";
    
                    /**
                     * Creates a new PropertyReference instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {google.datastore.v1.IPropertyReference=} [properties] Properties to set
                     * @returns {google.datastore.v1.PropertyReference} PropertyReference instance
                     */
                    PropertyReference.create = function create(properties) {
                        return new PropertyReference(properties);
                    };
    
                    /**
                     * Encodes the specified PropertyReference message. Does not implicitly {@link google.datastore.v1.PropertyReference.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {google.datastore.v1.IPropertyReference} message PropertyReference message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PropertyReference.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.name);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PropertyReference message, length delimited. Does not implicitly {@link google.datastore.v1.PropertyReference.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {google.datastore.v1.IPropertyReference} message PropertyReference message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PropertyReference.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PropertyReference message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.PropertyReference} PropertyReference
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PropertyReference.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.PropertyReference();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 2:
                                message.name = reader.string();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PropertyReference message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.PropertyReference} PropertyReference
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PropertyReference.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PropertyReference message.
                     * @function verify
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PropertyReference.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a PropertyReference message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.PropertyReference} PropertyReference
                     */
                    PropertyReference.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.PropertyReference)
                            return object;
                        var message = new $root.google.datastore.v1.PropertyReference();
                        if (object.name != null)
                            message.name = String(object.name);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PropertyReference message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.PropertyReference
                     * @static
                     * @param {google.datastore.v1.PropertyReference} message PropertyReference
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PropertyReference.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.name = "";
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        return object;
                    };
    
                    /**
                     * Converts this PropertyReference to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.PropertyReference
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PropertyReference.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return PropertyReference;
                })();
    
                v1.Projection = (function() {
    
                    /**
                     * Properties of a Projection.
                     * @memberof google.datastore.v1
                     * @interface IProjection
                     * @property {google.datastore.v1.IPropertyReference|null} [property] Projection property
                     */
    
                    /**
                     * Constructs a new Projection.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a Projection.
                     * @implements IProjection
                     * @constructor
                     * @param {google.datastore.v1.IProjection=} [properties] Properties to set
                     */
                    function Projection(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Projection property.
                     * @member {google.datastore.v1.IPropertyReference|null|undefined} property
                     * @memberof google.datastore.v1.Projection
                     * @instance
                     */
                    Projection.prototype.property = null;
    
                    /**
                     * Creates a new Projection instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {google.datastore.v1.IProjection=} [properties] Properties to set
                     * @returns {google.datastore.v1.Projection} Projection instance
                     */
                    Projection.create = function create(properties) {
                        return new Projection(properties);
                    };
    
                    /**
                     * Encodes the specified Projection message. Does not implicitly {@link google.datastore.v1.Projection.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {google.datastore.v1.IProjection} message Projection message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Projection.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.property != null && Object.hasOwnProperty.call(message, "property"))
                            $root.google.datastore.v1.PropertyReference.encode(message.property, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Projection message, length delimited. Does not implicitly {@link google.datastore.v1.Projection.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {google.datastore.v1.IProjection} message Projection message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Projection.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Projection message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.Projection} Projection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Projection.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Projection();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.property = $root.google.datastore.v1.PropertyReference.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Projection message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.Projection} Projection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Projection.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Projection message.
                     * @function verify
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Projection.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.property != null && message.hasOwnProperty("property")) {
                            var error = $root.google.datastore.v1.PropertyReference.verify(message.property);
                            if (error)
                                return "property." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Projection message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.Projection} Projection
                     */
                    Projection.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.Projection)
                            return object;
                        var message = new $root.google.datastore.v1.Projection();
                        if (object.property != null) {
                            if (typeof object.property !== "object")
                                throw TypeError(".google.datastore.v1.Projection.property: object expected");
                            message.property = $root.google.datastore.v1.PropertyReference.fromObject(object.property);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Projection message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.Projection
                     * @static
                     * @param {google.datastore.v1.Projection} message Projection
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Projection.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.property = null;
                        if (message.property != null && message.hasOwnProperty("property"))
                            object.property = $root.google.datastore.v1.PropertyReference.toObject(message.property, options);
                        return object;
                    };
    
                    /**
                     * Converts this Projection to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.Projection
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Projection.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return Projection;
                })();
    
                v1.PropertyOrder = (function() {
    
                    /**
                     * Properties of a PropertyOrder.
                     * @memberof google.datastore.v1
                     * @interface IPropertyOrder
                     * @property {google.datastore.v1.IPropertyReference|null} [property] PropertyOrder property
                     * @property {google.datastore.v1.PropertyOrder.Direction|null} [direction] PropertyOrder direction
                     */
    
                    /**
                     * Constructs a new PropertyOrder.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a PropertyOrder.
                     * @implements IPropertyOrder
                     * @constructor
                     * @param {google.datastore.v1.IPropertyOrder=} [properties] Properties to set
                     */
                    function PropertyOrder(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PropertyOrder property.
                     * @member {google.datastore.v1.IPropertyReference|null|undefined} property
                     * @memberof google.datastore.v1.PropertyOrder
                     * @instance
                     */
                    PropertyOrder.prototype.property = null;
    
                    /**
                     * PropertyOrder direction.
                     * @member {google.datastore.v1.PropertyOrder.Direction} direction
                     * @memberof google.datastore.v1.PropertyOrder
                     * @instance
                     */
                    PropertyOrder.prototype.direction = 0;
    
                    /**
                     * Creates a new PropertyOrder instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {google.datastore.v1.IPropertyOrder=} [properties] Properties to set
                     * @returns {google.datastore.v1.PropertyOrder} PropertyOrder instance
                     */
                    PropertyOrder.create = function create(properties) {
                        return new PropertyOrder(properties);
                    };
    
                    /**
                     * Encodes the specified PropertyOrder message. Does not implicitly {@link google.datastore.v1.PropertyOrder.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {google.datastore.v1.IPropertyOrder} message PropertyOrder message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PropertyOrder.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.property != null && Object.hasOwnProperty.call(message, "property"))
                            $root.google.datastore.v1.PropertyReference.encode(message.property, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.direction != null && Object.hasOwnProperty.call(message, "direction"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.direction);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PropertyOrder message, length delimited. Does not implicitly {@link google.datastore.v1.PropertyOrder.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {google.datastore.v1.IPropertyOrder} message PropertyOrder message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PropertyOrder.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PropertyOrder message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.PropertyOrder} PropertyOrder
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PropertyOrder.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.PropertyOrder();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.property = $root.google.datastore.v1.PropertyReference.decode(reader, reader.uint32());
                                break;
                            case 2:
                                message.direction = reader.int32();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PropertyOrder message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.PropertyOrder} PropertyOrder
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PropertyOrder.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PropertyOrder message.
                     * @function verify
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PropertyOrder.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.property != null && message.hasOwnProperty("property")) {
                            var error = $root.google.datastore.v1.PropertyReference.verify(message.property);
                            if (error)
                                return "property." + error;
                        }
                        if (message.direction != null && message.hasOwnProperty("direction"))
                            switch (message.direction) {
                            default:
                                return "direction: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        return null;
                    };
    
                    /**
                     * Creates a PropertyOrder message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.PropertyOrder} PropertyOrder
                     */
                    PropertyOrder.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.PropertyOrder)
                            return object;
                        var message = new $root.google.datastore.v1.PropertyOrder();
                        if (object.property != null) {
                            if (typeof object.property !== "object")
                                throw TypeError(".google.datastore.v1.PropertyOrder.property: object expected");
                            message.property = $root.google.datastore.v1.PropertyReference.fromObject(object.property);
                        }
                        switch (object.direction) {
                        case "DIRECTION_UNSPECIFIED":
                        case 0:
                            message.direction = 0;
                            break;
                        case "ASCENDING":
                        case 1:
                            message.direction = 1;
                            break;
                        case "DESCENDING":
                        case 2:
                            message.direction = 2;
                            break;
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PropertyOrder message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.PropertyOrder
                     * @static
                     * @param {google.datastore.v1.PropertyOrder} message PropertyOrder
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PropertyOrder.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.property = null;
                            object.direction = options.enums === String ? "DIRECTION_UNSPECIFIED" : 0;
                        }
                        if (message.property != null && message.hasOwnProperty("property"))
                            object.property = $root.google.datastore.v1.PropertyReference.toObject(message.property, options);
                        if (message.direction != null && message.hasOwnProperty("direction"))
                            object.direction = options.enums === String ? $root.google.datastore.v1.PropertyOrder.Direction[message.direction] : message.direction;
                        return object;
                    };
    
                    /**
                     * Converts this PropertyOrder to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.PropertyOrder
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PropertyOrder.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Direction enum.
                     * @name google.datastore.v1.PropertyOrder.Direction
                     * @enum {number}
                     * @property {number} DIRECTION_UNSPECIFIED=0 DIRECTION_UNSPECIFIED value
                     * @property {number} ASCENDING=1 ASCENDING value
                     * @property {number} DESCENDING=2 DESCENDING value
                     */
                    PropertyOrder.Direction = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "DIRECTION_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ASCENDING"] = 1;
                        values[valuesById[2] = "DESCENDING"] = 2;
                        return values;
                    })();
    
                    return PropertyOrder;
                })();
    
                v1.Filter = (function() {
    
                    /**
                     * Properties of a Filter.
                     * @memberof google.datastore.v1
                     * @interface IFilter
                     * @property {google.datastore.v1.ICompositeFilter|null} [compositeFilter] Filter compositeFilter
                     * @property {google.datastore.v1.IPropertyFilter|null} [propertyFilter] Filter propertyFilter
                     */
    
                    /**
                     * Constructs a new Filter.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a Filter.
                     * @implements IFilter
                     * @constructor
                     * @param {google.datastore.v1.IFilter=} [properties] Properties to set
                     */
                    function Filter(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Filter compositeFilter.
                     * @member {google.datastore.v1.ICompositeFilter|null|undefined} compositeFilter
                     * @memberof google.datastore.v1.Filter
                     * @instance
                     */
                    Filter.prototype.compositeFilter = null;
    
                    /**
                     * Filter propertyFilter.
                     * @member {google.datastore.v1.IPropertyFilter|null|undefined} propertyFilter
                     * @memberof google.datastore.v1.Filter
                     * @instance
                     */
                    Filter.prototype.propertyFilter = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * Filter filterType.
                     * @member {"compositeFilter"|"propertyFilter"|undefined} filterType
                     * @memberof google.datastore.v1.Filter
                     * @instance
                     */
                    Object.defineProperty(Filter.prototype, "filterType", {
                        get: $util.oneOfGetter($oneOfFields = ["compositeFilter", "propertyFilter"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new Filter instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {google.datastore.v1.IFilter=} [properties] Properties to set
                     * @returns {google.datastore.v1.Filter} Filter instance
                     */
                    Filter.create = function create(properties) {
                        return new Filter(properties);
                    };
    
                    /**
                     * Encodes the specified Filter message. Does not implicitly {@link google.datastore.v1.Filter.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {google.datastore.v1.IFilter} message Filter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Filter.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.compositeFilter != null && Object.hasOwnProperty.call(message, "compositeFilter"))
                            $root.google.datastore.v1.CompositeFilter.encode(message.compositeFilter, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.propertyFilter != null && Object.hasOwnProperty.call(message, "propertyFilter"))
                            $root.google.datastore.v1.PropertyFilter.encode(message.propertyFilter, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Filter message, length delimited. Does not implicitly {@link google.datastore.v1.Filter.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {google.datastore.v1.IFilter} message Filter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Filter.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Filter message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.Filter} Filter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Filter.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.Filter();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.compositeFilter = $root.google.datastore.v1.CompositeFilter.decode(reader, reader.uint32());
                                break;
                            case 2:
                                message.propertyFilter = $root.google.datastore.v1.PropertyFilter.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Filter message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.Filter} Filter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Filter.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Filter message.
                     * @function verify
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Filter.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.compositeFilter != null && message.hasOwnProperty("compositeFilter")) {
                            properties.filterType = 1;
                            {
                                var error = $root.google.datastore.v1.CompositeFilter.verify(message.compositeFilter);
                                if (error)
                                    return "compositeFilter." + error;
                            }
                        }
                        if (message.propertyFilter != null && message.hasOwnProperty("propertyFilter")) {
                            if (properties.filterType === 1)
                                return "filterType: multiple values";
                            properties.filterType = 1;
                            {
                                var error = $root.google.datastore.v1.PropertyFilter.verify(message.propertyFilter);
                                if (error)
                                    return "propertyFilter." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Filter message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.Filter} Filter
                     */
                    Filter.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.Filter)
                            return object;
                        var message = new $root.google.datastore.v1.Filter();
                        if (object.compositeFilter != null) {
                            if (typeof object.compositeFilter !== "object")
                                throw TypeError(".google.datastore.v1.Filter.compositeFilter: object expected");
                            message.compositeFilter = $root.google.datastore.v1.CompositeFilter.fromObject(object.compositeFilter);
                        }
                        if (object.propertyFilter != null) {
                            if (typeof object.propertyFilter !== "object")
                                throw TypeError(".google.datastore.v1.Filter.propertyFilter: object expected");
                            message.propertyFilter = $root.google.datastore.v1.PropertyFilter.fromObject(object.propertyFilter);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Filter message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.Filter
                     * @static
                     * @param {google.datastore.v1.Filter} message Filter
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Filter.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (message.compositeFilter != null && message.hasOwnProperty("compositeFilter")) {
                            object.compositeFilter = $root.google.datastore.v1.CompositeFilter.toObject(message.compositeFilter, options);
                            if (options.oneofs)
                                object.filterType = "compositeFilter";
                        }
                        if (message.propertyFilter != null && message.hasOwnProperty("propertyFilter")) {
                            object.propertyFilter = $root.google.datastore.v1.PropertyFilter.toObject(message.propertyFilter, options);
                            if (options.oneofs)
                                object.filterType = "propertyFilter";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this Filter to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.Filter
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Filter.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return Filter;
                })();
    
                v1.CompositeFilter = (function() {
    
                    /**
                     * Properties of a CompositeFilter.
                     * @memberof google.datastore.v1
                     * @interface ICompositeFilter
                     * @property {google.datastore.v1.CompositeFilter.Operator|null} [op] CompositeFilter op
                     * @property {Array.<google.datastore.v1.IFilter>|null} [filters] CompositeFilter filters
                     */
    
                    /**
                     * Constructs a new CompositeFilter.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a CompositeFilter.
                     * @implements ICompositeFilter
                     * @constructor
                     * @param {google.datastore.v1.ICompositeFilter=} [properties] Properties to set
                     */
                    function CompositeFilter(properties) {
                        this.filters = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * CompositeFilter op.
                     * @member {google.datastore.v1.CompositeFilter.Operator} op
                     * @memberof google.datastore.v1.CompositeFilter
                     * @instance
                     */
                    CompositeFilter.prototype.op = 0;
    
                    /**
                     * CompositeFilter filters.
                     * @member {Array.<google.datastore.v1.IFilter>} filters
                     * @memberof google.datastore.v1.CompositeFilter
                     * @instance
                     */
                    CompositeFilter.prototype.filters = $util.emptyArray;
    
                    /**
                     * Creates a new CompositeFilter instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {google.datastore.v1.ICompositeFilter=} [properties] Properties to set
                     * @returns {google.datastore.v1.CompositeFilter} CompositeFilter instance
                     */
                    CompositeFilter.create = function create(properties) {
                        return new CompositeFilter(properties);
                    };
    
                    /**
                     * Encodes the specified CompositeFilter message. Does not implicitly {@link google.datastore.v1.CompositeFilter.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {google.datastore.v1.ICompositeFilter} message CompositeFilter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CompositeFilter.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.op != null && Object.hasOwnProperty.call(message, "op"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.op);
                        if (message.filters != null && message.filters.length)
                            for (var i = 0; i < message.filters.length; ++i)
                                $root.google.datastore.v1.Filter.encode(message.filters[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified CompositeFilter message, length delimited. Does not implicitly {@link google.datastore.v1.CompositeFilter.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {google.datastore.v1.ICompositeFilter} message CompositeFilter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CompositeFilter.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a CompositeFilter message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.CompositeFilter} CompositeFilter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CompositeFilter.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.CompositeFilter();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.op = reader.int32();
                                break;
                            case 2:
                                if (!(message.filters && message.filters.length))
                                    message.filters = [];
                                message.filters.push($root.google.datastore.v1.Filter.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a CompositeFilter message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.CompositeFilter} CompositeFilter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CompositeFilter.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a CompositeFilter message.
                     * @function verify
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    CompositeFilter.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.op != null && message.hasOwnProperty("op"))
                            switch (message.op) {
                            default:
                                return "op: enum value expected";
                            case 0:
                            case 1:
                                break;
                            }
                        if (message.filters != null && message.hasOwnProperty("filters")) {
                            if (!Array.isArray(message.filters))
                                return "filters: array expected";
                            for (var i = 0; i < message.filters.length; ++i) {
                                var error = $root.google.datastore.v1.Filter.verify(message.filters[i]);
                                if (error)
                                    return "filters." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a CompositeFilter message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.CompositeFilter} CompositeFilter
                     */
                    CompositeFilter.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.CompositeFilter)
                            return object;
                        var message = new $root.google.datastore.v1.CompositeFilter();
                        switch (object.op) {
                        case "OPERATOR_UNSPECIFIED":
                        case 0:
                            message.op = 0;
                            break;
                        case "AND":
                        case 1:
                            message.op = 1;
                            break;
                        }
                        if (object.filters) {
                            if (!Array.isArray(object.filters))
                                throw TypeError(".google.datastore.v1.CompositeFilter.filters: array expected");
                            message.filters = [];
                            for (var i = 0; i < object.filters.length; ++i) {
                                if (typeof object.filters[i] !== "object")
                                    throw TypeError(".google.datastore.v1.CompositeFilter.filters: object expected");
                                message.filters[i] = $root.google.datastore.v1.Filter.fromObject(object.filters[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a CompositeFilter message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.CompositeFilter
                     * @static
                     * @param {google.datastore.v1.CompositeFilter} message CompositeFilter
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    CompositeFilter.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.filters = [];
                        if (options.defaults)
                            object.op = options.enums === String ? "OPERATOR_UNSPECIFIED" : 0;
                        if (message.op != null && message.hasOwnProperty("op"))
                            object.op = options.enums === String ? $root.google.datastore.v1.CompositeFilter.Operator[message.op] : message.op;
                        if (message.filters && message.filters.length) {
                            object.filters = [];
                            for (var j = 0; j < message.filters.length; ++j)
                                object.filters[j] = $root.google.datastore.v1.Filter.toObject(message.filters[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this CompositeFilter to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.CompositeFilter
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    CompositeFilter.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Operator enum.
                     * @name google.datastore.v1.CompositeFilter.Operator
                     * @enum {number}
                     * @property {number} OPERATOR_UNSPECIFIED=0 OPERATOR_UNSPECIFIED value
                     * @property {number} AND=1 AND value
                     */
                    CompositeFilter.Operator = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "OPERATOR_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "AND"] = 1;
                        return values;
                    })();
    
                    return CompositeFilter;
                })();
    
                v1.PropertyFilter = (function() {
    
                    /**
                     * Properties of a PropertyFilter.
                     * @memberof google.datastore.v1
                     * @interface IPropertyFilter
                     * @property {google.datastore.v1.IPropertyReference|null} [property] PropertyFilter property
                     * @property {google.datastore.v1.PropertyFilter.Operator|null} [op] PropertyFilter op
                     * @property {google.datastore.v1.IValue|null} [value] PropertyFilter value
                     */
    
                    /**
                     * Constructs a new PropertyFilter.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a PropertyFilter.
                     * @implements IPropertyFilter
                     * @constructor
                     * @param {google.datastore.v1.IPropertyFilter=} [properties] Properties to set
                     */
                    function PropertyFilter(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PropertyFilter property.
                     * @member {google.datastore.v1.IPropertyReference|null|undefined} property
                     * @memberof google.datastore.v1.PropertyFilter
                     * @instance
                     */
                    PropertyFilter.prototype.property = null;
    
                    /**
                     * PropertyFilter op.
                     * @member {google.datastore.v1.PropertyFilter.Operator} op
                     * @memberof google.datastore.v1.PropertyFilter
                     * @instance
                     */
                    PropertyFilter.prototype.op = 0;
    
                    /**
                     * PropertyFilter value.
                     * @member {google.datastore.v1.IValue|null|undefined} value
                     * @memberof google.datastore.v1.PropertyFilter
                     * @instance
                     */
                    PropertyFilter.prototype.value = null;
    
                    /**
                     * Creates a new PropertyFilter instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {google.datastore.v1.IPropertyFilter=} [properties] Properties to set
                     * @returns {google.datastore.v1.PropertyFilter} PropertyFilter instance
                     */
                    PropertyFilter.create = function create(properties) {
                        return new PropertyFilter(properties);
                    };
    
                    /**
                     * Encodes the specified PropertyFilter message. Does not implicitly {@link google.datastore.v1.PropertyFilter.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {google.datastore.v1.IPropertyFilter} message PropertyFilter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PropertyFilter.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.property != null && Object.hasOwnProperty.call(message, "property"))
                            $root.google.datastore.v1.PropertyReference.encode(message.property, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.op != null && Object.hasOwnProperty.call(message, "op"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.op);
                        if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                            $root.google.datastore.v1.Value.encode(message.value, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PropertyFilter message, length delimited. Does not implicitly {@link google.datastore.v1.PropertyFilter.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {google.datastore.v1.IPropertyFilter} message PropertyFilter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PropertyFilter.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PropertyFilter message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.PropertyFilter} PropertyFilter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PropertyFilter.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.PropertyFilter();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.property = $root.google.datastore.v1.PropertyReference.decode(reader, reader.uint32());
                                break;
                            case 2:
                                message.op = reader.int32();
                                break;
                            case 3:
                                message.value = $root.google.datastore.v1.Value.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PropertyFilter message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.PropertyFilter} PropertyFilter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PropertyFilter.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PropertyFilter message.
                     * @function verify
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PropertyFilter.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.property != null && message.hasOwnProperty("property")) {
                            var error = $root.google.datastore.v1.PropertyReference.verify(message.property);
                            if (error)
                                return "property." + error;
                        }
                        if (message.op != null && message.hasOwnProperty("op"))
                            switch (message.op) {
                            default:
                                return "op: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                            case 5:
                            case 11:
                                break;
                            }
                        if (message.value != null && message.hasOwnProperty("value")) {
                            var error = $root.google.datastore.v1.Value.verify(message.value);
                            if (error)
                                return "value." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PropertyFilter message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.PropertyFilter} PropertyFilter
                     */
                    PropertyFilter.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.PropertyFilter)
                            return object;
                        var message = new $root.google.datastore.v1.PropertyFilter();
                        if (object.property != null) {
                            if (typeof object.property !== "object")
                                throw TypeError(".google.datastore.v1.PropertyFilter.property: object expected");
                            message.property = $root.google.datastore.v1.PropertyReference.fromObject(object.property);
                        }
                        switch (object.op) {
                        case "OPERATOR_UNSPECIFIED":
                        case 0:
                            message.op = 0;
                            break;
                        case "LESS_THAN":
                        case 1:
                            message.op = 1;
                            break;
                        case "LESS_THAN_OR_EQUAL":
                        case 2:
                            message.op = 2;
                            break;
                        case "GREATER_THAN":
                        case 3:
                            message.op = 3;
                            break;
                        case "GREATER_THAN_OR_EQUAL":
                        case 4:
                            message.op = 4;
                            break;
                        case "EQUAL":
                        case 5:
                            message.op = 5;
                            break;
                        case "HAS_ANCESTOR":
                        case 11:
                            message.op = 11;
                            break;
                        }
                        if (object.value != null) {
                            if (typeof object.value !== "object")
                                throw TypeError(".google.datastore.v1.PropertyFilter.value: object expected");
                            message.value = $root.google.datastore.v1.Value.fromObject(object.value);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PropertyFilter message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.PropertyFilter
                     * @static
                     * @param {google.datastore.v1.PropertyFilter} message PropertyFilter
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PropertyFilter.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.property = null;
                            object.op = options.enums === String ? "OPERATOR_UNSPECIFIED" : 0;
                            object.value = null;
                        }
                        if (message.property != null && message.hasOwnProperty("property"))
                            object.property = $root.google.datastore.v1.PropertyReference.toObject(message.property, options);
                        if (message.op != null && message.hasOwnProperty("op"))
                            object.op = options.enums === String ? $root.google.datastore.v1.PropertyFilter.Operator[message.op] : message.op;
                        if (message.value != null && message.hasOwnProperty("value"))
                            object.value = $root.google.datastore.v1.Value.toObject(message.value, options);
                        return object;
                    };
    
                    /**
                     * Converts this PropertyFilter to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.PropertyFilter
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PropertyFilter.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Operator enum.
                     * @name google.datastore.v1.PropertyFilter.Operator
                     * @enum {number}
                     * @property {number} OPERATOR_UNSPECIFIED=0 OPERATOR_UNSPECIFIED value
                     * @property {number} LESS_THAN=1 LESS_THAN value
                     * @property {number} LESS_THAN_OR_EQUAL=2 LESS_THAN_OR_EQUAL value
                     * @property {number} GREATER_THAN=3 GREATER_THAN value
                     * @property {number} GREATER_THAN_OR_EQUAL=4 GREATER_THAN_OR_EQUAL value
                     * @property {number} EQUAL=5 EQUAL value
                     * @property {number} HAS_ANCESTOR=11 HAS_ANCESTOR value
                     */
                    PropertyFilter.Operator = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "OPERATOR_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "LESS_THAN"] = 1;
                        values[valuesById[2] = "LESS_THAN_OR_EQUAL"] = 2;
                        values[valuesById[3] = "GREATER_THAN"] = 3;
                        values[valuesById[4] = "GREATER_THAN_OR_EQUAL"] = 4;
                        values[valuesById[5] = "EQUAL"] = 5;
                        values[valuesById[11] = "HAS_ANCESTOR"] = 11;
                        return values;
                    })();
    
                    return PropertyFilter;
                })();
    
                v1.GqlQuery = (function() {
    
                    /**
                     * Properties of a GqlQuery.
                     * @memberof google.datastore.v1
                     * @interface IGqlQuery
                     * @property {string|null} [queryString] GqlQuery queryString
                     * @property {boolean|null} [allowLiterals] GqlQuery allowLiterals
                     * @property {Object.<string,google.datastore.v1.IGqlQueryParameter>|null} [namedBindings] GqlQuery namedBindings
                     * @property {Array.<google.datastore.v1.IGqlQueryParameter>|null} [positionalBindings] GqlQuery positionalBindings
                     */
    
                    /**
                     * Constructs a new GqlQuery.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a GqlQuery.
                     * @implements IGqlQuery
                     * @constructor
                     * @param {google.datastore.v1.IGqlQuery=} [properties] Properties to set
                     */
                    function GqlQuery(properties) {
                        this.namedBindings = {};
                        this.positionalBindings = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GqlQuery queryString.
                     * @member {string} queryString
                     * @memberof google.datastore.v1.GqlQuery
                     * @instance
                     */
                    GqlQuery.prototype.queryString = "";
    
                    /**
                     * GqlQuery allowLiterals.
                     * @member {boolean} allowLiterals
                     * @memberof google.datastore.v1.GqlQuery
                     * @instance
                     */
                    GqlQuery.prototype.allowLiterals = false;
    
                    /**
                     * GqlQuery namedBindings.
                     * @member {Object.<string,google.datastore.v1.IGqlQueryParameter>} namedBindings
                     * @memberof google.datastore.v1.GqlQuery
                     * @instance
                     */
                    GqlQuery.prototype.namedBindings = $util.emptyObject;
    
                    /**
                     * GqlQuery positionalBindings.
                     * @member {Array.<google.datastore.v1.IGqlQueryParameter>} positionalBindings
                     * @memberof google.datastore.v1.GqlQuery
                     * @instance
                     */
                    GqlQuery.prototype.positionalBindings = $util.emptyArray;
    
                    /**
                     * Creates a new GqlQuery instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {google.datastore.v1.IGqlQuery=} [properties] Properties to set
                     * @returns {google.datastore.v1.GqlQuery} GqlQuery instance
                     */
                    GqlQuery.create = function create(properties) {
                        return new GqlQuery(properties);
                    };
    
                    /**
                     * Encodes the specified GqlQuery message. Does not implicitly {@link google.datastore.v1.GqlQuery.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {google.datastore.v1.IGqlQuery} message GqlQuery message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GqlQuery.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.queryString != null && Object.hasOwnProperty.call(message, "queryString"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.queryString);
                        if (message.allowLiterals != null && Object.hasOwnProperty.call(message, "allowLiterals"))
                            writer.uint32(/* id 2, wireType 0 =*/16).bool(message.allowLiterals);
                        if (message.positionalBindings != null && message.positionalBindings.length)
                            for (var i = 0; i < message.positionalBindings.length; ++i)
                                $root.google.datastore.v1.GqlQueryParameter.encode(message.positionalBindings[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.namedBindings != null && Object.hasOwnProperty.call(message, "namedBindings"))
                            for (var keys = Object.keys(message.namedBindings), i = 0; i < keys.length; ++i) {
                                writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                                $root.google.datastore.v1.GqlQueryParameter.encode(message.namedBindings[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                            }
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GqlQuery message, length delimited. Does not implicitly {@link google.datastore.v1.GqlQuery.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {google.datastore.v1.IGqlQuery} message GqlQuery message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GqlQuery.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GqlQuery message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.GqlQuery} GqlQuery
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GqlQuery.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.GqlQuery(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.queryString = reader.string();
                                break;
                            case 2:
                                message.allowLiterals = reader.bool();
                                break;
                            case 5:
                                if (message.namedBindings === $util.emptyObject)
                                    message.namedBindings = {};
                                var end2 = reader.uint32() + reader.pos;
                                key = "";
                                value = null;
                                while (reader.pos < end2) {
                                    var tag2 = reader.uint32();
                                    switch (tag2 >>> 3) {
                                    case 1:
                                        key = reader.string();
                                        break;
                                    case 2:
                                        value = $root.google.datastore.v1.GqlQueryParameter.decode(reader, reader.uint32());
                                        break;
                                    default:
                                        reader.skipType(tag2 & 7);
                                        break;
                                    }
                                }
                                message.namedBindings[key] = value;
                                break;
                            case 4:
                                if (!(message.positionalBindings && message.positionalBindings.length))
                                    message.positionalBindings = [];
                                message.positionalBindings.push($root.google.datastore.v1.GqlQueryParameter.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GqlQuery message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.GqlQuery} GqlQuery
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GqlQuery.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GqlQuery message.
                     * @function verify
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GqlQuery.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.queryString != null && message.hasOwnProperty("queryString"))
                            if (!$util.isString(message.queryString))
                                return "queryString: string expected";
                        if (message.allowLiterals != null && message.hasOwnProperty("allowLiterals"))
                            if (typeof message.allowLiterals !== "boolean")
                                return "allowLiterals: boolean expected";
                        if (message.namedBindings != null && message.hasOwnProperty("namedBindings")) {
                            if (!$util.isObject(message.namedBindings))
                                return "namedBindings: object expected";
                            var key = Object.keys(message.namedBindings);
                            for (var i = 0; i < key.length; ++i) {
                                var error = $root.google.datastore.v1.GqlQueryParameter.verify(message.namedBindings[key[i]]);
                                if (error)
                                    return "namedBindings." + error;
                            }
                        }
                        if (message.positionalBindings != null && message.hasOwnProperty("positionalBindings")) {
                            if (!Array.isArray(message.positionalBindings))
                                return "positionalBindings: array expected";
                            for (var i = 0; i < message.positionalBindings.length; ++i) {
                                var error = $root.google.datastore.v1.GqlQueryParameter.verify(message.positionalBindings[i]);
                                if (error)
                                    return "positionalBindings." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a GqlQuery message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.GqlQuery} GqlQuery
                     */
                    GqlQuery.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.GqlQuery)
                            return object;
                        var message = new $root.google.datastore.v1.GqlQuery();
                        if (object.queryString != null)
                            message.queryString = String(object.queryString);
                        if (object.allowLiterals != null)
                            message.allowLiterals = Boolean(object.allowLiterals);
                        if (object.namedBindings) {
                            if (typeof object.namedBindings !== "object")
                                throw TypeError(".google.datastore.v1.GqlQuery.namedBindings: object expected");
                            message.namedBindings = {};
                            for (var keys = Object.keys(object.namedBindings), i = 0; i < keys.length; ++i) {
                                if (typeof object.namedBindings[keys[i]] !== "object")
                                    throw TypeError(".google.datastore.v1.GqlQuery.namedBindings: object expected");
                                message.namedBindings[keys[i]] = $root.google.datastore.v1.GqlQueryParameter.fromObject(object.namedBindings[keys[i]]);
                            }
                        }
                        if (object.positionalBindings) {
                            if (!Array.isArray(object.positionalBindings))
                                throw TypeError(".google.datastore.v1.GqlQuery.positionalBindings: array expected");
                            message.positionalBindings = [];
                            for (var i = 0; i < object.positionalBindings.length; ++i) {
                                if (typeof object.positionalBindings[i] !== "object")
                                    throw TypeError(".google.datastore.v1.GqlQuery.positionalBindings: object expected");
                                message.positionalBindings[i] = $root.google.datastore.v1.GqlQueryParameter.fromObject(object.positionalBindings[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GqlQuery message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.GqlQuery
                     * @static
                     * @param {google.datastore.v1.GqlQuery} message GqlQuery
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GqlQuery.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.positionalBindings = [];
                        if (options.objects || options.defaults)
                            object.namedBindings = {};
                        if (options.defaults) {
                            object.queryString = "";
                            object.allowLiterals = false;
                        }
                        if (message.queryString != null && message.hasOwnProperty("queryString"))
                            object.queryString = message.queryString;
                        if (message.allowLiterals != null && message.hasOwnProperty("allowLiterals"))
                            object.allowLiterals = message.allowLiterals;
                        if (message.positionalBindings && message.positionalBindings.length) {
                            object.positionalBindings = [];
                            for (var j = 0; j < message.positionalBindings.length; ++j)
                                object.positionalBindings[j] = $root.google.datastore.v1.GqlQueryParameter.toObject(message.positionalBindings[j], options);
                        }
                        var keys2;
                        if (message.namedBindings && (keys2 = Object.keys(message.namedBindings)).length) {
                            object.namedBindings = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.namedBindings[keys2[j]] = $root.google.datastore.v1.GqlQueryParameter.toObject(message.namedBindings[keys2[j]], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this GqlQuery to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.GqlQuery
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GqlQuery.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return GqlQuery;
                })();
    
                v1.GqlQueryParameter = (function() {
    
                    /**
                     * Properties of a GqlQueryParameter.
                     * @memberof google.datastore.v1
                     * @interface IGqlQueryParameter
                     * @property {google.datastore.v1.IValue|null} [value] GqlQueryParameter value
                     * @property {Uint8Array|null} [cursor] GqlQueryParameter cursor
                     */
    
                    /**
                     * Constructs a new GqlQueryParameter.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a GqlQueryParameter.
                     * @implements IGqlQueryParameter
                     * @constructor
                     * @param {google.datastore.v1.IGqlQueryParameter=} [properties] Properties to set
                     */
                    function GqlQueryParameter(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GqlQueryParameter value.
                     * @member {google.datastore.v1.IValue|null|undefined} value
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @instance
                     */
                    GqlQueryParameter.prototype.value = null;
    
                    /**
                     * GqlQueryParameter cursor.
                     * @member {Uint8Array} cursor
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @instance
                     */
                    GqlQueryParameter.prototype.cursor = $util.newBuffer([]);
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * GqlQueryParameter parameterType.
                     * @member {"value"|"cursor"|undefined} parameterType
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @instance
                     */
                    Object.defineProperty(GqlQueryParameter.prototype, "parameterType", {
                        get: $util.oneOfGetter($oneOfFields = ["value", "cursor"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new GqlQueryParameter instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {google.datastore.v1.IGqlQueryParameter=} [properties] Properties to set
                     * @returns {google.datastore.v1.GqlQueryParameter} GqlQueryParameter instance
                     */
                    GqlQueryParameter.create = function create(properties) {
                        return new GqlQueryParameter(properties);
                    };
    
                    /**
                     * Encodes the specified GqlQueryParameter message. Does not implicitly {@link google.datastore.v1.GqlQueryParameter.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {google.datastore.v1.IGqlQueryParameter} message GqlQueryParameter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GqlQueryParameter.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                            $root.google.datastore.v1.Value.encode(message.value, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.cursor != null && Object.hasOwnProperty.call(message, "cursor"))
                            writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.cursor);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GqlQueryParameter message, length delimited. Does not implicitly {@link google.datastore.v1.GqlQueryParameter.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {google.datastore.v1.IGqlQueryParameter} message GqlQueryParameter message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GqlQueryParameter.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GqlQueryParameter message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.GqlQueryParameter} GqlQueryParameter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GqlQueryParameter.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.GqlQueryParameter();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 2:
                                message.value = $root.google.datastore.v1.Value.decode(reader, reader.uint32());
                                break;
                            case 3:
                                message.cursor = reader.bytes();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GqlQueryParameter message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.GqlQueryParameter} GqlQueryParameter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GqlQueryParameter.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GqlQueryParameter message.
                     * @function verify
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GqlQueryParameter.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.value != null && message.hasOwnProperty("value")) {
                            properties.parameterType = 1;
                            {
                                var error = $root.google.datastore.v1.Value.verify(message.value);
                                if (error)
                                    return "value." + error;
                            }
                        }
                        if (message.cursor != null && message.hasOwnProperty("cursor")) {
                            if (properties.parameterType === 1)
                                return "parameterType: multiple values";
                            properties.parameterType = 1;
                            if (!(message.cursor && typeof message.cursor.length === "number" || $util.isString(message.cursor)))
                                return "cursor: buffer expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a GqlQueryParameter message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.GqlQueryParameter} GqlQueryParameter
                     */
                    GqlQueryParameter.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.GqlQueryParameter)
                            return object;
                        var message = new $root.google.datastore.v1.GqlQueryParameter();
                        if (object.value != null) {
                            if (typeof object.value !== "object")
                                throw TypeError(".google.datastore.v1.GqlQueryParameter.value: object expected");
                            message.value = $root.google.datastore.v1.Value.fromObject(object.value);
                        }
                        if (object.cursor != null)
                            if (typeof object.cursor === "string")
                                $util.base64.decode(object.cursor, message.cursor = $util.newBuffer($util.base64.length(object.cursor)), 0);
                            else if (object.cursor.length)
                                message.cursor = object.cursor;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GqlQueryParameter message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @static
                     * @param {google.datastore.v1.GqlQueryParameter} message GqlQueryParameter
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GqlQueryParameter.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (message.value != null && message.hasOwnProperty("value")) {
                            object.value = $root.google.datastore.v1.Value.toObject(message.value, options);
                            if (options.oneofs)
                                object.parameterType = "value";
                        }
                        if (message.cursor != null && message.hasOwnProperty("cursor")) {
                            object.cursor = options.bytes === String ? $util.base64.encode(message.cursor, 0, message.cursor.length) : options.bytes === Array ? Array.prototype.slice.call(message.cursor) : message.cursor;
                            if (options.oneofs)
                                object.parameterType = "cursor";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this GqlQueryParameter to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.GqlQueryParameter
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GqlQueryParameter.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return GqlQueryParameter;
                })();
    
                v1.QueryResultBatch = (function() {
    
                    /**
                     * Properties of a QueryResultBatch.
                     * @memberof google.datastore.v1
                     * @interface IQueryResultBatch
                     * @property {number|null} [skippedResults] QueryResultBatch skippedResults
                     * @property {Uint8Array|null} [skippedCursor] QueryResultBatch skippedCursor
                     * @property {google.datastore.v1.EntityResult.ResultType|null} [entityResultType] QueryResultBatch entityResultType
                     * @property {Array.<google.datastore.v1.IEntityResult>|null} [entityResults] QueryResultBatch entityResults
                     * @property {Uint8Array|null} [endCursor] QueryResultBatch endCursor
                     * @property {google.datastore.v1.QueryResultBatch.MoreResultsType|null} [moreResults] QueryResultBatch moreResults
                     * @property {number|Long|null} [snapshotVersion] QueryResultBatch snapshotVersion
                     */
    
                    /**
                     * Constructs a new QueryResultBatch.
                     * @memberof google.datastore.v1
                     * @classdesc Represents a QueryResultBatch.
                     * @implements IQueryResultBatch
                     * @constructor
                     * @param {google.datastore.v1.IQueryResultBatch=} [properties] Properties to set
                     */
                    function QueryResultBatch(properties) {
                        this.entityResults = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * QueryResultBatch skippedResults.
                     * @member {number} skippedResults
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     */
                    QueryResultBatch.prototype.skippedResults = 0;
    
                    /**
                     * QueryResultBatch skippedCursor.
                     * @member {Uint8Array} skippedCursor
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     */
                    QueryResultBatch.prototype.skippedCursor = $util.newBuffer([]);
    
                    /**
                     * QueryResultBatch entityResultType.
                     * @member {google.datastore.v1.EntityResult.ResultType} entityResultType
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     */
                    QueryResultBatch.prototype.entityResultType = 0;
    
                    /**
                     * QueryResultBatch entityResults.
                     * @member {Array.<google.datastore.v1.IEntityResult>} entityResults
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     */
                    QueryResultBatch.prototype.entityResults = $util.emptyArray;
    
                    /**
                     * QueryResultBatch endCursor.
                     * @member {Uint8Array} endCursor
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     */
                    QueryResultBatch.prototype.endCursor = $util.newBuffer([]);
    
                    /**
                     * QueryResultBatch moreResults.
                     * @member {google.datastore.v1.QueryResultBatch.MoreResultsType} moreResults
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     */
                    QueryResultBatch.prototype.moreResults = 0;
    
                    /**
                     * QueryResultBatch snapshotVersion.
                     * @member {number|Long} snapshotVersion
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     */
                    QueryResultBatch.prototype.snapshotVersion = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * Creates a new QueryResultBatch instance using the specified properties.
                     * @function create
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {google.datastore.v1.IQueryResultBatch=} [properties] Properties to set
                     * @returns {google.datastore.v1.QueryResultBatch} QueryResultBatch instance
                     */
                    QueryResultBatch.create = function create(properties) {
                        return new QueryResultBatch(properties);
                    };
    
                    /**
                     * Encodes the specified QueryResultBatch message. Does not implicitly {@link google.datastore.v1.QueryResultBatch.verify|verify} messages.
                     * @function encode
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {google.datastore.v1.IQueryResultBatch} message QueryResultBatch message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    QueryResultBatch.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.entityResultType != null && Object.hasOwnProperty.call(message, "entityResultType"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.entityResultType);
                        if (message.entityResults != null && message.entityResults.length)
                            for (var i = 0; i < message.entityResults.length; ++i)
                                $root.google.datastore.v1.EntityResult.encode(message.entityResults[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.skippedCursor != null && Object.hasOwnProperty.call(message, "skippedCursor"))
                            writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.skippedCursor);
                        if (message.endCursor != null && Object.hasOwnProperty.call(message, "endCursor"))
                            writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.endCursor);
                        if (message.moreResults != null && Object.hasOwnProperty.call(message, "moreResults"))
                            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.moreResults);
                        if (message.skippedResults != null && Object.hasOwnProperty.call(message, "skippedResults"))
                            writer.uint32(/* id 6, wireType 0 =*/48).int32(message.skippedResults);
                        if (message.snapshotVersion != null && Object.hasOwnProperty.call(message, "snapshotVersion"))
                            writer.uint32(/* id 7, wireType 0 =*/56).int64(message.snapshotVersion);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified QueryResultBatch message, length delimited. Does not implicitly {@link google.datastore.v1.QueryResultBatch.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {google.datastore.v1.IQueryResultBatch} message QueryResultBatch message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    QueryResultBatch.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a QueryResultBatch message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.datastore.v1.QueryResultBatch} QueryResultBatch
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    QueryResultBatch.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.datastore.v1.QueryResultBatch();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 6:
                                message.skippedResults = reader.int32();
                                break;
                            case 3:
                                message.skippedCursor = reader.bytes();
                                break;
                            case 1:
                                message.entityResultType = reader.int32();
                                break;
                            case 2:
                                if (!(message.entityResults && message.entityResults.length))
                                    message.entityResults = [];
                                message.entityResults.push($root.google.datastore.v1.EntityResult.decode(reader, reader.uint32()));
                                break;
                            case 4:
                                message.endCursor = reader.bytes();
                                break;
                            case 5:
                                message.moreResults = reader.int32();
                                break;
                            case 7:
                                message.snapshotVersion = reader.int64();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a QueryResultBatch message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.datastore.v1.QueryResultBatch} QueryResultBatch
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    QueryResultBatch.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a QueryResultBatch message.
                     * @function verify
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    QueryResultBatch.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.skippedResults != null && message.hasOwnProperty("skippedResults"))
                            if (!$util.isInteger(message.skippedResults))
                                return "skippedResults: integer expected";
                        if (message.skippedCursor != null && message.hasOwnProperty("skippedCursor"))
                            if (!(message.skippedCursor && typeof message.skippedCursor.length === "number" || $util.isString(message.skippedCursor)))
                                return "skippedCursor: buffer expected";
                        if (message.entityResultType != null && message.hasOwnProperty("entityResultType"))
                            switch (message.entityResultType) {
                            default:
                                return "entityResultType: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                                break;
                            }
                        if (message.entityResults != null && message.hasOwnProperty("entityResults")) {
                            if (!Array.isArray(message.entityResults))
                                return "entityResults: array expected";
                            for (var i = 0; i < message.entityResults.length; ++i) {
                                var error = $root.google.datastore.v1.EntityResult.verify(message.entityResults[i]);
                                if (error)
                                    return "entityResults." + error;
                            }
                        }
                        if (message.endCursor != null && message.hasOwnProperty("endCursor"))
                            if (!(message.endCursor && typeof message.endCursor.length === "number" || $util.isString(message.endCursor)))
                                return "endCursor: buffer expected";
                        if (message.moreResults != null && message.hasOwnProperty("moreResults"))
                            switch (message.moreResults) {
                            default:
                                return "moreResults: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 4:
                            case 3:
                                break;
                            }
                        if (message.snapshotVersion != null && message.hasOwnProperty("snapshotVersion"))
                            if (!$util.isInteger(message.snapshotVersion) && !(message.snapshotVersion && $util.isInteger(message.snapshotVersion.low) && $util.isInteger(message.snapshotVersion.high)))
                                return "snapshotVersion: integer|Long expected";
                        return null;
                    };
    
                    /**
                     * Creates a QueryResultBatch message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.datastore.v1.QueryResultBatch} QueryResultBatch
                     */
                    QueryResultBatch.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.datastore.v1.QueryResultBatch)
                            return object;
                        var message = new $root.google.datastore.v1.QueryResultBatch();
                        if (object.skippedResults != null)
                            message.skippedResults = object.skippedResults | 0;
                        if (object.skippedCursor != null)
                            if (typeof object.skippedCursor === "string")
                                $util.base64.decode(object.skippedCursor, message.skippedCursor = $util.newBuffer($util.base64.length(object.skippedCursor)), 0);
                            else if (object.skippedCursor.length)
                                message.skippedCursor = object.skippedCursor;
                        switch (object.entityResultType) {
                        case "RESULT_TYPE_UNSPECIFIED":
                        case 0:
                            message.entityResultType = 0;
                            break;
                        case "FULL":
                        case 1:
                            message.entityResultType = 1;
                            break;
                        case "PROJECTION":
                        case 2:
                            message.entityResultType = 2;
                            break;
                        case "KEY_ONLY":
                        case 3:
                            message.entityResultType = 3;
                            break;
                        }
                        if (object.entityResults) {
                            if (!Array.isArray(object.entityResults))
                                throw TypeError(".google.datastore.v1.QueryResultBatch.entityResults: array expected");
                            message.entityResults = [];
                            for (var i = 0; i < object.entityResults.length; ++i) {
                                if (typeof object.entityResults[i] !== "object")
                                    throw TypeError(".google.datastore.v1.QueryResultBatch.entityResults: object expected");
                                message.entityResults[i] = $root.google.datastore.v1.EntityResult.fromObject(object.entityResults[i]);
                            }
                        }
                        if (object.endCursor != null)
                            if (typeof object.endCursor === "string")
                                $util.base64.decode(object.endCursor, message.endCursor = $util.newBuffer($util.base64.length(object.endCursor)), 0);
                            else if (object.endCursor.length)
                                message.endCursor = object.endCursor;
                        switch (object.moreResults) {
                        case "MORE_RESULTS_TYPE_UNSPECIFIED":
                        case 0:
                            message.moreResults = 0;
                            break;
                        case "NOT_FINISHED":
                        case 1:
                            message.moreResults = 1;
                            break;
                        case "MORE_RESULTS_AFTER_LIMIT":
                        case 2:
                            message.moreResults = 2;
                            break;
                        case "MORE_RESULTS_AFTER_CURSOR":
                        case 4:
                            message.moreResults = 4;
                            break;
                        case "NO_MORE_RESULTS":
                        case 3:
                            message.moreResults = 3;
                            break;
                        }
                        if (object.snapshotVersion != null)
                            if ($util.Long)
                                (message.snapshotVersion = $util.Long.fromValue(object.snapshotVersion)).unsigned = false;
                            else if (typeof object.snapshotVersion === "string")
                                message.snapshotVersion = parseInt(object.snapshotVersion, 10);
                            else if (typeof object.snapshotVersion === "number")
                                message.snapshotVersion = object.snapshotVersion;
                            else if (typeof object.snapshotVersion === "object")
                                message.snapshotVersion = new $util.LongBits(object.snapshotVersion.low >>> 0, object.snapshotVersion.high >>> 0).toNumber();
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a QueryResultBatch message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @static
                     * @param {google.datastore.v1.QueryResultBatch} message QueryResultBatch
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    QueryResultBatch.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.entityResults = [];
                        if (options.defaults) {
                            object.entityResultType = options.enums === String ? "RESULT_TYPE_UNSPECIFIED" : 0;
                            if (options.bytes === String)
                                object.skippedCursor = "";
                            else {
                                object.skippedCursor = [];
                                if (options.bytes !== Array)
                                    object.skippedCursor = $util.newBuffer(object.skippedCursor);
                            }
                            if (options.bytes === String)
                                object.endCursor = "";
                            else {
                                object.endCursor = [];
                                if (options.bytes !== Array)
                                    object.endCursor = $util.newBuffer(object.endCursor);
                            }
                            object.moreResults = options.enums === String ? "MORE_RESULTS_TYPE_UNSPECIFIED" : 0;
                            object.skippedResults = 0;
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.snapshotVersion = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.snapshotVersion = options.longs === String ? "0" : 0;
                        }
                        if (message.entityResultType != null && message.hasOwnProperty("entityResultType"))
                            object.entityResultType = options.enums === String ? $root.google.datastore.v1.EntityResult.ResultType[message.entityResultType] : message.entityResultType;
                        if (message.entityResults && message.entityResults.length) {
                            object.entityResults = [];
                            for (var j = 0; j < message.entityResults.length; ++j)
                                object.entityResults[j] = $root.google.datastore.v1.EntityResult.toObject(message.entityResults[j], options);
                        }
                        if (message.skippedCursor != null && message.hasOwnProperty("skippedCursor"))
                            object.skippedCursor = options.bytes === String ? $util.base64.encode(message.skippedCursor, 0, message.skippedCursor.length) : options.bytes === Array ? Array.prototype.slice.call(message.skippedCursor) : message.skippedCursor;
                        if (message.endCursor != null && message.hasOwnProperty("endCursor"))
                            object.endCursor = options.bytes === String ? $util.base64.encode(message.endCursor, 0, message.endCursor.length) : options.bytes === Array ? Array.prototype.slice.call(message.endCursor) : message.endCursor;
                        if (message.moreResults != null && message.hasOwnProperty("moreResults"))
                            object.moreResults = options.enums === String ? $root.google.datastore.v1.QueryResultBatch.MoreResultsType[message.moreResults] : message.moreResults;
                        if (message.skippedResults != null && message.hasOwnProperty("skippedResults"))
                            object.skippedResults = message.skippedResults;
                        if (message.snapshotVersion != null && message.hasOwnProperty("snapshotVersion"))
                            if (typeof message.snapshotVersion === "number")
                                object.snapshotVersion = options.longs === String ? String(message.snapshotVersion) : message.snapshotVersion;
                            else
                                object.snapshotVersion = options.longs === String ? $util.Long.prototype.toString.call(message.snapshotVersion) : options.longs === Number ? new $util.LongBits(message.snapshotVersion.low >>> 0, message.snapshotVersion.high >>> 0).toNumber() : message.snapshotVersion;
                        return object;
                    };
    
                    /**
                     * Converts this QueryResultBatch to JSON.
                     * @function toJSON
                     * @memberof google.datastore.v1.QueryResultBatch
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    QueryResultBatch.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * MoreResultsType enum.
                     * @name google.datastore.v1.QueryResultBatch.MoreResultsType
                     * @enum {number}
                     * @property {number} MORE_RESULTS_TYPE_UNSPECIFIED=0 MORE_RESULTS_TYPE_UNSPECIFIED value
                     * @property {number} NOT_FINISHED=1 NOT_FINISHED value
                     * @property {number} MORE_RESULTS_AFTER_LIMIT=2 MORE_RESULTS_AFTER_LIMIT value
                     * @property {number} MORE_RESULTS_AFTER_CURSOR=4 MORE_RESULTS_AFTER_CURSOR value
                     * @property {number} NO_MORE_RESULTS=3 NO_MORE_RESULTS value
                     */
                    QueryResultBatch.MoreResultsType = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "MORE_RESULTS_TYPE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "NOT_FINISHED"] = 1;
                        values[valuesById[2] = "MORE_RESULTS_AFTER_LIMIT"] = 2;
                        values[valuesById[4] = "MORE_RESULTS_AFTER_CURSOR"] = 4;
                        values[valuesById[3] = "NO_MORE_RESULTS"] = 3;
                        return values;
                    })();
    
                    return QueryResultBatch;
                })();
    
                return v1;
            })();
    
            return datastore;
        })();
    
        google.api = (function() {
    
            /**
             * Namespace api.
             * @memberof google
             * @namespace
             */
            var api = {};
    
            api.Http = (function() {
    
                /**
                 * Properties of a Http.
                 * @memberof google.api
                 * @interface IHttp
                 * @property {Array.<google.api.IHttpRule>|null} [rules] Http rules
                 * @property {boolean|null} [fullyDecodeReservedExpansion] Http fullyDecodeReservedExpansion
                 */
    
                /**
                 * Constructs a new Http.
                 * @memberof google.api
                 * @classdesc Represents a Http.
                 * @implements IHttp
                 * @constructor
                 * @param {google.api.IHttp=} [properties] Properties to set
                 */
                function Http(properties) {
                    this.rules = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Http rules.
                 * @member {Array.<google.api.IHttpRule>} rules
                 * @memberof google.api.Http
                 * @instance
                 */
                Http.prototype.rules = $util.emptyArray;
    
                /**
                 * Http fullyDecodeReservedExpansion.
                 * @member {boolean} fullyDecodeReservedExpansion
                 * @memberof google.api.Http
                 * @instance
                 */
                Http.prototype.fullyDecodeReservedExpansion = false;
    
                /**
                 * Creates a new Http instance using the specified properties.
                 * @function create
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp=} [properties] Properties to set
                 * @returns {google.api.Http} Http instance
                 */
                Http.create = function create(properties) {
                    return new Http(properties);
                };
    
                /**
                 * Encodes the specified Http message. Does not implicitly {@link google.api.Http.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp} message Http message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Http.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.rules != null && message.rules.length)
                        for (var i = 0; i < message.rules.length; ++i)
                            $root.google.api.HttpRule.encode(message.rules[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.fullyDecodeReservedExpansion != null && Object.hasOwnProperty.call(message, "fullyDecodeReservedExpansion"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.fullyDecodeReservedExpansion);
                    return writer;
                };
    
                /**
                 * Encodes the specified Http message, length delimited. Does not implicitly {@link google.api.Http.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp} message Http message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Http.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a Http message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.Http
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.Http} Http
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Http.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.Http();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.rules && message.rules.length))
                                message.rules = [];
                            message.rules.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
                            break;
                        case 2:
                            message.fullyDecodeReservedExpansion = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a Http message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.Http
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.Http} Http
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Http.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a Http message.
                 * @function verify
                 * @memberof google.api.Http
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Http.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.rules != null && message.hasOwnProperty("rules")) {
                        if (!Array.isArray(message.rules))
                            return "rules: array expected";
                        for (var i = 0; i < message.rules.length; ++i) {
                            var error = $root.google.api.HttpRule.verify(message.rules[i]);
                            if (error)
                                return "rules." + error;
                        }
                    }
                    if (message.fullyDecodeReservedExpansion != null && message.hasOwnProperty("fullyDecodeReservedExpansion"))
                        if (typeof message.fullyDecodeReservedExpansion !== "boolean")
                            return "fullyDecodeReservedExpansion: boolean expected";
                    return null;
                };
    
                /**
                 * Creates a Http message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.Http
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.Http} Http
                 */
                Http.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.Http)
                        return object;
                    var message = new $root.google.api.Http();
                    if (object.rules) {
                        if (!Array.isArray(object.rules))
                            throw TypeError(".google.api.Http.rules: array expected");
                        message.rules = [];
                        for (var i = 0; i < object.rules.length; ++i) {
                            if (typeof object.rules[i] !== "object")
                                throw TypeError(".google.api.Http.rules: object expected");
                            message.rules[i] = $root.google.api.HttpRule.fromObject(object.rules[i]);
                        }
                    }
                    if (object.fullyDecodeReservedExpansion != null)
                        message.fullyDecodeReservedExpansion = Boolean(object.fullyDecodeReservedExpansion);
                    return message;
                };
    
                /**
                 * Creates a plain object from a Http message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.Http} message Http
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Http.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.rules = [];
                    if (options.defaults)
                        object.fullyDecodeReservedExpansion = false;
                    if (message.rules && message.rules.length) {
                        object.rules = [];
                        for (var j = 0; j < message.rules.length; ++j)
                            object.rules[j] = $root.google.api.HttpRule.toObject(message.rules[j], options);
                    }
                    if (message.fullyDecodeReservedExpansion != null && message.hasOwnProperty("fullyDecodeReservedExpansion"))
                        object.fullyDecodeReservedExpansion = message.fullyDecodeReservedExpansion;
                    return object;
                };
    
                /**
                 * Converts this Http to JSON.
                 * @function toJSON
                 * @memberof google.api.Http
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Http.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                return Http;
            })();
    
            api.HttpRule = (function() {
    
                /**
                 * Properties of a HttpRule.
                 * @memberof google.api
                 * @interface IHttpRule
                 * @property {string|null} [selector] HttpRule selector
                 * @property {string|null} [get] HttpRule get
                 * @property {string|null} [put] HttpRule put
                 * @property {string|null} [post] HttpRule post
                 * @property {string|null} ["delete"] HttpRule delete
                 * @property {string|null} [patch] HttpRule patch
                 * @property {google.api.ICustomHttpPattern|null} [custom] HttpRule custom
                 * @property {string|null} [body] HttpRule body
                 * @property {string|null} [responseBody] HttpRule responseBody
                 * @property {Array.<google.api.IHttpRule>|null} [additionalBindings] HttpRule additionalBindings
                 */
    
                /**
                 * Constructs a new HttpRule.
                 * @memberof google.api
                 * @classdesc Represents a HttpRule.
                 * @implements IHttpRule
                 * @constructor
                 * @param {google.api.IHttpRule=} [properties] Properties to set
                 */
                function HttpRule(properties) {
                    this.additionalBindings = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * HttpRule selector.
                 * @member {string} selector
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.selector = "";
    
                /**
                 * HttpRule get.
                 * @member {string} get
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.get = "";
    
                /**
                 * HttpRule put.
                 * @member {string} put
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.put = "";
    
                /**
                 * HttpRule post.
                 * @member {string} post
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.post = "";
    
                /**
                 * HttpRule delete.
                 * @member {string} delete
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype["delete"] = "";
    
                /**
                 * HttpRule patch.
                 * @member {string} patch
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.patch = "";
    
                /**
                 * HttpRule custom.
                 * @member {google.api.ICustomHttpPattern|null|undefined} custom
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.custom = null;
    
                /**
                 * HttpRule body.
                 * @member {string} body
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.body = "";
    
                /**
                 * HttpRule responseBody.
                 * @member {string} responseBody
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.responseBody = "";
    
                /**
                 * HttpRule additionalBindings.
                 * @member {Array.<google.api.IHttpRule>} additionalBindings
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.additionalBindings = $util.emptyArray;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * HttpRule pattern.
                 * @member {"get"|"put"|"post"|"delete"|"patch"|"custom"|undefined} pattern
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                Object.defineProperty(HttpRule.prototype, "pattern", {
                    get: $util.oneOfGetter($oneOfFields = ["get", "put", "post", "delete", "patch", "custom"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new HttpRule instance using the specified properties.
                 * @function create
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule=} [properties] Properties to set
                 * @returns {google.api.HttpRule} HttpRule instance
                 */
                HttpRule.create = function create(properties) {
                    return new HttpRule(properties);
                };
    
                /**
                 * Encodes the specified HttpRule message. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                HttpRule.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.selector != null && Object.hasOwnProperty.call(message, "selector"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.selector);
                    if (message.get != null && Object.hasOwnProperty.call(message, "get"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.get);
                    if (message.put != null && Object.hasOwnProperty.call(message, "put"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.put);
                    if (message.post != null && Object.hasOwnProperty.call(message, "post"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.post);
                    if (message["delete"] != null && Object.hasOwnProperty.call(message, "delete"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message["delete"]);
                    if (message.patch != null && Object.hasOwnProperty.call(message, "patch"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.patch);
                    if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                        writer.uint32(/* id 7, wireType 2 =*/58).string(message.body);
                    if (message.custom != null && Object.hasOwnProperty.call(message, "custom"))
                        $root.google.api.CustomHttpPattern.encode(message.custom, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.additionalBindings != null && message.additionalBindings.length)
                        for (var i = 0; i < message.additionalBindings.length; ++i)
                            $root.google.api.HttpRule.encode(message.additionalBindings[i], writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                    if (message.responseBody != null && Object.hasOwnProperty.call(message, "responseBody"))
                        writer.uint32(/* id 12, wireType 2 =*/98).string(message.responseBody);
                    return writer;
                };
    
                /**
                 * Encodes the specified HttpRule message, length delimited. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                HttpRule.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a HttpRule message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.HttpRule} HttpRule
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                HttpRule.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.HttpRule();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.selector = reader.string();
                            break;
                        case 2:
                            message.get = reader.string();
                            break;
                        case 3:
                            message.put = reader.string();
                            break;
                        case 4:
                            message.post = reader.string();
                            break;
                        case 5:
                            message["delete"] = reader.string();
                            break;
                        case 6:
                            message.patch = reader.string();
                            break;
                        case 8:
                            message.custom = $root.google.api.CustomHttpPattern.decode(reader, reader.uint32());
                            break;
                        case 7:
                            message.body = reader.string();
                            break;
                        case 12:
                            message.responseBody = reader.string();
                            break;
                        case 11:
                            if (!(message.additionalBindings && message.additionalBindings.length))
                                message.additionalBindings = [];
                            message.additionalBindings.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a HttpRule message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.HttpRule} HttpRule
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                HttpRule.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a HttpRule message.
                 * @function verify
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                HttpRule.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.selector != null && message.hasOwnProperty("selector"))
                        if (!$util.isString(message.selector))
                            return "selector: string expected";
                    if (message.get != null && message.hasOwnProperty("get")) {
                        properties.pattern = 1;
                        if (!$util.isString(message.get))
                            return "get: string expected";
                    }
                    if (message.put != null && message.hasOwnProperty("put")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.put))
                            return "put: string expected";
                    }
                    if (message.post != null && message.hasOwnProperty("post")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.post))
                            return "post: string expected";
                    }
                    if (message["delete"] != null && message.hasOwnProperty("delete")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message["delete"]))
                            return "delete: string expected";
                    }
                    if (message.patch != null && message.hasOwnProperty("patch")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.patch))
                            return "patch: string expected";
                    }
                    if (message.custom != null && message.hasOwnProperty("custom")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        {
                            var error = $root.google.api.CustomHttpPattern.verify(message.custom);
                            if (error)
                                return "custom." + error;
                        }
                    }
                    if (message.body != null && message.hasOwnProperty("body"))
                        if (!$util.isString(message.body))
                            return "body: string expected";
                    if (message.responseBody != null && message.hasOwnProperty("responseBody"))
                        if (!$util.isString(message.responseBody))
                            return "responseBody: string expected";
                    if (message.additionalBindings != null && message.hasOwnProperty("additionalBindings")) {
                        if (!Array.isArray(message.additionalBindings))
                            return "additionalBindings: array expected";
                        for (var i = 0; i < message.additionalBindings.length; ++i) {
                            var error = $root.google.api.HttpRule.verify(message.additionalBindings[i]);
                            if (error)
                                return "additionalBindings." + error;
                        }
                    }
                    return null;
                };
    
                /**
                 * Creates a HttpRule message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.HttpRule} HttpRule
                 */
                HttpRule.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.HttpRule)
                        return object;
                    var message = new $root.google.api.HttpRule();
                    if (object.selector != null)
                        message.selector = String(object.selector);
                    if (object.get != null)
                        message.get = String(object.get);
                    if (object.put != null)
                        message.put = String(object.put);
                    if (object.post != null)
                        message.post = String(object.post);
                    if (object["delete"] != null)
                        message["delete"] = String(object["delete"]);
                    if (object.patch != null)
                        message.patch = String(object.patch);
                    if (object.custom != null) {
                        if (typeof object.custom !== "object")
                            throw TypeError(".google.api.HttpRule.custom: object expected");
                        message.custom = $root.google.api.CustomHttpPattern.fromObject(object.custom);
                    }
                    if (object.body != null)
                        message.body = String(object.body);
                    if (object.responseBody != null)
                        message.responseBody = String(object.responseBody);
                    if (object.additionalBindings) {
                        if (!Array.isArray(object.additionalBindings))
                            throw TypeError(".google.api.HttpRule.additionalBindings: array expected");
                        message.additionalBindings = [];
                        for (var i = 0; i < object.additionalBindings.length; ++i) {
                            if (typeof object.additionalBindings[i] !== "object")
                                throw TypeError(".google.api.HttpRule.additionalBindings: object expected");
                            message.additionalBindings[i] = $root.google.api.HttpRule.fromObject(object.additionalBindings[i]);
                        }
                    }
                    return message;
                };
    
                /**
                 * Creates a plain object from a HttpRule message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.HttpRule} message HttpRule
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                HttpRule.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.additionalBindings = [];
                    if (options.defaults) {
                        object.selector = "";
                        object.body = "";
                        object.responseBody = "";
                    }
                    if (message.selector != null && message.hasOwnProperty("selector"))
                        object.selector = message.selector;
                    if (message.get != null && message.hasOwnProperty("get")) {
                        object.get = message.get;
                        if (options.oneofs)
                            object.pattern = "get";
                    }
                    if (message.put != null && message.hasOwnProperty("put")) {
                        object.put = message.put;
                        if (options.oneofs)
                            object.pattern = "put";
                    }
                    if (message.post != null && message.hasOwnProperty("post")) {
                        object.post = message.post;
                        if (options.oneofs)
                            object.pattern = "post";
                    }
                    if (message["delete"] != null && message.hasOwnProperty("delete")) {
                        object["delete"] = message["delete"];
                        if (options.oneofs)
                            object.pattern = "delete";
                    }
                    if (message.patch != null && message.hasOwnProperty("patch")) {
                        object.patch = message.patch;
                        if (options.oneofs)
                            object.pattern = "patch";
                    }
                    if (message.body != null && message.hasOwnProperty("body"))
                        object.body = message.body;
                    if (message.custom != null && message.hasOwnProperty("custom")) {
                        object.custom = $root.google.api.CustomHttpPattern.toObject(message.custom, options);
                        if (options.oneofs)
                            object.pattern = "custom";
                    }
                    if (message.additionalBindings && message.additionalBindings.length) {
                        object.additionalBindings = [];
                        for (var j = 0; j < message.additionalBindings.length; ++j)
                            object.additionalBindings[j] = $root.google.api.HttpRule.toObject(message.additionalBindings[j], options);
                    }
                    if (message.responseBody != null && message.hasOwnProperty("responseBody"))
                        object.responseBody = message.responseBody;
                    return object;
                };
    
                /**
                 * Converts this HttpRule to JSON.
                 * @function toJSON
                 * @memberof google.api.HttpRule
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                HttpRule.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                return HttpRule;
            })();
    
            api.CustomHttpPattern = (function() {
    
                /**
                 * Properties of a CustomHttpPattern.
                 * @memberof google.api
                 * @interface ICustomHttpPattern
                 * @property {string|null} [kind] CustomHttpPattern kind
                 * @property {string|null} [path] CustomHttpPattern path
                 */
    
                /**
                 * Constructs a new CustomHttpPattern.
                 * @memberof google.api
                 * @classdesc Represents a CustomHttpPattern.
                 * @implements ICustomHttpPattern
                 * @constructor
                 * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
                 */
                function CustomHttpPattern(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CustomHttpPattern kind.
                 * @member {string} kind
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 */
                CustomHttpPattern.prototype.kind = "";
    
                /**
                 * CustomHttpPattern path.
                 * @member {string} path
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 */
                CustomHttpPattern.prototype.path = "";
    
                /**
                 * Creates a new CustomHttpPattern instance using the specified properties.
                 * @function create
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern instance
                 */
                CustomHttpPattern.create = function create(properties) {
                    return new CustomHttpPattern(properties);
                };
    
                /**
                 * Encodes the specified CustomHttpPattern message. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CustomHttpPattern.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.kind);
                    if (message.path != null && Object.hasOwnProperty.call(message, "path"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.path);
                    return writer;
                };
    
                /**
                 * Encodes the specified CustomHttpPattern message, length delimited. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CustomHttpPattern.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a CustomHttpPattern message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CustomHttpPattern.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.CustomHttpPattern();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.kind = reader.string();
                            break;
                        case 2:
                            message.path = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a CustomHttpPattern message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CustomHttpPattern.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a CustomHttpPattern message.
                 * @function verify
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CustomHttpPattern.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        if (!$util.isString(message.kind))
                            return "kind: string expected";
                    if (message.path != null && message.hasOwnProperty("path"))
                        if (!$util.isString(message.path))
                            return "path: string expected";
                    return null;
                };
    
                /**
                 * Creates a CustomHttpPattern message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 */
                CustomHttpPattern.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.CustomHttpPattern)
                        return object;
                    var message = new $root.google.api.CustomHttpPattern();
                    if (object.kind != null)
                        message.kind = String(object.kind);
                    if (object.path != null)
                        message.path = String(object.path);
                    return message;
                };
    
                /**
                 * Creates a plain object from a CustomHttpPattern message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.CustomHttpPattern} message CustomHttpPattern
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                CustomHttpPattern.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.kind = "";
                        object.path = "";
                    }
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        object.kind = message.kind;
                    if (message.path != null && message.hasOwnProperty("path"))
                        object.path = message.path;
                    return object;
                };
    
                /**
                 * Converts this CustomHttpPattern to JSON.
                 * @function toJSON
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                CustomHttpPattern.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                return CustomHttpPattern;
            })();
    
            /**
             * FieldBehavior enum.
             * @name google.api.FieldBehavior
             * @enum {number}
             * @property {number} FIELD_BEHAVIOR_UNSPECIFIED=0 FIELD_BEHAVIOR_UNSPECIFIED value
             * @property {number} OPTIONAL=1 OPTIONAL value
             * @property {number} REQUIRED=2 REQUIRED value
             * @property {number} OUTPUT_ONLY=3 OUTPUT_ONLY value
             * @property {number} INPUT_ONLY=4 INPUT_ONLY value
             * @property {number} IMMUTABLE=5 IMMUTABLE value
             */
            api.FieldBehavior = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "FIELD_BEHAVIOR_UNSPECIFIED"] = 0;
                values[valuesById[1] = "OPTIONAL"] = 1;
                values[valuesById[2] = "REQUIRED"] = 2;
                values[valuesById[3] = "OUTPUT_ONLY"] = 3;
                values[valuesById[4] = "INPUT_ONLY"] = 4;
                values[valuesById[5] = "IMMUTABLE"] = 5;
                return values;
            })();
    
            return api;
        })();
    
        google.protobuf = (function() {
    
            /**
             * Namespace protobuf.
             * @memberof google
             * @namespace
             */
            var protobuf = {};
    
            protobuf.FileDescriptorSet = (function() {
    
                /**
                 * Properties of a FileDescriptorSet.
                 * @memberof google.protobuf
                 * @interface IFileDescriptorSet
                 * @property {Array.<google.protobuf.IFileDescriptorProto>|null} [file] FileDescriptorSet file
                 */
    
                /**
                 * Constructs a new FileDescriptorSet.
                 * @memberof google.protobuf
                 * @classdesc Represents a FileDescriptorSet.
                 * @implements IFileDescriptorSet
                 * @constructor
                 * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
                 */
                function FileDescriptorSet(properties) {
                    this.file = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * FileDescriptorSet file.
                 * @member {Array.<google.protobuf.IFileDescriptorProto>} file
                 * @memberof google.protobuf.FileDescriptorSet
                 * @instance
                 */
                FileDescriptorSet.prototype.file = $util.emptyArray;
    
                /**
                 * Creates a new FileDescriptorSet instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet instance
                 */
                FileDescriptorSet.create = function create(properties) {
                    return new FileDescriptorSet(properties);
                };
    
                /**
                 * Encodes the specified FileDescriptorSet message. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorSet.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.file != null && message.file.length)
                        for (var i = 0; i < message.file.length; ++i)
                            $root.google.protobuf.FileDescriptorProto.encode(message.file[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Encodes the specified FileDescriptorSet message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorSet.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a FileDescriptorSet message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorSet.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorSet();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.file && message.file.length))
                                message.file = [];
                            message.file.push($root.google.protobuf.FileDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a FileDescriptorSet message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorSet.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a FileDescriptorSet message.
                 * @function verify
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                FileDescriptorSet.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.file != null && message.hasOwnProperty("file")) {
                        if (!Array.isArray(message.file))
                            return "file: array expected";
                        for (var i = 0; i < message.file.length; ++i) {
                            var error = $root.google.protobuf.FileDescriptorProto.verify(message.file[i]);
                            if (error)
                                return "file." + error;
                        }
                    }
                    return null;
                };
    
                /**
                 * Creates a FileDescriptorSet message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
                 */
                FileDescriptorSet.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.FileDescriptorSet)
                        return object;
                    var message = new $root.google.protobuf.FileDescriptorSet();
                    if (object.file) {
                        if (!Array.isArray(object.file))
                            throw TypeError(".google.protobuf.FileDescriptorSet.file: array expected");
                        message.file = [];
                        for (var i = 0; i < object.file.length; ++i) {
                            if (typeof object.file[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorSet.file: object expected");
                            message.file[i] = $root.google.protobuf.FileDescriptorProto.fromObject(object.file[i]);
                        }
                    }
                    return message;
                };
    
                /**
                 * Creates a plain object from a FileDescriptorSet message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.FileDescriptorSet} message FileDescriptorSet
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                FileDescriptorSet.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.file = [];
                    if (message.file && message.file.length) {
                        object.file = [];
                        for (var j = 0; j < message.file.length; ++j)
                            object.file[j] = $root.google.protobuf.FileDescriptorProto.toObject(message.file[j], options);
                    }
                    return object;
                };
    
                /**
                 * Converts this FileDescriptorSet to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.FileDescriptorSet
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                FileDescriptorSet.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                return FileDescriptorSet;
            })();
    
            protobuf.FileDescriptorProto = (function() {
    
                /**
                 * Properties of a FileDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IFileDescriptorProto
                 * @property {string|null} [name] FileDescriptorProto name
                 * @property {string|null} ["package"] FileDescriptorProto package
                 * @property {Array.<string>|null} [dependency] FileDescriptorProto dependency
                 * @property {Array.<number>|null} [publicDependency] FileDescriptorProto publicDependency
                 * @property {Array.<number>|null} [weakDependency] FileDescriptorProto weakDependency
                 * @property {Array.<google.protobuf.IDescriptorProto>|null} [messageType] FileDescriptorProto messageType
                 * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] FileDescriptorProto enumType
                 * @property {Array.<google.protobuf.IServiceDescriptorProto>|null} [service] FileDescriptorProto service
                 * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] FileDescriptorProto extension
                 * @property {google.protobuf.IFileOptions|null} [options] FileDescriptorProto options
                 * @property {google.protobuf.ISourceCodeInfo|null} [sourceCodeInfo] FileDescriptorProto sourceCodeInfo
                 * @property {string|null} [syntax] FileDescriptorProto syntax
                 */
    
                /**
                 * Constructs a new FileDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents a FileDescriptorProto.
                 * @implements IFileDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
                 */
                function FileDescriptorProto(properties) {
                    this.dependency = [];
                    this.publicDependency = [];
                    this.weakDependency = [];
                    this.messageType = [];
                    this.enumType = [];
                    this.service = [];
                    this.extension = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * FileDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.name = "";
    
                /**
                 * FileDescriptorProto package.
                 * @member {string} package
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype["package"] = "";
    
                /**
                 * FileDescriptorProto dependency.
                 * @member {Array.<string>} dependency
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.dependency = $util.emptyArray;
    
                /**
                 * FileDescriptorProto publicDependency.
                 * @member {Array.<number>} publicDependency
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.publicDependency = $util.emptyArray;
    
                /**
                 * FileDescriptorProto weakDependency.
                 * @member {Array.<number>} weakDependency
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.weakDependency = $util.emptyArray;
    
                /**
                 * FileDescriptorProto messageType.
                 * @member {Array.<google.protobuf.IDescriptorProto>} messageType
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.messageType = $util.emptyArray;
    
                /**
                 * FileDescriptorProto enumType.
                 * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.enumType = $util.emptyArray;
    
                /**
                 * FileDescriptorProto service.
                 * @member {Array.<google.protobuf.IServiceDescriptorProto>} service
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.service = $util.emptyArray;
    
                /**
                 * FileDescriptorProto extension.
                 * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.extension = $util.emptyArray;
    
                /**
                 * FileDescriptorProto options.
                 * @member {google.protobuf.IFileOptions|null|undefined} options
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.options = null;
    
                /**
                 * FileDescriptorProto sourceCodeInfo.
                 * @member {google.protobuf.ISourceCodeInfo|null|undefined} sourceCodeInfo
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.sourceCodeInfo = null;
    
                /**
                 * FileDescriptorProto syntax.
                 * @member {string} syntax
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.syntax = "";
    
                /**
                 * Creates a new FileDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto instance
                 */
                FileDescriptorProto.create = function create(properties) {
                    return new FileDescriptorProto(properties);
                };
    
                /**
                 * Encodes the specified FileDescriptorProto message. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message["package"] != null && Object.hasOwnProperty.call(message, "package"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message["package"]);
                    if (message.dependency != null && message.dependency.length)
                        for (var i = 0; i < message.dependency.length; ++i)
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.dependency[i]);
                    if (message.messageType != null && message.messageType.length)
                        for (var i = 0; i < message.messageType.length; ++i)
                            $root.google.protobuf.DescriptorProto.encode(message.messageType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.enumType != null && message.enumType.length)
                        for (var i = 0; i < message.enumType.length; ++i)
                            $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.service != null && message.service.length)
                        for (var i = 0; i < message.service.length; ++i)
                            $root.google.protobuf.ServiceDescriptorProto.encode(message.service[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.extension != null && message.extension.length)
                        for (var i = 0; i < message.extension.length; ++i)
                            $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.FileOptions.encode(message.options, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.sourceCodeInfo != null && Object.hasOwnProperty.call(message, "sourceCodeInfo"))
                        $root.google.protobuf.SourceCodeInfo.encode(message.sourceCodeInfo, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.publicDependency != null && message.publicDependency.length)
                        for (var i = 0; i < message.publicDependency.length; ++i)
                            writer.uint32(/* id 10, wireType 0 =*/80).int32(message.publicDependency[i]);
                    if (message.weakDependency != null && message.weakDependency.length)
                        for (var i = 0; i < message.weakDependency.length; ++i)
                            writer.uint32(/* id 11, wireType 0 =*/88).int32(message.weakDependency[i]);
                    if (message.syntax != null && Object.hasOwnProperty.call(message, "syntax"))
                        writer.uint32(/* id 12, wireType 2 =*/98).string(message.syntax);
                    return writer;
                };
    
                /**
                 * Encodes the specified FileDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a FileDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            message["package"] = reader.string();
                            break;
                        case 3:
                            if (!(message.dependency && message.dependency.length))
                                message.dependency = [];
                            message.dependency.push(reader.string());
                            break;
                        case 10:
                            if (!(message.publicDependency && message.publicDependency.length))
                                message.publicDependency = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.publicDependency.push(reader.int32());
                            } else
                                message.publicDependency.push(reader.int32());
                            break;
                        case 11:
                            if (!(message.weakDependency && message.weakDependency.length))
                                message.weakDependency = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.weakDependency.push(reader.int32());
                            } else
                                message.weakDependency.push(reader.int32());
                            break;
                        case 4:
                            if (!(message.messageType && message.messageType.length))
                                message.messageType = [];
                            message.messageType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            if (!(message.enumType && message.enumType.length))
                                message.enumType = [];
                            message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 6:
                            if (!(message.service && message.service.length))
                                message.service = [];
                            message.service.push($root.google.protobuf.ServiceDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 7:
                            if (!(message.extension && message.extension.length))
                                message.extension = [];
                            message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 8:
                            message.options = $root.google.protobuf.FileOptions.decode(reader, reader.uint32());
                            break;
                        case 9:
                            message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.decode(reader, reader.uint32());
                            break;
                        case 12:
                            message.syntax = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a FileDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a FileDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                FileDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message["package"] != null && message.hasOwnProperty("package"))
                        if (!$util.isString(message["package"]))
                            return "package: string expected";
                    if (message.dependency != null && message.hasOwnProperty("dependency")) {
                        if (!Array.isArray(message.dependency))
                            return "dependency: array expected";
                        for (var i = 0; i < message.dependency.length; ++i)
                            if (!$util.isString(message.dependency[i]))
                                return "dependency: string[] expected";
                    }
                    if (message.publicDependency != null && message.hasOwnProperty("publicDependency")) {
                        if (!Array.isArray(message.publicDependency))
                            return "publicDependency: array expected";
                        for (var i = 0; i < message.publicDependency.length; ++i)
                            if (!$util.isInteger(message.publicDependency[i]))
                                return "publicDependency: integer[] expected";
                    }
                    if (message.weakDependency != null && message.hasOwnProperty("weakDependency")) {
                        if (!Array.isArray(message.weakDependency))
                            return "weakDependency: array expected";
                        for (var i = 0; i < message.weakDependency.length; ++i)
                            if (!$util.isInteger(message.weakDependency[i]))
                                return "weakDependency: integer[] expected";
                    }
                    if (message.messageType != null && message.hasOwnProperty("messageType")) {
                        if (!Array.isArray(message.messageType))
                            return "messageType: array expected";
                        for (var i = 0; i < message.messageType.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.verify(message.messageType[i]);
                            if (error)
                                return "messageType." + error;
                        }
                    }
                    if (message.enumType != null && message.hasOwnProperty("enumType")) {
                        if (!Array.isArray(message.enumType))
                            return "enumType: array expected";
                        for (var i = 0; i < message.enumType.length; ++i) {
                            var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
                            if (error)
                                return "enumType." + error;
                        }
                    }
                    if (message.service != null && message.hasOwnProperty("service")) {
                        if (!Array.isArray(message.service))
                            return "service: array expected";
                        for (var i = 0; i < message.service.length; ++i) {
                            var error = $root.google.protobuf.ServiceDescriptorProto.verify(message.service[i]);
                            if (error)
                                return "service." + error;
                        }
                    }
                    if (message.extension != null && message.hasOwnProperty("extension")) {
                        if (!Array.isArray(message.extension))
                            return "extension: array expected";
                        for (var i = 0; i < message.extension.length; ++i) {
                            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
                            if (error)
                                return "extension." + error;
                        }
                    }
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.FileOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo")) {
                        var error = $root.google.protobuf.SourceCodeInfo.verify(message.sourceCodeInfo);
                        if (error)
                            return "sourceCodeInfo." + error;
                    }
                    if (message.syntax != null && message.hasOwnProperty("syntax"))
                        if (!$util.isString(message.syntax))
                            return "syntax: string expected";
                    return null;
                };
    
                /**
                 * Creates a FileDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
                 */
                FileDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.FileDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.FileDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object["package"] != null)
                        message["package"] = String(object["package"]);
                    if (object.dependency) {
                        if (!Array.isArray(object.dependency))
                            throw TypeError(".google.protobuf.FileDescriptorProto.dependency: array expected");
                        message.dependency = [];
                        for (var i = 0; i < object.dependency.length; ++i)
                            message.dependency[i] = String(object.dependency[i]);
                    }
                    if (object.publicDependency) {
                        if (!Array.isArray(object.publicDependency))
                            throw TypeError(".google.protobuf.FileDescriptorProto.publicDependency: array expected");
                        message.publicDependency = [];
                        for (var i = 0; i < object.publicDependency.length; ++i)
                            message.publicDependency[i] = object.publicDependency[i] | 0;
                    }
                    if (object.weakDependency) {
                        if (!Array.isArray(object.weakDependency))
                            throw TypeError(".google.protobuf.FileDescriptorProto.weakDependency: array expected");
                        message.weakDependency = [];
                        for (var i = 0; i < object.weakDependency.length; ++i)
                            message.weakDependency[i] = object.weakDependency[i] | 0;
                    }
                    if (object.messageType) {
                        if (!Array.isArray(object.messageType))
                            throw TypeError(".google.protobuf.FileDescriptorProto.messageType: array expected");
                        message.messageType = [];
                        for (var i = 0; i < object.messageType.length; ++i) {
                            if (typeof object.messageType[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.messageType: object expected");
                            message.messageType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.messageType[i]);
                        }
                    }
                    if (object.enumType) {
                        if (!Array.isArray(object.enumType))
                            throw TypeError(".google.protobuf.FileDescriptorProto.enumType: array expected");
                        message.enumType = [];
                        for (var i = 0; i < object.enumType.length; ++i) {
                            if (typeof object.enumType[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.enumType: object expected");
                            message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
                        }
                    }
                    if (object.service) {
                        if (!Array.isArray(object.service))
                            throw TypeError(".google.protobuf.FileDescriptorProto.service: array expected");
                        message.service = [];
                        for (var i = 0; i < object.service.length; ++i) {
                            if (typeof object.service[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.service: object expected");
                            message.service[i] = $root.google.protobuf.ServiceDescriptorProto.fromObject(object.service[i]);
                        }
                    }
                    if (object.extension) {
                        if (!Array.isArray(object.extension))
                            throw TypeError(".google.protobuf.FileDescriptorProto.extension: array expected");
                        message.extension = [];
                        for (var i = 0; i < object.extension.length; ++i) {
                            if (typeof object.extension[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.extension: object expected");
                            message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
                        }
                    }
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.FileOptions.fromObject(object.options);
                    }
                    if (object.sourceCodeInfo != null) {
                        if (typeof object.sourceCodeInfo !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.sourceCodeInfo: object expected");
                        message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.fromObject(object.sourceCodeInfo);
                    }
                    if (object.syntax != null)
                        message.syntax = String(object.syntax);
                    return message;
                };
    
                /**
                 * Creates a plain object from a FileDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.FileDescriptorProto} message FileDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                FileDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.dependency = [];
                        object.messageType = [];
                        object.enumType = [];
                        object.service = [];
                        object.extension = [];
                        object.publicDependency = [];
                        object.weakDependency = [];
                    }
                    if (options.defaults) {
                        object.name = "";
                        object["package"] = "";
                        object.options = null;
                        object.sourceCodeInfo = null;
                        object.syntax = "";
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message["package"] != null && message.hasOwnProperty("package"))
                        object["package"] = message["package"];
                    if (message.dependency && message.dependency.length) {
                        object.dependency = [];
                        for (var j = 0; j < message.dependency.length; ++j)
                            object.dependency[j] = message.dependency[j];
                    }
                    if (message.messageType && message.messageType.length) {
                        object.messageType = [];
                        for (var j = 0; j < message.messageType.length; ++j)
                            object.messageType[j] = $root.google.protobuf.DescriptorProto.toObject(message.messageType[j], options);
                    }
                    if (message.enumType && message.enumType.length) {
                        object.enumType = [];
                        for (var j = 0; j < message.enumType.length; ++j)
                            object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
                    }
                    if (message.service && message.service.length) {
                        object.service = [];
                        for (var j = 0; j < message.service.length; ++j)
                            object.service[j] = $root.google.protobuf.ServiceDescriptorProto.toObject(message.service[j], options);
                    }
                    if (message.extension && message.extension.length) {
                        object.extension = [];
                        for (var j = 0; j < message.extension.length; ++j)
                            object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
                    }
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.FileOptions.toObject(message.options, options);
                    if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo"))
                        object.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.toObject(message.sourceCodeInfo, options);
                    if (message.publicDependency && message.publicDependency.length) {
                        object.publicDependency = [];
                        for (var j = 0; j < message.publicDependency.length; ++j)
                            object.publicDependency[j] = message.publicDependency[j];
                    }
                    if (message.weakDependency && message.weakDependency.length) {
                        object.weakDependency = [];
                        for (var j = 0; j < message.weakDependency.length; ++j)
                            object.weakDependency[j] = message.weakDependency[j];
                    }
                    if (message.syntax != null && message.hasOwnProperty("syntax"))
                        object.syntax = message.syntax;
                    return object;
                };
    
                /**
                 * Converts this FileDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                FileDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                return FileDescriptorProto;
            })();
    
            protobuf.DescriptorProto = (function() {
    
                /**
                 * Properties of a DescriptorProto.
                 * @memberof google.protobuf
                 * @interface IDescriptorProto
                 * @property {string|null} [name] DescriptorProto name
                 * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [field] DescriptorProto field
                 * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] DescriptorProto extension
                 * @property {Array.<google.protobuf.IDescriptorProto>|null} [nestedType] DescriptorProto nestedType
                 * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] DescriptorProto enumType
                 * @property {Array.<google.protobuf.DescriptorProto.IExtensionRange>|null} [extensionRange] DescriptorProto extensionRange
                 * @property {Array.<google.protobuf.IOneofDescriptorProto>|null} [oneofDecl] DescriptorProto oneofDecl
                 * @property {google.protobuf.IMessageOptions|null} [options] DescriptorProto options
                 * @property {Array.<google.protobuf.DescriptorProto.IReservedRange>|null} [reservedRange] DescriptorProto reservedRange
                 * @property {Array.<string>|null} [reservedName] DescriptorProto reservedName
                 */
    
                /**
                 * Constructs a new DescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents a DescriptorProto.
                 * @implements IDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
                 */
                function DescriptorProto(properties) {
                    this.field = [];
                    this.extension = [];
                    this.nestedType = [];
                    this.enumType = [];
                    this.extensionRange = [];
                    this.oneofDecl = [];
                    this.reservedRange = [];
                    this.reservedName = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * DescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.name = "";
    
                /**
                 * DescriptorProto field.
                 * @member {Array.<google.protobuf.IFieldDescriptorProto>} field
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.field = $util.emptyArray;
    
                /**
                 * DescriptorProto extension.
                 * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.extension = $util.emptyArray;
    
                /**
                 * DescriptorProto nestedType.
                 * @member {Array.<google.protobuf.IDescriptorProto>} nestedType
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.nestedType = $util.emptyArray;
    
                /**
                 * DescriptorProto enumType.
                 * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.enumType = $util.emptyArray;
    
                /**
                 * DescriptorProto extensionRange.
                 * @member {Array.<google.protobuf.DescriptorProto.IExtensionRange>} extensionRange
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.extensionRange = $util.emptyArray;
    
                /**
                 * DescriptorProto oneofDecl.
                 * @member {Array.<google.protobuf.IOneofDescriptorProto>} oneofDecl
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.oneofDecl = $util.emptyArray;
    
                /**
                 * DescriptorProto options.
                 * @member {google.protobuf.IMessageOptions|null|undefined} options
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.options = null;
    
                /**
                 * DescriptorProto reservedRange.
                 * @member {Array.<google.protobuf.DescriptorProto.IReservedRange>} reservedRange
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.reservedRange = $util.emptyArray;
    
                /**
                 * DescriptorProto reservedName.
                 * @member {Array.<string>} reservedName
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.reservedName = $util.emptyArray;
    
                /**
                 * Creates a new DescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto instance
                 */
                DescriptorProto.create = function create(properties) {
                    return new DescriptorProto(properties);
                };
    
                /**
                 * Encodes the specified DescriptorProto message. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                DescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.field != null && message.field.length)
                        for (var i = 0; i < message.field.length; ++i)
                            $root.google.protobuf.FieldDescriptorProto.encode(message.field[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.nestedType != null && message.nestedType.length)
                        for (var i = 0; i < message.nestedType.length; ++i)
                            $root.google.protobuf.DescriptorProto.encode(message.nestedType[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.enumType != null && message.enumType.length)
                        for (var i = 0; i < message.enumType.length; ++i)
                            $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.extensionRange != null && message.extensionRange.length)
                        for (var i = 0; i < message.extensionRange.length; ++i)
                            $root.google.protobuf.DescriptorProto.ExtensionRange.encode(message.extensionRange[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.extension != null && message.extension.length)
                        for (var i = 0; i < message.extension.length; ++i)
                            $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.MessageOptions.encode(message.options, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.oneofDecl != null && message.oneofDecl.length)
                        for (var i = 0; i < message.oneofDecl.length; ++i)
                            $root.google.protobuf.OneofDescriptorProto.encode(message.oneofDecl[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.reservedRange != null && message.reservedRange.length)
                        for (var i = 0; i < message.reservedRange.length; ++i)
                            $root.google.protobuf.DescriptorProto.ReservedRange.encode(message.reservedRange[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.reservedName != null && message.reservedName.length)
                        for (var i = 0; i < message.reservedName.length; ++i)
                            writer.uint32(/* id 10, wireType 2 =*/82).string(message.reservedName[i]);
                    return writer;
                };
    
                /**
                 * Encodes the specified DescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                DescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a DescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                DescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            if (!(message.field && message.field.length))
                                message.field = [];
                            message.field.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 6:
                            if (!(message.extension && message.extension.length))
                                message.extension = [];
                            message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            if (!(message.nestedType && message.nestedType.length))
                                message.nestedType = [];
                            message.nestedType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 4:
                            if (!(message.enumType && message.enumType.length))
                                message.enumType = [];
                            message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            if (!(message.extensionRange && message.extensionRange.length))
                                message.extensionRange = [];
                            message.extensionRange.push($root.google.protobuf.DescriptorProto.ExtensionRange.decode(reader, reader.uint32()));
                            break;
                        case 8:
                            if (!(message.oneofDecl && message.oneofDecl.length))
                                message.oneofDecl = [];
                            message.oneofDecl.push($root.google.protobuf.OneofDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 7:
                            message.options = $root.google.protobuf.MessageOptions.decode(reader, reader.uint32());
                            break;
                        case 9:
                            if (!(message.reservedRange && message.reservedRange.length))
                                message.reservedRange = [];
                            message.reservedRange.push($root.google.protobuf.DescriptorProto.ReservedRange.decode(reader, reader.uint32()));
                            break;
                        case 10:
                            if (!(message.reservedName && message.reservedName.length))
                                message.reservedName = [];
                            message.reservedName.push(reader.string());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a DescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                DescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a DescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                DescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.field != null && message.hasOwnProperty("field")) {
                        if (!Array.isArray(message.field))
                            return "field: array expected";
                        for (var i = 0; i < message.field.length; ++i) {
                            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.field[i]);
                            if (error)
                                return "field." + error;
                        }
                    }
                    if (message.extension != null && message.hasOwnProperty("extension")) {
                        if (!Array.isArray(message.extension))
                            return "extension: array expected";
                        for (var i = 0; i < message.extension.length; ++i) {
                            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
                            if (error)
                                return "extension." + error;
                        }
                    }
                    if (message.nestedType != null && message.hasOwnProperty("nestedType")) {
                        if (!Array.isArray(message.nestedType))
                            return "nestedType: array expected";
                        for (var i = 0; i < message.nestedType.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.verify(message.nestedType[i]);
                            if (error)
                                return "nestedType." + error;
                        }
                    }
                    if (message.enumType != null && message.hasOwnProperty("enumType")) {
                        if (!Array.isArray(message.enumType))
                            return "enumType: array expected";
                        for (var i = 0; i < message.enumType.length; ++i) {
                            var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
                            if (error)
                                return "enumType." + error;
                        }
                    }
                    if (message.extensionRange != null && message.hasOwnProperty("extensionRange")) {
                        if (!Array.isArray(message.extensionRange))
                            return "extensionRange: array expected";
                        for (var i = 0; i < message.extensionRange.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.ExtensionRange.verify(message.extensionRange[i]);
                            if (error)
                                return "extensionRange." + error;
                        }
                    }
                    if (message.oneofDecl != null && message.hasOwnProperty("oneofDecl")) {
                        if (!Array.isArray(message.oneofDecl))
                            return "oneofDecl: array expected";
                        for (var i = 0; i < message.oneofDecl.length; ++i) {
                            var error = $root.google.protobuf.OneofDescriptorProto.verify(message.oneofDecl[i]);
                            if (error)
                                return "oneofDecl." + error;
                        }
                    }
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.MessageOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    if (message.reservedRange != null && message.hasOwnProperty("reservedRange")) {
                        if (!Array.isArray(message.reservedRange))
                            return "reservedRange: array expected";
                        for (var i = 0; i < message.reservedRange.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.ReservedRange.verify(message.reservedRange[i]);
                            if (error)
                                return "reservedRange." + error;
                        }
                    }
                    if (message.reservedName != null && message.hasOwnProperty("reservedName")) {
                        if (!Array.isArray(message.reservedName))
                            return "reservedName: array expected";
                        for (var i = 0; i < message.reservedName.length; ++i)
                            if (!$util.isString(message.reservedName[i]))
                                return "reservedName: string[] expected";
                    }
                    return null;
                };
    
                /**
                 * Creates a DescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto
                 */
                DescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.DescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.DescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.field) {
                        if (!Array.isArray(object.field))
                            throw TypeError(".google.protobuf.DescriptorProto.field: array expected");
                        message.field = [];
                        for (var i = 0; i < object.field.length; ++i) {
                            if (typeof object.field[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.field: object expected");
                            message.field[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.field[i]);
                        }
                    }
                    if (object.extension) {
                        if (!Array.isArray(object.extension))
                            throw TypeError(".google.protobuf.DescriptorProto.extension: array expected");
                        message.extension = [];
                        for (var i = 0; i < object.extension.length; ++i) {
                            if (typeof object.extension[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.extension: object expected");
                            message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
                        }
                    }
                    if (object.nestedType) {
                        if (!Array.isArray(object.nestedType))
                            throw TypeError(".google.protobuf.DescriptorProto.nestedType: array expected");
                        message.nestedType = [];
                        for (var i = 0; i < object.nestedType.length; ++i) {
                            if (typeof object.nestedType[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.nestedType: object expected");
                            message.nestedType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.nestedType[i]);
                        }
                    }
                    if (object.enumType) {
                        if (!Array.isArray(object.enumType))
                            throw TypeError(".google.protobuf.DescriptorProto.enumType: array expected");
                        message.enumType = [];
                        for (var i = 0; i < object.enumType.length; ++i) {
                            if (typeof object.enumType[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.enumType: object expected");
                            message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
                        }
                    }
                    if (object.extensionRange) {
                        if (!Array.isArray(object.extensionRange))
                            throw TypeError(".google.protobuf.DescriptorProto.extensionRange: array expected");
                        message.extensionRange = [];
                        for (var i = 0; i < object.extensionRange.length; ++i) {
                            if (typeof object.extensionRange[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.extensionRange: object expected");
                            message.extensionRange[i] = $root.google.protobuf.DescriptorProto.ExtensionRange.fromObject(object.extensionRange[i]);
                        }
                    }
                    if (object.oneofDecl) {
                        if (!Array.isArray(object.oneofDecl))
                            throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: array expected");
                        message.oneofDecl = [];
                        for (var i = 0; i < object.oneofDecl.length; ++i) {
                            if (typeof object.oneofDecl[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: object expected");
                            message.oneofDecl[i] = $root.google.protobuf.OneofDescriptorProto.fromObject(object.oneofDecl[i]);
                        }
                    }
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.MessageOptions.fromObject(object.options);
                    }
                    if (object.reservedRange) {
                        if (!Array.isArray(object.reservedRange))
                            throw TypeError(".google.protobuf.DescriptorProto.reservedRange: array expected");
                        message.reservedRange = [];
                        for (var i = 0; i < object.reservedRange.length; ++i) {
                            if (typeof object.reservedRange[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.reservedRange: object expected");
                            message.reservedRange[i] = $root.google.protobuf.DescriptorProto.ReservedRange.fromObject(object.reservedRange[i]);
                        }
                    }
                    if (object.reservedName) {
                        if (!Array.isArray(object.reservedName))
                            throw TypeError(".google.protobuf.DescriptorProto.reservedName: array expected");
                        message.reservedName = [];
                        for (var i = 0; i < object.reservedName.length; ++i)
                            message.reservedName[i] = String(object.reservedName[i]);
                    }
                    return message;
                };
    
                /**
                 * Creates a plain object from a DescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.DescriptorProto} message DescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                DescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.field = [];
                        object.nestedType = [];
                        object.enumType = [];
                        object.extensionRange = [];
                        object.extension = [];
                        object.oneofDecl = [];
                        object.reservedRange = [];
                        object.reservedName = [];
                    }
                    if (options.defaults) {
                        object.name = "";
                        object.options = null;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.field && message.field.length) {
                        object.field = [];
                        for (var j = 0; j < message.field.length; ++j)
                            object.field[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.field[j], options);
                    }
                    if (message.nestedType && message.nestedType.length) {
                        object.nestedType = [];
                        for (var j = 0; j < message.nestedType.length; ++j)
                            object.nestedType[j] = $root.google.protobuf.DescriptorProto.toObject(message.nestedType[j], options);
                    }
                    if (message.enumType && message.enumType.length) {
                        object.enumType = [];
                        for (var j = 0; j < message.enumType.length; ++j)
                            object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
                    }
                    if (message.extensionRange && message.extensionRange.length) {
                        object.extensionRange = [];
                        for (var j = 0; j < message.extensionRange.length; ++j)
                            object.extensionRange[j] = $root.google.protobuf.DescriptorProto.ExtensionRange.toObject(message.extensionRange[j], options);
                    }
                    if (message.extension && message.extension.length) {
                        object.extension = [];
                        for (var j = 0; j < message.extension.length; ++j)
                            object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
                    }
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.MessageOptions.toObject(message.options, options);
                    if (message.oneofDecl && message.oneofDecl.length) {
                        object.oneofDecl = [];
                        for (var j = 0; j < message.oneofDecl.length; ++j)
                            object.oneofDecl[j] = $root.google.protobuf.OneofDescriptorProto.toObject(message.oneofDecl[j], options);
                    }
                    if (message.reservedRange && message.reservedRange.length) {
                        object.reservedRange = [];
                        for (var j = 0; j < message.reservedRange.length; ++j)
                            object.reservedRange[j] = $root.google.protobuf.DescriptorProto.ReservedRange.toObject(message.reservedRange[j], options);
                    }
                    if (message.reservedName && message.reservedName.length) {
                        object.reservedName = [];
                        for (var j = 0; j < message.reservedName.length; ++j)
                            object.reservedName[j] = message.reservedName[j];
                    }
                    return object;
                };
    
                /**
                 * Converts this DescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                DescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                DescriptorProto.ExtensionRange = (function() {
    
                    /**
                     * Properties of an ExtensionRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @interface IExtensionRange
                     * @property {number|null} [start] ExtensionRange start
                     * @property {number|null} [end] ExtensionRange end
                     * @property {google.protobuf.IExtensionRangeOptions|null} [options] ExtensionRange options
                     */
    
                    /**
                     * Constructs a new ExtensionRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @classdesc Represents an ExtensionRange.
                     * @implements IExtensionRange
                     * @constructor
                     * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
                     */
                    function ExtensionRange(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ExtensionRange start.
                     * @member {number} start
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     */
                    ExtensionRange.prototype.start = 0;
    
                    /**
                     * ExtensionRange end.
                     * @member {number} end
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     */
                    ExtensionRange.prototype.end = 0;
    
                    /**
                     * ExtensionRange options.
                     * @member {google.protobuf.IExtensionRangeOptions|null|undefined} options
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     */
                    ExtensionRange.prototype.options = null;
    
                    /**
                     * Creates a new ExtensionRange instance using the specified properties.
                     * @function create
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange instance
                     */
                    ExtensionRange.create = function create(properties) {
                        return new ExtensionRange(properties);
                    };
    
                    /**
                     * Encodes the specified ExtensionRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                     * @function encode
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExtensionRange.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.start != null && Object.hasOwnProperty.call(message, "start"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
                        if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
                        if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                            $root.google.protobuf.ExtensionRangeOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ExtensionRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExtensionRange.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an ExtensionRange message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExtensionRange.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.start = reader.int32();
                                break;
                            case 2:
                                message.end = reader.int32();
                                break;
                            case 3:
                                message.options = $root.google.protobuf.ExtensionRangeOptions.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an ExtensionRange message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExtensionRange.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an ExtensionRange message.
                     * @function verify
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ExtensionRange.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.start != null && message.hasOwnProperty("start"))
                            if (!$util.isInteger(message.start))
                                return "start: integer expected";
                        if (message.end != null && message.hasOwnProperty("end"))
                            if (!$util.isInteger(message.end))
                                return "end: integer expected";
                        if (message.options != null && message.hasOwnProperty("options")) {
                            var error = $root.google.protobuf.ExtensionRangeOptions.verify(message.options);
                            if (error)
                                return "options." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an ExtensionRange message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                     */
                    ExtensionRange.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.protobuf.DescriptorProto.ExtensionRange)
                            return object;
                        var message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
                        if (object.start != null)
                            message.start = object.start | 0;
                        if (object.end != null)
                            message.end = object.end | 0;
                        if (object.options != null) {
                            if (typeof object.options !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.ExtensionRange.options: object expected");
                            message.options = $root.google.protobuf.ExtensionRangeOptions.fromObject(object.options);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an ExtensionRange message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.ExtensionRange} message ExtensionRange
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ExtensionRange.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.start = 0;
                            object.end = 0;
                            object.options = null;
                        }
                        if (message.start != null && message.hasOwnProperty("start"))
                            object.start = message.start;
                        if (message.end != null && message.hasOwnProperty("end"))
                            object.end = message.end;
                        if (message.options != null && message.hasOwnProperty("options"))
                            object.options = $root.google.protobuf.ExtensionRangeOptions.toObject(message.options, options);
                        return object;
                    };
    
                    /**
                     * Converts this ExtensionRange to JSON.
                     * @function toJSON
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ExtensionRange.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return ExtensionRange;
                })();
    
                DescriptorProto.ReservedRange = (function() {
    
                    /**
                     * Properties of a ReservedRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @interface IReservedRange
                     * @property {number|null} [start] ReservedRange start
                     * @property {number|null} [end] ReservedRange end
                     */
    
                    /**
                     * Constructs a new ReservedRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @classdesc Represents a ReservedRange.
                     * @implements IReservedRange
                     * @constructor
                     * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
                     */
                    function ReservedRange(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ReservedRange start.
                     * @member {number} start
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @instance
                     */
                    ReservedRange.prototype.start = 0;
    
                    /**
                     * ReservedRange end.
                     * @member {number} end
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @instance
                     */
                    ReservedRange.prototype.end = 0;
    
                    /**
                     * Creates a new ReservedRange instance using the specified properties.
                     * @function create
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange instance
                     */
                    ReservedRange.create = function create(properties) {
                        return new ReservedRange(properties);
                    };
    
                    /**
                     * Encodes the specified ReservedRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                     * @function encode
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReservedRange.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.start != null && Object.hasOwnProperty.call(message, "start"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
                        if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ReservedRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReservedRange.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ReservedRange message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReservedRange.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ReservedRange();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.start = reader.int32();
                                break;
                            case 2:
                                message.end = reader.int32();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ReservedRange message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReservedRange.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ReservedRange message.
                     * @function verify
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ReservedRange.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.start != null && message.hasOwnProperty("start"))
                            if (!$util.isInteger(message.start))
                                return "start: integer expected";
                        if (message.end != null && message.hasOwnProperty("end"))
                            if (!$util.isInteger(message.end))
                                return "end: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a ReservedRange message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                     */
                    ReservedRange.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.protobuf.DescriptorProto.ReservedRange)
                            return object;
                        var message = new $root.google.protobuf.DescriptorProto.ReservedRange();
                        if (object.start != null)
                            message.start = object.start | 0;
                        if (object.end != null)
                            message.end = object.end | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ReservedRange message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.ReservedRange} message ReservedRange
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ReservedRange.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.start = 0;
                            object.end = 0;
                        }
                        if (message.start != null && message.hasOwnProperty("start"))
                            object.start = message.start;
                        if (message.end != null && message.hasOwnProperty("end"))
                            object.end = message.end;
                        return object;
                    };
    
                    /**
                     * Converts this ReservedRange to JSON.
                     * @function toJSON
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ReservedRange.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    return ReservedRange;
                })();
    
                return DescriptorProto;
            })();
    
            protobuf.ExtensionRangeOptions = (function() {
    
                /**
                 * Properties of an ExtensionRangeOptions.
                 * @memberof google.protobuf
                 * @interface IExtensionRangeOptions
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] ExtensionRangeOptions uninterpretedOption
                 */
    
                /**
                 * Constructs a new ExtensionRangeOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents an ExtensionRangeOptions.
                 * @implements IExtensionRangeOptions
                 * @constructor
                 * @param {google.protobuf.IExtensionRangeOptions=} [properties] Properties to set
                 */
                function ExtensionRangeOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ExtensionRangeOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @instance
                 */
                ExtensionRangeOptions.prototype.uninterpretedOption = $util.emptyArray;
    
                /**
                 * Creates a new ExtensionRangeOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {google.protobuf.IExtensionRangeOptions=} [properties] Properties to set
                 * @returns {google.protobuf.ExtensionRangeOptions} ExtensionRangeOptions instance
                 */
                ExtensionRangeOptions.create = function create(properties) {
                    return new ExtensionRangeOptions(properties);
                };
    
                /**
                 * Encodes the specified ExtensionRangeOptions message. Does not implicitly {@link google.protobuf.ExtensionRangeOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {google.protobuf.IExtensionRangeOptions} message ExtensionRangeOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExtensionRangeOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Encodes the specified ExtensionRangeOptions message, length delimited. Does not implicitly {@link google.protobuf.ExtensionRangeOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {google.protobuf.IExtensionRangeOptions} message ExtensionRangeOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExtensionRangeOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes an ExtensionRangeOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.ExtensionRangeOptions} ExtensionRangeOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExtensionRangeOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ExtensionRangeOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes an ExtensionRangeOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.ExtensionRangeOptions} ExtensionRangeOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExtensionRangeOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies an ExtensionRangeOptions message.
                 * @function verify
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExtensionRangeOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };
    
                /**
                 * Creates an ExtensionRangeOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @member