import * as gax from 'google-gax';
import { Callback, CallOptions, Descriptors, ClientOptions } from 'google-gax';
import * as protos from '../../protos/protos';
/**
 *  Each RPC normalizes the partition IDs of the keys in its input entities,
 *  and always returns entities with keys with normalized partition IDs.
 *  This applies to all keys and entities, including those in values, except keys
 *  with both an empty path and an empty or unset partition ID. Normalization of
 *  input keys sets the project ID (if not already set) to the project ID from
 *  the request.
 *
 * @class
 * @memberof v1
 */
export declare class DatastoreClient {
    private _terminated;
    private _opts;
    private _gaxModule;
    private _gaxGrpc;
    private _protos;
    private _defaults;
    auth: gax.GoogleAuth;
    descriptors: Descriptors;
    innerApiCalls: {
        [name: string]: Function;
    };
    datastoreStub?: Promise<{
        [name: string]: Function;
    }>;
    /**
     * Construct an instance of DatastoreClient.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP fallback mode.
     *     In fallback mode, a special browser-compatible transport implementation is used
     *     instead of gRPC transport. In browser context (if the `window` object is defined)
     *     the fallback mode is enabled automatically; set `options.fallback` to `false`
     *     if you need to override this behavior.
     */
    constructor(opts?: ClientOptions);
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize(): Promise<{
        [name: string]: Function;
    }>;
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath(): string;
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint(): string;
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port(): number;
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes(): string[];
    getProjectId(): Promise<string>;
    getProjectId(callback: Callback<string, undefined, undefined>): void;
    lookup(request: protos.google.datastore.v1.ILookupRequest, options?: CallOptions): Promise<[protos.google.datastore.v1.ILookupResponse, protos.google.datastore.v1.ILookupRequest | undefined, {} | undefined]>;
    lookup(request: protos.google.datastore.v1.ILookupRequest, options: CallOptions, callback: Callback<protos.google.datastore.v1.ILookupResponse, protos.google.datastore.v1.ILookupRequest | null | undefined, {} | null | undefined>): void;
    lookup(request: protos.google.datastore.v1.ILookupRequest, callback: Callback<protos.google.datastore.v1.ILookupResponse, protos.google.datastore.v1.ILookupRequest | null | undefined, {} | null | undefined>): void;
    runQuery(request: protos.google.datastore.v1.IRunQueryRequest, options?: CallOptions): Promise<[protos.google.datastore.v1.IRunQueryResponse, protos.google.datastore.v1.IRunQueryRequest | undefined, {} | undefined]>;
    runQuery(request: protos.google.datastore.v1.IRunQueryRequest, options: CallOptions, callback: Callback<protos.google.datastore.v1.IRunQueryResponse, protos.google.datastore.v1.IRunQueryRequest | null | undefined, {} | null | undefined>): void;
    runQuery(request: protos.google.datastore.v1.IRunQueryRequest, callback: Callback<protos.google.datastore.v1.IRunQueryResponse, protos.google.datastore.v1.IRunQueryRequest | null | undefined, {} | null | undefined>): void;
    beginTransaction(request: protos.google.datastore.v1.IBeginTransactionRequest, options?: CallOptions): Promise<[protos.google.datastore.v1.IBeginTransactionResponse, protos.google.datastore.v1.IBeginTransactionRequest | undefined, {} | undefined]>;
    beginTransaction(request: protos.google.datastore.v1.IBeginTransactionRequest, options: CallOptions, callback: Callback<protos.google.datastore.v1.IBeginTransactionResponse, protos.google.datastore.v1.IBeginTransactionRequest | null | undefined, {} | null | undefined>): void;
    beginTransaction(request: protos.google.datastore.v1.IBeginTransactionRequest, callback: Callback<protos.google.datastore.v1.IBeginTransactionResponse, protos.google.datastore.v1.IBeginTransactionRequest | null | undefined, {} | null | undefined>): void;
    commit(request: protos.google.datastore.v1.ICommitRequest, options?: CallOptions): Promise<[protos.google.datastore.v1.ICommitResponse, protos.google.datastore.v1.ICommitRequest | undefined, {} | undefined]>;
    commit(request: protos.google.datastore.v1.ICommitRequest, options: CallOptions, callback: Callback<protos.google.datastore.v1.ICommitResponse, protos.google.datastore.v1.ICommitRequest | null | undefined, {} | null | undefined>): void;
    commit(request: protos.google.datastore.v1.ICommitRequest, callback: Callback<protos.google.datastore.v1.ICommitResponse, protos.google.datastore.v1.ICommitRequest | null | undefined, {} | null | undefined>): void;
    rollback(request: protos.google.datastore.v1.IRollbackRequest, options?: CallOptions): Promise<[protos.google.datastore.v1.IRollbackResponse, protos.google.datastore.v1.IRollbackRequest | undefined, {} | undefined]>;
    rollback(request: protos.google.datastore.v1.IRollbackRequest, options: CallOptions, callback: Callback<protos.google.datastore.v1.IRollbackResponse, protos.google.datastore.v1.IRollbackRequest | null | undefined, {} | null | undefined>): void;
    rollback(request: protos.google.datastore.v1.IRollbackRequest, callback: Callback<protos.google.datastore.v1.IRollbackResponse, protos.google.datastore.v1.IRollbackRequest | null | undefined, {} | null | undefined>): void;
    allocateIds(request: protos.google.datastore.v1.IAllocateIdsRequest, options?: CallOptions): Promise<[protos.google.datastore.v1.IAllocateIdsResponse, protos.google.datastore.v1.IAllocateIdsRequest | undefined, {} | undefined]>;
    allocateIds(request: protos.google.datastore.v1.IAllocateIdsRequest, options: CallOptions, callback: Callback<protos.google.datastore.v1.IAllocateIdsResponse, protos.google.datastore.v1.IAllocateIdsRequest | null | undefined, {} | null | undefined>): void;
    allocateIds(request: protos.google.datastore.v1.IAllocateIdsRequest, callback: Callback<protos.google.datastore.v1.IAllocateIdsResponse, protos.google.datastore.v1.IAllocateIdsRequest | null | undefined, {} | null | undefined>): void;
    reserveIds(request: protos.google.datastore.v1.IReserveIdsRequest, options?: CallOptions): Promise<[protos.google.datastore.v1.IReserveIdsResponse, protos.google.datastore.v1.IReserveIdsRequest | undefined, {} | undefined]>;
    reserveIds(request: protos.google.datastore.v1.IReserveIdsRequest, options: CallOptions, callback: Callback<protos.google.datastore.v1.IReserveIdsResponse, protos.google.datastore.v1.IReserveIdsRequest | null | undefined, {} | null | undefined>): void;
    reserveIds(request: protos.google.datastore.v1.IReserveIdsRequest, callback: Callback<protos.google.datastore.v1.IReserveIdsResponse, protos.google.datastore.v1.IReserveIdsRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close(): Promise<void>;
}
