import { Locality__Output } from './generated/envoy/api/v2/core/Locality';
export declare type PickFirstConfig = {};
export declare type RoundRobinConfig = {};
export interface XdsConfig {
    balancerName: string;
    childPolicy: LoadBalancingConfig[];
    fallbackPolicy: LoadBalancingConfig[];
}
export interface GrpcLbConfig {
    childPolicy: LoadBalancingConfig[];
}
export interface PriorityChild {
    config: LoadBalancingConfig[];
}
export interface PriorityLbConfig {
    children: Map<string, PriorityChild>;
    priorities: string[];
}
export interface WeightedTarget {
    weight: number;
    child_policy: LoadBalancingConfig[];
}
export interface WeightedTargetLbConfig {
    targets: Map<string, WeightedTarget>;
}
export interface EdsLbConfig {
    cluster: string;
    edsServiceName?: string;
    lrsLoadReportingServerName?: string;
    /**
     * This policy's config is expected to be in the format used by the
     * weighted_target policy. Defaults to weighted_target if not specified.
     *
     * This is currently not used because there is currently no other config
     * that has the same format as weighted_target.
     */
    localityPickingPolicy: LoadBalancingConfig[];
    /**
     * Defaults to round_robin if not specified.
     */
    endpointPickingPolicy: LoadBalancingConfig[];
}
export interface CdsLbConfig {
    cluster: string;
}
export interface LrsLbConfig {
    cluster_name: string;
    eds_service_name: string;
    lrs_load_reporting_server_name: string;
    locality: Locality__Output;
    child_policy: LoadBalancingConfig[];
}
export interface PickFirstLoadBalancingConfig {
    name: 'pick_first';
    pick_first: PickFirstConfig;
}
export interface RoundRobinLoadBalancingConfig {
    name: 'round_robin';
    round_robin: RoundRobinConfig;
}
export interface XdsLoadBalancingConfig {
    name: 'xds';
    xds: XdsConfig;
}
export interface GrpcLbLoadBalancingConfig {
    name: 'grpclb';
    grpclb: GrpcLbConfig;
}
export interface PriorityLoadBalancingConfig {
    name: 'priority';
    priority: PriorityLbConfig;
}
export interface WeightedTargetLoadBalancingConfig {
    name: 'weighted_target';
    weighted_target: WeightedTargetLbConfig;
}
export interface EdsLoadBalancingConfig {
    name: 'eds';
    eds: EdsLbConfig;
}
export interface CdsLoadBalancingConfig {
    name: 'cds';
    cds: CdsLbConfig;
}
export interface LrsLoadBalancingConfig {
    name: 'lrs';
    lrs: LrsLbConfig;
}
export declare type LoadBalancingConfig = PickFirstLoadBalancingConfig | RoundRobinLoadBalancingConfig | XdsLoadBalancingConfig | GrpcLbLoadBalancingConfig | PriorityLoadBalancingConfig | WeightedTargetLoadBalancingConfig | EdsLoadBalancingConfig | CdsLoadBalancingConfig | LrsLoadBalancingConfig;
export declare function isRoundRobinLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is RoundRobinLoadBalancingConfig;
export declare function isXdsLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is XdsLoadBalancingConfig;
export declare function isGrpcLbLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is GrpcLbLoadBalancingConfig;
export declare function isPriorityLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is PriorityLoadBalancingConfig;
export declare function isWeightedTargetLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is WeightedTargetLoadBalancingConfig;
export declare function isEdsLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is EdsLoadBalancingConfig;
export declare function isCdsLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is CdsLoadBalancingConfig;
export declare function isLrsLoadBalancingConfig(lbconfig: LoadBalancingConfig): lbconfig is LrsLoadBalancingConfig;
export declare function validateConfig(obj: any): LoadBalancingConfig;
