import * as firebase from 'firebase-admin';
import { Change, CloudFunction, Event, EventContext } from '../cloud-functions';
import { DeploymentOptions } from '../function-configuration';
/** @hidden */
export declare const provider = "google.firestore";
/** @hidden */
export declare const service = "firestore.googleapis.com";
/** @hidden */
export declare const defaultDatabase = "(default)";
export declare type DocumentSnapshot = firebase.firestore.DocumentSnapshot;
export declare type QueryDocumentSnapshot = firebase.firestore.QueryDocumentSnapshot;
/**
 * Select the Firestore document to listen to for events.
 * @param path Full database path to listen to. This includes the name of
 * the collection that the document is a part of. For example, if the
 * collection is named "users" and the document is named "Ada", then the
 * path is "/users/Ada".
 */
export declare function document(path: string): DocumentBuilder;
/** @hidden */
export declare function namespace(namespace: string): NamespaceBuilder;
/** @hidden */
export declare function database(database: string): DatabaseBuilder;
/** @hidden */
export declare function _databaseWithOptions(database: string, options: DeploymentOptions): DatabaseBuilder;
/** @hidden */
export declare function _namespaceWithOptions(namespace: string, options: DeploymentOptions): NamespaceBuilder;
/** @hidden */
export declare function _documentWithOptions(path: string, options: DeploymentOptions): DocumentBuilder;
export declare class DatabaseBuilder {
    private database;
    private options;
    /** @hidden */
    constructor(database: string, options: DeploymentOptions);
    namespace(namespace: string): NamespaceBuilder;
    document(path: string): DocumentBuilder;
}
export declare class NamespaceBuilder {
    private database;
    private options;
    private namespace?;
    /** @hidden */
    constructor(database: string, options: DeploymentOptions, namespace?: string);
    document(path: string): DocumentBuilder;
}
/** @hidden */
export declare function snapshotConstructor(event: Event): DocumentSnapshot;
/** @hidden */
export declare function beforeSnapshotConstructor(event: Event): DocumentSnapshot;
export declare class DocumentBuilder {
    private triggerResource;
    private options;
    /** @hidden */
    constructor(triggerResource: () => string, options: DeploymentOptions);
    /** Respond to all document writes (creates, updates, or deletes). */
    onWrite(handler: (change: Change<DocumentSnapshot>, context: EventContext) => PromiseLike<any> | any): CloudFunction<Change<DocumentSnapshot>>;
    /** Respond only to document updates. */
    onUpdate(handler: (change: Change<QueryDocumentSnapshot>, context: EventContext) => PromiseLike<any> | any): CloudFunction<Change<QueryDocumentSnapshot>>;
    /** Respond only to document creations. */
    onCreate(handler: (snapshot: QueryDocumentSnapshot, context: EventContext) => PromiseLike<any> | any): CloudFunction<QueryDocumentSnapshot>;
    /** Respond only to document deletions. */
    onDelete(handler: (snapshot: QueryDocumentSnapshot, context: EventContext) => PromiseLike<any> | any): CloudFunction<QueryDocumentSnapshot>;
    private onOperation;
}
