import React, {useState, useEffect} from "react"
import PropTypes from "prop-types"
import {ASCENDING} from "../config/global_constants.js"
import {CountryRow} from "./CountryRow"


export const CountriesTable = props => 
{
    const [countries, setCountries] = useState(props.countries)
    const [sortDirection, setSortDirection] = useState(ASCENDING)
    const [sortColumn, setSortColumn] = useState("name")

    useEffect(() => 
    {
        setSortDirection(ASCENDING)
        setCountries(props.countries.sort((a, b) => a["name"] < b["name"]?-1:1))
        setSortColumn("name")        
    }, [countries, props.countries])
	
        
    const handleHeaderClick = e =>
    {     
        if(sortColumn === e.target.id)
        {
            
            setCountries(countries.sort((a, b) => a[e.target.id] < b[e.target.id]?sortDirection:-sortDirection))
            setSortDirection(-sortDirection)
        }
        else
        {
            setCountries(countries.sort((a, b) => a[e.target.id] < b[e.target.id]?-ASCENDING:ASCENDING))
            setSortDirection(ASCENDING)
            setSortColumn(e.target.id)
        } 
    }
    
          
    return ( 
            <div>
              <table id="countriesTable"> 
                <thead>
                  <tr><th id="name" onClick={handleHeaderClick}>Name {(sortColumn === "name" && sortDirection === ASCENDING) ? "▲" : null} {(sortColumn === "name" && sortDirection === -ASCENDING) ? "▼" : null}</th><th id="capital" onClick={handleHeaderClick}>Capital {(sortColumn === "capital" && sortDirection === ASCENDING) ? "▲" : null} {(sortColumn === "capital" && sortDirection === -ASCENDING) ? "▼" : null}</th>{(props.region === "All Regions")?(<th id="region" onClick={handleHeaderClick}>Region {(sortColumn === "region" && sortDirection === ASCENDING) ? "▲" : null} {(sortColumn === "region" && sortDirection === -ASCENDING) ? "▼" : null}</th>):null}<th id="population" onClick={handleHeaderClick} className="population">Population {(sortColumn === "population" && sortDirection === ASCENDING) ? "▲" : null} {(sortColumn === "population" && sortDirection === -ASCENDING) ? "▼" : null}</th></tr>
                </thead> 
                <tbody>
                  {props.countries.map(country => <CountryRow key={country.alpha2Code} country={country} region={props.region}/>)}   
                </tbody>                   
              </table> 
            </div>               
    )
}


CountriesTable.propTypes = {
    countries:PropTypes.array,
    region:PropTypes.string
}