import React, {useState} from "react"
import PropTypes from "prop-types"
import {Modal} from "./Modal"


export const CountryRow = props =>
{
    const [showModal,setShowModal] = useState(false)
      
    const handleRowClick = e =>
    {    
        toggleModal()      
    }
 
 
    const toggleModal = () => 
    {    
        setShowModal(!showModal)
    }
    
        
    return (                 
        <tr onClick={handleRowClick} >
          <td>
            {showModal ? <Modal country = {props.country} closeModal = {toggleModal.bind(this)}/> : null}
            {props.country.name}</td><td>{props.country.capital}</td>{(props.region==="All Regions")?(<td>{props.country.region}</td>):null}<td className="population">{props.country.population}</td>
          </tr>                                  
    )
}


CountryRow.propTypes = {
    country:PropTypes.object,
    closeModal:PropTypes.func
}