import React from "react"
import PropTypes from "prop-types"


export const DropDownRegionsList = props =>
{         
    return (
        <select name="regions" onChange={props.handleRegionsChange}>                         
          {props.regions.map(region => <option key={region} value={region}>{region}</option>)}      
        </select>   
    )
}


DropDownRegionsList.propTypes = {
    regions:PropTypes.array,
    handleRegionsChange:PropTypes.func
}