import React from "react"
import PropTypes from "prop-types"


export const Modal = props =>
{
    const flag = `https://flagcdn.com/256x192/${(props.country.alpha2Code).toLowerCase()}.png`	
    return ( 
        <div id = "modal">
          <div id = "modalContent">
            <h1>{props.country.name}</h1>
            <img id = "flag" src={flag} alt="Country flag"/>
            
            <h2>Capital City</h2>
            <p>{props.country.capital}</p>
            <h2>Population</h2>
            <p>{props.country.population}</p>           
          <div id="exitButton" onClick={props.closeModal}><img src="images/exit.png" alt="Exit button"/></div>
        </div>
      </div>
    )
}


Modal.propTypes = {
    country:PropTypes.object,
    closeModal:PropTypes.func 
}