import React from 'react';
export declare type Omit<T, U> = Pick<T, Exclude<keyof T, keyof U>>;
export declare type ReplaceProps<Inner extends React.ElementType, P> = Omit<React.ComponentPropsWithRef<Inner>, P> & P;
export interface BsPrefixAndClassNameOnlyProps {
    bsPrefix?: string;
    className?: string;
}
export interface BsCustomPrefixProps {
    bsCustomPrefix?: string;
}
export interface BsPrefixProps<As extends React.ElementType = React.ElementType> extends BsPrefixAndClassNameOnlyProps {
    as?: As;
}
export declare type BsPrefixPropsWithChildren<As extends React.ElementType = React.ElementType> = React.PropsWithChildren<BsPrefixProps<As>>;
export interface BsPrefixRefForwardingComponent<TInitial extends React.ElementType, P = unknown> {
    <As extends React.ElementType = TInitial>(props: React.PropsWithChildren<ReplaceProps<As, BsPrefixProps<As> & P>>, context?: any): React.ReactElement | null;
    propTypes?: any;
    contextTypes?: any;
    defaultProps?: Partial<P>;
    displayName?: string;
}
export declare class BsPrefixComponent<As extends React.ElementType, P = unknown> extends React.Component<ReplaceProps<As, BsPrefixProps<As> & P>> {
}
export declare type BsPrefixComponentClass<As extends React.ElementType, P = unknown> = React.ComponentClass<ReplaceProps<As, BsPrefixProps<As> & P>>;
export declare type SelectCallback = (eventKey: string | null, e: React.SyntheticEvent<unknown>) => void;
export interface TransitionCallbacks {
    onEnter?(node: HTMLElement): any;
    onEntered?(node: HTMLElement): any;
    onEntering?(node: HTMLElement): any;
    onExit?(node: HTMLElement): any;
    onExited?(node: HTMLElement): any;
    onExiting?(node: HTMLElement): any;
}
export declare type TransitionComponent = React.ComponentType<{
    in?: boolean;
    appear?: boolean;
    children: React.ReactElement;
} & TransitionCallbacks>;
export declare type TransitionType = boolean | TransitionComponent;
