import React, {useState} from "react"
import {Redirect, Link} from "react-router-dom"
import {Button} from "../components/Button"
import {ACCESS_LEVEL_ADMIN, SERVER_HOST} from "../config/global_constants"


import Form from "react-bootstrap/Form"
import axios from "axios"


export const AddCar = props =>
{

    const [model, setModel] = useState(props.model)
    const [colour, setColour] = useState(props.colour)
    const [year, setYear] = useState(props.year)
    const [price, setPrice] = useState(props.price)
    const [selectedFiles, setSelectedFiles] = useState(null)
    const [redirectToDisplayAllCars, setRedirectToDisplayAllCars] = useState(localStorage.accessLevel < ACCESS_LEVEL_ADMIN)


    const handleModelChange = e =>
    {
        setModel(e.target.value)
    }


    const handleColourChange = e =>
    {
        setColour(e.target.value)
    }


    const handleYearChange = e =>
    {
        setYear(e.target.value)
    }


    const handlePriceChange = e =>
    {
        setPrice(e.target.value)
    }


    const handleFileChange = e =>
    {
        setSelectedFiles(e.target.files)
    }


    const handleSubmit = e =>
    {
        e.preventDefault()

        let formData = new FormData()

        formData.append("model", model)
        formData.append("colour", colour)
        formData.append("year", year)
        formData.append("price", price)

        if(selectedFiles)
        {
            for(let i = 0;
            i < selectedFiles.length; i++)
            {
                formData.append("carPhotos", selectedFiles[i])
            }
        }

        axios.post(`${SERVER_HOST}/cars`, formData, {headers: {"authorization": localStorage.token, "Content-type": "multipart/form-data"}})
        .then(res => setRedirectToDisplayAllCars(true))
        .catch(err => console.log(`${err.response.data}\n${err}`))
    }


    return (
    <div className="form-container"> 
        {redirectToDisplayAllCars ? <Redirect to="/DisplayAllCars"/> : null}                                            
    
        <Form>
            <Form.Group controlId="model">
                <Form.Label>Model</Form.Label>
                <Form.Control autoFocus type="text" name="model" value={model} onChange={handleModelChange} />
            </Form.Group>
    
            <Form.Group controlId="colour">
                <Form.Label>Colour</Form.Label>
                <Form.Control type="text" name="colour" value={colour} onChange={handleColourChange} />
            </Form.Group>
    
            <Form.Group controlId="year">
                <Form.Label>Year</Form.Label>
                <Form.Control type="text" name="year" value={year} onChange={handleYearChange} />
            </Form.Group>
    
            <Form.Group controlId="price">
                <Form.Label>Price</Form.Label>
                <Form.Control type="text" name="price" value={price} onChange={handlePriceChange} />
            </Form.Group> 
    
            <Form.Group controlId="photos">
                <Form.Label>Photos</Form.Label>
                <Form.Control type = "file" multiple onChange = {handleFileChange} />
            </Form.Group> 
    
            <Button value="Add" className="green-button" onClick={handleSubmit}/>            
    
            <Link className="red-button" to={"/DisplayAllCars"}>Cancel</Link>
        </Form>
    </div>
    )
}