const router = require(`express`).Router()
const createError = require('http-errors')
const carsModel = require(`../models/cars`)

// read all records
router.get(`/cars`, (req, res) => 
{   
    carsModel.find()
    .then((data) => 
    {
        res.json(data)
    })
})


// Read one record
router.get(`/cars/:id`, (req, res) => 
{
    carsModel.findById(req.params.id)
    .then((data) => 
    {              
        res.json(data)
    })  
})


// Add new record
router.post(`/cars`, (req, res) => 
{
    carsModel.create(req.body) 
    .then((data) => 
    {
        res.json(data)
    })  
})


// Update one record
router.put(`/cars/:id`, (req, res) => 
{
    carsModel.findByIdAndUpdate(req.params.id, {$set: req.body})
    .then((data) => 
    {
        res.json(data)
    })      
})


// Delete one record
router.delete(`/cars/:id`, (req, res) => 
{
    carsModel.findByIdAndDelete(req.params.id)
    .then((data) => 
    {
        res.json(data)
    })      
})

module.exports = router