import React, {useState, useEffect} from "react"
import {Link} from "react-router-dom"
import axios from "axios"
import {CarTable} from "./CarTable"
import {SERVER_HOST} from "../config/global_constants"


export const DisplayAllCars = props =>
{
    const [cars, setCars] = useState([])


    useEffect(() =>
    {
        axios.get(`${SERVER_HOST}/cars`)
        .then(res =>
        {
            setCars(res.data)
        })
        .catch(err => console.log(`${err.response.data}\n${err}`))
    }, [])


    return (
    <div className="form-container">
        <div>
            <Link className="blue-button" to={"/Register"}>Register</Link>  
            <Link className="red-button" to={"/ResetDatabase"}>Reset Database</Link>  <br/><br/><br/>
        </div>
    
        <div className="table-container">
            <CarTable cars={cars} /> 
    
            <div className="add-new-car">
                <Link className="blue-button" to={"/AddCar"}>Add New Car</Link>
            </div>
        </div>
    </div>
    )
}