import React, {useEffect} from "react"
import {Link} from "react-router-dom"
import axios from "axios"
import {ACCESS_LEVEL_GUEST, ACCESS_LEVEL_ADMIN, SERVER_HOST} from "../config/global_constants"


export const CarTableRow = props =>
{
    useEffect(() =>
    {
        props.car.photos.map(photo =>
        {
            return axios.get(`${SERVER_HOST}/cars/photo/${photo.filename}`)
            .then(res =>
            {
                if(res.data)
                {
                    if(res.data.errorMessage)
                    {
                        console.log(res.data.errorMessage)
                    }
                    else
                    {
                        document.getElementById(photo._id).src = `data:;base64,${res.data.image}`
                    }
                }
                else
                {
                    console.log("Record not found")
                }
            })
        })
    }, [props.car.photos])


    return (
    <tr>
        <td>{props.car.model}</td>
        <td>{props.car.colour}</td>
        <td>{props.car.year}</td>
        <td>{props.car.price}</td>
        <td className="carPhotos">
            {props.car.photos.map(photo => <img key={photo._id} id={photo._id} alt=""/>)}
        </td> 
        <td>
            {localStorage.accessLevel > ACCESS_LEVEL_GUEST ? <Link className="green-button" to={"/EditCar/" + props.car._id}>Edit</Link> : null}
            {localStorage.accessLevel >= ACCESS_LEVEL_ADMIN ? <Link className="red-button" to={"/DeleteCar/" + props.car._id}>Delete</Link> : null}   
        </td>
    </tr>
    )
}