/*********************************************
 * Common reference to the script identifier *
 *********************************************/
export declare const SCRIPT_ID = "data-react-paypal-script-id";
export declare const SDK_SETTINGS: {
    DATA_CLIENT_TOKEN: string;
    DATA_USER_ID_TOKEN: string;
    DATA_SDK_INTEGRATION_SOURCE: string;
    DATA_SDK_INTEGRATION_SOURCE_VALUE: string;
    DATA_NAMESPACE: string;
};
export declare const LOAD_SCRIPT_ERROR = "Failed to load the PayPal JS SDK script.";
/****************************
 * Braintree error messages *
 ****************************/
export declare const EMPTY_BRAINTREE_AUTHORIZATION_ERROR_MESSAGE = "Invalid authorization data. Use data-client-token or data-user-id-token to authorize.";
export declare const BRAINTREE_SOURCE: string;
export declare const BRAINTREE_PAYPAL_CHECKOUT_SOURCE: string;
/*********************
 * PayPal namespaces *
 *********************/
export declare const DEFAULT_PAYPAL_NAMESPACE = "paypal";
export declare const DEFAULT_BRAINTREE_NAMESPACE = "braintree";
/*****************
 * Hosted Fields *
 *****************/
export declare const HOSTED_FIELDS_CHILDREN_ERROR = "To use HostedFields you must use it with at least 3 children with types: [number, cvv, expirationDate] includes";
export declare const HOSTED_FIELDS_DUPLICATE_CHILDREN_ERROR = "Cannot use duplicate HostedFields as children";
/*******************
 * Script Provider *
 *******************/
export declare const SCRIPT_PROVIDER_REDUCER_ERROR = "usePayPalScriptReducer must be used within a PayPalScriptProvider";
