import React from "react"
import {BrowserRouter, Switch, Route} from "react-router-dom"
import {Register} from "./components/Register"
import {ResetDatabase} from "./components/ResetDatabase"
import {Login} from "./components/Login"
import {Logout} from "./components/Logout"
import {AddCar} from "./components/AddCar"
import {EditCar} from "./components/EditCar"
import {DeleteCar} from "./components/DeleteCar"
import {DisplayAllCars} from "./components/DisplayAllCars"
import {LoggedInRoute} from "./components/LoggedInRoute"
import {BuyCar} from "./components/BuyCar"
import {PayPalMessage} from "./components/PayPalMessage"
import {ACCESS_LEVEL_GUEST} from "./config/global_constants"


import "./css/App.css"


if(typeof localStorage.accessLevel === "undefined")
{
    localStorage.name = "GUEST"
    localStorage.accessLevel = ACCESS_LEVEL_GUEST
    localStorage.token = null
    localStorage.profilePhoto = null
}


export const App = props =>
{
    return (
    <BrowserRouter>
        <Switch>
        <Route exact path="/Register" component={Register} />
        <Route exact path="/ResetDatabase" component={ResetDatabase} />                    
        <Route exact path="/" component={DisplayAllCars} />
        <Route exact path="/Login" component={Login} />
        <Route exact path="/BuyCar/:id" component={BuyCar} />
        <Route exact path="/PayPalMessage/:messageType/:payPalPaymentID" component={PayPalMessage}/>                     
        <LoggedInRoute exact path="/Logout" component={Logout} />
        <LoggedInRoute exact path="/AddCar" component={AddCar} />
        <LoggedInRoute exact path="/EditCar/:id" component={EditCar} />
        <LoggedInRoute exact path="/DeleteCar/:id" component={DeleteCar} />
        <Route exact path="/DisplayAllCars" component={DisplayAllCars}/> 
        <Route path="*" component={DisplayAllCars}/>                            
        </Switch>
    </BrowserRouter>
    )
}