import React, {useState, useEffect} from "react"
import {Redirect} from "react-router-dom"
import axios from "axios"
import {SERVER_HOST} from "../config/global_constants"


export const DeleteCar = props =>
{
    const [redirectToDisplayAllCars, setRedirectToDisplayAllCars] = useState(false)


    useEffect(() =>
    {
        axios.delete(`${SERVER_HOST}/cars/${props.match.params.id}`, {headers: {"authorization": localStorage.token}})
        .then(res => setRedirectToDisplayAllCars(true))
        .catch(err => console.log(`${err.response.data}\n${err}`))
    }, [props.match.params.id])


    return (
    <div>   
        {redirectToDisplayAllCars ? <Redirect to="/DisplayAllCars"/> : null}                      
    </div>
    )
}