import React from "react"
import {Link} from "react-router-dom"
import {ACCESS_LEVEL_GUEST, ACCESS_LEVEL_ADMIN} from "../config/global_constants"


export const CarTableRow = props =>
{
    return (
    <tr>
        <td>{props.car.model}</td>
        <td>{props.car.colour}</td>
        <td>{props.car.year}</td>
        <td>{props.car.price}</td>
        <td>
            {sessionStorage.accessLevel > ACCESS_LEVEL_GUEST ? <Link className="green-button" to={"/EditCar/" + props.car._id}>Edit</Link> : null}
    
            {sessionStorage.accessLevel >= ACCESS_LEVEL_ADMIN ? <Link className="red-button" to={"/DeleteCar/" + props.car._id}>Delete</Link> : null}   
        </td>
    </tr>
    )
}