import React, {useState, useEffect} from "react"
import {Link} from "react-router-dom"
import axios from "axios"
import {CarTable} from "./CarTable"
import {Logout} from "./Logout"
import {ACCESS_LEVEL_GUEST, ACCESS_LEVEL_ADMIN, SERVER_HOST} from "../config/global_constants"


export const DisplayAllCars = props =>
{
    const [cars, setCars] = useState([])


    useEffect(() =>
    {
        axios.defaults.withCredentials = true // needed for sessions to work
        axios.get(`${SERVER_HOST}/cars`)
        .then(res =>
        {
            setCars(res.data)
        })
        .catch(err => console.log(`${err.response.data}\n${err}`))
    }, [])


    return (
    <div className="form-container">
        {sessionStorage.accessLevel > ACCESS_LEVEL_GUEST ?
            <div className="logout">
                <Logout/>
            </div>
            :
            <div>
                <Link className="green-button" to={"/Login"}>Login</Link>
                <Link className="blue-button" to={"/Register"}>Register</Link>  
                <Link className="red-button" to={"/ResetDatabase"}>Reset Database</Link>  <br/><br/><br/></div>
        }
    
        <div className="table-container">
            <CarTable cars={cars} /> 
    
            {sessionStorage.accessLevel >= ACCESS_LEVEL_ADMIN ?
            <div className="add-new-car">
                <Link className="blue-button" to={"/AddCar"}>Add New Car</Link>
            </div>
                :
                null
            }
        </div>
    </div>
    )
}