import React from "react"
import {BrowserRouter, Switch, Route} from "react-router-dom"
import {AddCar} from "./components/AddCar"
import {EditCar} from "./components/EditCar"
import {DeleteCar} from "./components/DeleteCar"
import {DisplayAllCars} from "./components/DisplayAllCars"


import "bootstrap/dist/css/bootstrap.css"
import "./css/App.css"


export const App = props =>
{
    return (
    <BrowserRouter>
        <Switch>                 
        <Route exact path="/" component={DisplayAllCars} />
        <Route exact path="/AddCar" component={AddCar} />
        <Route exact path="/EditCar/:id" component={EditCar} />
        <Route exact path="/DeleteCar/:id" component={DeleteCar} />
        <Route exact path="/DisplayAllCars" component={DisplayAllCars}/> 
        <Route path="*" component={DisplayAllCars}/>                            
        </Switch>
    </BrowserRouter>
    )
}