import React, {useState, useEffect} from "react"
import {Redirect} from "react-router-dom"
import axios from "axios"
import {SERVER_HOST} from "../config/global_constants"


export const DeleteCar = props =>
{
    const [redirectToDisplayAllCars, setRedirectToDisplayAllCars] = useState(false)
    
    useEffect(() =>
    {
        axios.delete(`${SERVER_HOST}/cars/${props.match.params.id}`)
        .then(res => 
        {
            if(res.data)
            {
                if (res.data.errorMessage)
                {
                    console.log(res.data.errorMessage)    
                }
                else // success
                { 
                    console.log("Record deleted")
                }
                setRedirectToDisplayAllCars(true)
            }
            else 
            {
                console.log("Record not deleted")
            }
        })        
    }, [props.match.params.id])
  
  
        return (
            <div>   
                {redirectToDisplayAllCars ? <Redirect to="/DisplayAllCars"/> : null}                      
            </div>
        )
}