import React, {useState, useEffect} from "react"
import {Link} from "react-router-dom"
import axios from "axios"
import {CarTable} from "./CarTable"
import {SERVER_HOST} from "../config/global_constants"


export const DisplayAllCars = props =>
{
    const [cars, setCars] = useState([])


    useEffect(() =>
    {
        axios.get(`${SERVER_HOST}/cars`)
        .then(res =>
        {
            if(res.data)
            {
                if(res.data.errorMessage)
                {
                    console.log(res.data.errorMessage)
                }
                else
                {
                    console.log("Records read")
                    setCars(res.data)
                }
            }
            else
            {
                console.log("Record not found")
            }
        })
    }, [])


    return (
    <div className="form-container">
        <div className="table-container">
            <CarTable cars={cars} /> 
    
            <div className="add-new-car">
                <Link className="blue-button" to={"/AddCar"}>Add New Car</Link>
            </div>
        </div>
    </div>
    )
}