import React, {useState, useEffect} from "react"
import Form from "react-bootstrap/Form"
import {Redirect, Link} from "react-router-dom"
import axios from "axios"
import {Button} from "../components/Button"
import {SERVER_HOST} from "../config/global_constants"


export const EditCar = props =>
{
    const [model, setModel] = useState("")
    const [colour, setColour] = useState("")
    const [year, setYear] = useState("")
    const [price, setPrice] = useState("")
    const [redirectToDisplayAllCars, setRedirectToDisplayAllCars] = useState(false)

    useEffect(() =>
    {
        axios.get(`${SERVER_HOST}/cars/${props.match.params.id}`)
        .then(res =>
        {
            if(res.data)
            {
                if(res.data.errorMessage)
                {
                    console.log(res.data.errorMessage)
                }
                else
                {
                    setModel(res.data.model)
                    setColour(res.data.colour)
                    setYear(res.data.year)
                    setPrice(res.data.price)
                }
            }
            else
            {
                console.log(`Record not found`)
            }
        })
    }, [props.match.params.id])


    const handleModelChange = e =>
    {
        setModel(e.target.value)
    }


    const handleColourChange = e =>
    {
        setColour(e.target.value)
    }


    const handleYearChange = e =>
    {
        setYear(e.target.value)
    }


    const handlePriceChange = e =>
    {
        setPrice(e.target.value)
    }


    const handleSubmit = (e) =>
    {
        e.preventDefault()

        const carObject = {
            model: model,
            colour: colour,
            year: year,
            price: price
        }

        axios.put(`${SERVER_HOST}/cars/${props.match.params.id}`, carObject)
        .then(res =>
        {
            if(res.data)
            {
                if(res.data.errorMessage)
                {
                    console.log(res.data.errorMessage)
                }
                else
                {
                    console.log(`Record updated`)
                    setRedirectToDisplayAllCars(true)
                }
            }
            else
            {
                console.log(`Record not updated`)
            }
        })
    }


    return (
    <div className="form-container">
    
        {redirectToDisplayAllCars ? <Redirect to="/DisplayAllCars"/> : null}  
    
        <Form>
            <Form.Group controlId="model">
                <Form.Label>Model</Form.Label>
                <Form.Control autoFocus type="text" name="model" value={model} onChange={handleModelChange} />
            </Form.Group>
    
            <Form.Group controlId="colour">
                <Form.Label>Colour</Form.Label>
                <Form.Control type="text" name="colour" value={colour} onChange={handleColourChange} />
            </Form.Group>
    
            <Form.Group controlId="year">
                <Form.Label>Year</Form.Label>
                <Form.Control type="text" name="year" value={year} onChange={handleYearChange} />
            </Form.Group>
    
            <Form.Group controlId="price">
                <Form.Label>Price</Form.Label>
                <Form.Control type="text" name="price" value={price} onChange={handlePriceChange} />
            </Form.Group>
    
            <Button value="Update" className="green-button" onClick={handleSubmit}/>  
    
            <Link className="red-button" to={"/DisplayAllCars"}>Cancel</Link>
        </Form>
    </div>
    )
}